/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j.binding;

import java.awt.Color;
import javax.swing.text.JTextComponent;
import net.sf.launch4j.binding.Binding;
import net.sf.launch4j.binding.BindingException;
import net.sf.launch4j.binding.IValidatable;
import org.apache.commons.beanutils.BeanUtils;

public class JTextComponentBinding
implements Binding {
    private final String _property;
    private final JTextComponent _textComponent;
    private final String _defaultValue;
    private final Color _validColor;

    public JTextComponentBinding(String property, JTextComponent textComponent, String defaultValue) {
        if (property == null || textComponent == null || defaultValue == null) {
            throw new NullPointerException();
        }
        if (property.equals("")) {
            throw new IllegalArgumentException();
        }
        this._property = property;
        this._textComponent = textComponent;
        this._defaultValue = defaultValue;
        this._validColor = this._textComponent.getBackground();
    }

    public String getProperty() {
        return this._property;
    }

    public void clear(IValidatable bean) {
        this._textComponent.setText(this._defaultValue);
    }

    public void put(IValidatable bean) {
        try {
            String s = BeanUtils.getProperty(bean, this._property);
            this._textComponent.setText(s != null && !s.equals("0") ? s : "");
        }
        catch (Exception e) {
            throw new BindingException(e);
        }
    }

    public void get(IValidatable bean) {
        try {
            BeanUtils.setProperty(bean, this._property, this._textComponent.getText());
        }
        catch (Exception e) {
            throw new BindingException(e);
        }
    }

    public void markValid() {
        this._textComponent.setBackground(this._validColor);
        this._textComponent.requestFocusInWindow();
    }

    public void markInvalid() {
        this._textComponent.setBackground(Binding.INVALID_COLOR);
    }

    public void setEnabled(boolean enabled) {
        this._textComponent.setEnabled(enabled);
    }
}

