/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.open.gui.framework;

import com.jeta.open.gui.framework.JETAComponentCleanser;
import com.jeta.open.gui.framework.JETAController;
import com.jeta.open.gui.framework.JETADialogListener;
import com.jeta.open.gui.framework.JETAPanel;
import com.jeta.open.gui.utils.JETAToolbox;
import com.jeta.open.i18n.I18N;
import com.jeta.open.rules.JETARule;
import com.jeta.open.rules.RuleResult;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.ref.WeakReference;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.Timer;

public class JETADialog
extends JDialog {
    private JPanel m_contentpane;
    private CommandListener m_cmdListener = new CommandListener(this);
    private boolean m_bOk = false;
    private JPanel m_btnPanel;
    private JButton m_okbtn;
    private JButton m_closebtn;
    private JButton m_helpbtn;
    private JETAController m_controller;
    private LinkedList m_validators;
    private JComponent m_initialFocusComponent;
    private JComponent m_primaryPanel;
    private LinkedList m_listeners;
    private Timer m_timer;
    public static final String ID_BUTTON_PANEL = "button.panel";
    public static final String ID_OK = "JETADialog.ok";
    public static final String ID_CANCEL = "JETADialog.cancel";
    static final /* synthetic */ boolean $assertionsDisabled;

    public JETADialog(Dialog dialog, boolean bl) {
        super(dialog, bl);
        this._initialize();
    }

    public JETADialog(Frame frame, boolean bl) {
        super(frame, bl);
        this._initialize();
    }

    public boolean actionPerformed(String string, ActionEvent actionEvent) {
        boolean bl = false;
        JETAController jETAController = this.getController();
        if (jETAController != null) {
            bl = jETAController.actionPerformed(string, actionEvent);
        }
        if (!bl) {
            String string2 = actionEvent.getActionCommand();
            if (string2.equals(ID_OK)) {
                this.cmdOk();
            } else if (string2.equals(ID_CANCEL)) {
                this.cmdCancel();
            }
        }
        return true;
    }

    public void addController(JETAController jETAController) {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void addDialogListener(JETADialogListener jETADialogListener) {
        if (this.m_listeners == null) {
            this.m_listeners = new LinkedList();
        }
        if (!$assertionsDisabled && jETADialogListener == null) {
            throw new AssertionError();
        }
        this.m_listeners.add(jETADialogListener);
    }

    public void addValidator(JETARule jETARule) {
        this.addValidator(null, jETARule);
    }

    public void addValidator(Object object, JETARule jETARule) {
        if (jETARule == null) {
            return;
        }
        if (this.m_validators == null) {
            this.m_validators = new LinkedList();
        }
        if (object == null) {
            this.m_validators.add(new ValidatorRule(jETARule, new Object[0]));
        } else if (object instanceof Object[]) {
            this.m_validators.add(new ValidatorRule(jETARule, (Object[])object));
        } else {
            Object[] objectArray = new Object[]{object};
            this.m_validators.add(new ValidatorRule(jETARule, objectArray));
        }
    }

    public void cmdCancel() {
        this.setOk(false);
        this.dispose();
    }

    public void cmdOk() {
        if (this.validateValidators() && this.validateListeners()) {
            this.setOk(true);
            this.dispose();
        }
    }

    private JPanel createButtonPanel() {
        JETAPanel jETAPanel = new JETAPanel(new FlowLayout(2));
        this.m_okbtn = new JButton(I18N.getLocalizedMessage("Ok"));
        this.m_closebtn = new JButton(I18N.getLocalizedMessage("Cancel"));
        this.m_helpbtn = new JButton(I18N.getLocalizedMessage("Help"));
        this.m_helpbtn.setVisible(false);
        jETAPanel.add(this.m_helpbtn);
        jETAPanel.add(this.m_okbtn);
        jETAPanel.add(this.m_closebtn);
        this.m_btnPanel = jETAPanel;
        this.m_btnPanel.setName(ID_BUTTON_PANEL);
        this.m_okbtn.setActionCommand(ID_OK);
        this.m_okbtn.setName(ID_OK);
        this.m_okbtn.addActionListener(this.m_cmdListener);
        this.m_closebtn.setActionCommand(ID_CANCEL);
        this.m_closebtn.setName(ID_CANCEL);
        this.m_closebtn.addActionListener(this.m_cmdListener);
        return this.m_btnPanel;
    }

    public void dispose() {
        super.dispose();
        JETAComponentCleanser jETAComponentCleanser = new JETAComponentCleanser();
        jETAComponentCleanser.cleanse(this);
        this.m_timer.stop();
        ActionListener[] actionListenerArray = (ActionListener[])this.m_timer.getListeners(ActionListener.class);
        if (actionListenerArray != null) {
            for (int i = 0; i < actionListenerArray.length; ++i) {
                this.m_timer.removeActionListener(actionListenerArray[i]);
            }
        }
        this.m_cmdListener = null;
        this.m_controller = null;
        if (this.m_validators != null) {
            this.m_validators.clear();
        }
        this.m_initialFocusComponent = null;
        if (this.m_listeners != null) {
            this.m_listeners.clear();
        }
        if (this.m_contentpane != null) {
            this.m_contentpane.removeAll();
            this.m_contentpane = null;
        }
        this.m_primaryPanel = null;
    }

    public JPanel getButtonPanel() {
        return this.m_btnPanel;
    }

    public JButton getCloseButton() {
        return this.m_closebtn;
    }

    public JETAController getController() {
        return this.m_controller;
    }

    public Container getDialogContentPanel() {
        return this.m_contentpane;
    }

    public JButton getHelpButton() {
        return this.m_helpbtn;
    }

    public JButton getOkButton() {
        return this.m_okbtn;
    }

    public Dimension getPreferredSize() {
        return this.getPreferredSize(this.getDialogContentPanel().getPreferredSize());
    }

    protected Dimension getPreferredSize(Dimension dimension) {
        Dimension dimension2 = this.m_btnPanel.getPreferredSize();
        Dimension dimension3 = new Dimension(dimension);
        dimension3.height += dimension2.height;
        dimension3.height += JETAToolbox.getTitleBarHeight();
        dimension3.height += JETAToolbox.getFrameBorderThickness();
        dimension3.width += 2 * JETAToolbox.getFrameBorderThickness();
        if (JETAToolbox.isOSX()) {
            dimension3.width -= 6;
        }
        return dimension3;
    }

    public Component getPrimaryPanel() {
        return this.m_primaryPanel;
    }

    protected void _initialize() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(0);
        this.m_contentpane = new JPanel(new BorderLayout());
        container.add((Component)this.m_contentpane, "Center");
        container.add((Component)this.createButtonPanel(), "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JETADialog.this.cmdCancel();
            }

            public void windowOpened(WindowEvent windowEvent) {
                if (JETADialog.this.m_initialFocusComponent != null) {
                    JETADialog.this.m_initialFocusComponent.requestFocus();
                }
            }
        });
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JETADialog.this.updateComponents(actionEvent);
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, true);
        this.getRootPane().getInputMap().put(keyStroke, "CloseAction");
        this.getRootPane().getActionMap().put("CloseAction", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JETADialog.this.cmdCancel();
            }
        });
        keyStroke = KeyStroke.getKeyStroke(10, 0, true);
        this.getRootPane().getInputMap().put(keyStroke, "EnterAction");
        this.getRootPane().getActionMap().put("EnterAction", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JETADialog.this.cmdOk();
            }
        });
        int n = 500;
        this.m_timer = new Timer(n, actionListener);
        this.m_timer.start();
    }

    public boolean isOk() {
        return this.m_bOk;
    }

    public void removeAllControllers() {
    }

    public void setButtonPanelVisible(boolean bl) {
        if (!$assertionsDisabled && bl) {
            throw new AssertionError();
        }
        Container container = this.getContentPane();
        container.remove(this.m_btnPanel);
    }

    public void setCancelEnabled(boolean bl) {
        if (!bl) {
            this.m_closebtn.setEnabled(false);
        }
    }

    public void setCloseText(String string) {
        this.m_closebtn.setText(string);
    }

    public void setFont(Font font) {
        this.m_okbtn.setFont(font);
        this.m_closebtn.setFont(font);
    }

    public void setPrimaryPanel(JComponent jComponent) {
        if (this.m_primaryPanel != null) {
            this.m_contentpane.remove(this.m_primaryPanel);
        }
        this.m_primaryPanel = jComponent;
        this.m_contentpane.add((Component)jComponent, "Center");
    }

    public void setController(JETAController jETAController) {
        this.m_controller = jETAController;
        if (jETAController instanceof JETARule) {
            this.addValidator((JETARule)((Object)jETAController));
        }
    }

    public void setInitialFocusComponent(JComponent jComponent) {
        if (jComponent == null) {
            return;
        }
        this.m_initialFocusComponent = jComponent;
        jComponent.requestFocus();
    }

    protected void setOk(boolean bl) {
        this.m_bOk = bl;
    }

    public void setOkText(String string) {
        this.m_okbtn.setText(string);
    }

    public void setTitle(String string) {
        super.setTitle(string);
    }

    public void showCenter() {
        JETAToolbox.centerWindow(this);
        this.show();
    }

    public void showOkButton(boolean bl) {
        this.m_okbtn.setVisible(bl);
    }

    public void updateComponents(EventObject eventObject) {
        JETAController jETAController = this.getController();
        if (jETAController == null && this.m_primaryPanel != null && this.m_primaryPanel instanceof JETAPanel) {
            jETAController = ((JETAPanel)this.m_primaryPanel).getController();
        }
        if (jETAController != null) {
            jETAController.updateComponents(eventObject);
        }
    }

    protected boolean validateListeners() {
        if (this.m_listeners != null) {
            Iterator iterator = this.m_listeners.iterator();
            while (iterator.hasNext()) {
                JETADialogListener jETADialogListener = (JETADialogListener)iterator.next();
                if (jETADialogListener.cmdOk()) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean validateValidators() {
        boolean bl = true;
        if (this.m_validators != null) {
            Iterator iterator = this.m_validators.iterator();
            while (iterator.hasNext()) {
                JETARule jETARule;
                RuleResult ruleResult;
                ValidatorRule validatorRule = (ValidatorRule)iterator.next();
                if (validatorRule == null || (ruleResult = (jETARule = validatorRule.getRule()).check(validatorRule.getParameters())) == null) continue;
                if (ruleResult.getCode() == -1) {
                    String string = I18N.getLocalizedMessage("Error");
                    JOptionPane.showMessageDialog(this, ruleResult.getMessage(), string, 0);
                    bl = false;
                    break;
                }
                if (ruleResult.getCode() != -2) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    static {
        $assertionsDisabled = !JETADialog.class.desiredAssertionStatus();
    }

    static class ValidatorRule {
        private JETARule m_rule;
        private Object[] m_parameters;

        public ValidatorRule(JETARule jETARule, Object[] objectArray) {
            this.m_rule = jETARule;
            this.m_parameters = objectArray;
        }

        public Object[] getParameters() {
            return this.m_parameters;
        }

        public JETARule getRule() {
            return this.m_rule;
        }
    }

    static class CommandListener
    implements ActionListener {
        private WeakReference m_dlgref;

        public CommandListener(JETADialog jETADialog) {
            this.m_dlgref = new WeakReference<JETADialog>(jETADialog);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            JETADialog jETADialog = (JETADialog)this.m_dlgref.get();
            if (jETADialog != null) {
                jETADialog.actionPerformed(string, actionEvent);
            }
        }
    }
}

