/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.os.unix;

import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.os.unix.ShellScript;
import com.izforge.izpack.util.os.unix.UnixHelper;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;

public class UnixUser {
    private String itsName;
    private String itsPasswdDigest;
    private String itsId;
    private String itsGid;
    private String itsDescription;
    private String itsHome;
    private String itsShell;
    private static String XDGDesktopFolderNameScriptFilename;
    private static File XDGDesktopFolderNameScript;

    public String getName() {
        return this.itsName;
    }

    public String getPasswdDigest() {
        return this.itsPasswdDigest;
    }

    public String getId() {
        return this.itsId;
    }

    public String getGid() {
        return this.itsGid;
    }

    public String getDescription() {
        return this.itsDescription;
    }

    public String getHome() {
        return this.itsHome.trim();
    }

    public String getShell() {
        return this.itsShell;
    }

    public UnixUser fromEtcPasswdLine(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        UnixUser unixUser = new UnixUser();
        if (stringTokenizer.hasMoreTokens()) {
            unixUser.itsName = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            unixUser.itsPasswdDigest = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            unixUser.itsId = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            unixUser.itsGid = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            unixUser.itsDescription = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            unixUser.itsHome = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            unixUser.itsShell = stringTokenizer.nextToken();
        }
        return unixUser;
    }

    public String getCreatedXDGDesktopFolderNameScriptFilename() {
        ShellScript shellScript = new ShellScript();
        shellScript.appendln(". " + this.getHome() + File.separator + ".config" + File.separator + "user-dirs.dirs");
        shellScript.appendln();
        shellScript.appendln("echo $XDG_DESKTOP_DIR");
        String string = this.getClass().getName() + Long.toString(System.currentTimeMillis());
        String string2 = null;
        try {
            string2 = File.createTempFile(string, ".sh").toString();
        }
        catch (IOException iOException) {
            string2 = System.getProperty("java.io.tmpdir", "/tmp") + "/" + string + ".sh";
            iOException.printStackTrace();
        }
        shellScript.write(string2);
        return string2;
    }

    public String getXdgDesktopfolder() {
        File file = new File(this.getHome() + File.separator + ".config" + File.separator + "user-dirs.dirs");
        if (file.exists()) {
            if (XDGDesktopFolderNameScript == null) {
                XDGDesktopFolderNameScriptFilename = this.getCreatedXDGDesktopFolderNameScriptFilename();
            }
            FileExecutor.getExecOutput(new String[]{UnixHelper.getCustomCommand("chmod"), "+x", XDGDesktopFolderNameScriptFilename}, true);
            String string = FileExecutor.getExecOutput(new String[]{UnixHelper.getSuCommand(), this.itsName, "-c", XDGDesktopFolderNameScriptFilename}, true).trim();
            File file2 = new File(XDGDesktopFolderNameScriptFilename);
            file2.delete();
            return string;
        }
        return this.getHome() + File.separator + "Desktop";
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("User: ");
        stringBuffer.append(this.itsName);
        stringBuffer.append(" X: ");
        stringBuffer.append(this.itsPasswdDigest);
        stringBuffer.append(" Id: ");
        stringBuffer.append(this.itsId);
        stringBuffer.append(" Gid: ");
        stringBuffer.append(this.itsGid);
        stringBuffer.append(" Desc.: ");
        stringBuffer.append(this.itsDescription);
        stringBuffer.append(" Home: ");
        stringBuffer.append(this.itsHome);
        stringBuffer.append(" Shell: ");
        stringBuffer.append(this.itsShell);
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        System.out.println(new UnixUser().fromEtcPasswdLine(""));
        System.out.println(new UnixUser().fromEtcPasswdLine("eppelmann.local:x:500:100:Marc L Eppelmann:/mnt/local/home/eppelmann.local:/bin/bash"));
    }
}

