/*
 * Decompiled with CFR 0.152.
 */
package sun.net.httpserver;

import com.sun.net.httpserver.Authenticator;
import com.sun.net.httpserver.Filter;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import sun.net.httpserver.AuthFilter;
import sun.net.httpserver.ServerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HttpContextImpl
extends HttpContext {
    private String path;
    private String protocol;
    private HttpHandler handler;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private ServerImpl server;
    private LinkedList<Filter> sfilters = new LinkedList();
    private LinkedList<Filter> ufilters = new LinkedList();
    private Authenticator authenticator;
    private AuthFilter authfilter;

    HttpContextImpl(String string, String string2, HttpHandler httpHandler, ServerImpl serverImpl) {
        if (string2 == null || string == null || string2.length() < 1 || string2.charAt(0) != '/') {
            throw new IllegalArgumentException("Illegal value for path or protocol");
        }
        this.protocol = string.toLowerCase();
        this.path = string2;
        if (!this.protocol.equals("http") && !this.protocol.equals("https")) {
            throw new IllegalArgumentException("Illegal value for protocol");
        }
        this.handler = httpHandler;
        this.server = serverImpl;
        this.authfilter = new AuthFilter(null);
        this.sfilters.add(this.authfilter);
    }

    @Override
    public HttpHandler getHandler() {
        return this.handler;
    }

    @Override
    public void setHandler(HttpHandler httpHandler) {
        if (httpHandler == null) {
            throw new NullPointerException("Null handler parameter");
        }
        if (this.handler != null) {
            throw new IllegalArgumentException("handler already set");
        }
        this.handler = httpHandler;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public HttpServer getServer() {
        return this.server.getWrapper();
    }

    ServerImpl getServerImpl() {
        return this.server;
    }

    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public List<Filter> getFilters() {
        return this.ufilters;
    }

    List<Filter> getSystemFilters() {
        return this.sfilters;
    }

    @Override
    public Authenticator setAuthenticator(Authenticator authenticator) {
        Authenticator authenticator2 = this.authenticator;
        this.authenticator = authenticator;
        this.authfilter.setAuthenticator(authenticator);
        return authenticator2;
    }

    @Override
    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    Logger getLogger() {
        return this.server.getLogger();
    }
}

