// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/connectors/v1/common.proto

package connectors

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// LaunchStage is a enum to indicate launch stage:
// PREVIEW, GA, DEPRECATED.
type LaunchStage int32

const (
	// LAUNCH_STAGE_UNSPECIFIED.
	LaunchStage_LAUNCH_STAGE_UNSPECIFIED LaunchStage = 0
	// PREVIEW.
	LaunchStage_PREVIEW LaunchStage = 1
	// GA.
	LaunchStage_GA LaunchStage = 2
	// DEPRECATED.
	LaunchStage_DEPRECATED LaunchStage = 3
)

// Enum value maps for LaunchStage.
var (
	LaunchStage_name = map[int32]string{
		0: "LAUNCH_STAGE_UNSPECIFIED",
		1: "PREVIEW",
		2: "GA",
		3: "DEPRECATED",
	}
	LaunchStage_value = map[string]int32{
		"LAUNCH_STAGE_UNSPECIFIED": 0,
		"PREVIEW":                  1,
		"GA":                       2,
		"DEPRECATED":               3,
	}
)

func (x LaunchStage) Enum() *LaunchStage {
	p := new(LaunchStage)
	*p = x
	return p
}

func (x LaunchStage) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LaunchStage) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_connectors_v1_common_proto_enumTypes[0].Descriptor()
}

func (LaunchStage) Type() protoreflect.EnumType {
	return &file_google_cloud_connectors_v1_common_proto_enumTypes[0]
}

func (x LaunchStage) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LaunchStage.Descriptor instead.
func (LaunchStage) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_common_proto_rawDescGZIP(), []int{0}
}

// ValueType indicates the data type of the value.
type ConfigVariableTemplate_ValueType int32

const (
	// Value type is not specified.
	ConfigVariableTemplate_VALUE_TYPE_UNSPECIFIED ConfigVariableTemplate_ValueType = 0
	// Value type is string.
	ConfigVariableTemplate_STRING ConfigVariableTemplate_ValueType = 1
	// Value type is integer.
	ConfigVariableTemplate_INT ConfigVariableTemplate_ValueType = 2
	// Value type is boolean.
	ConfigVariableTemplate_BOOL ConfigVariableTemplate_ValueType = 3
	// Value type is secret.
	ConfigVariableTemplate_SECRET ConfigVariableTemplate_ValueType = 4
	// Value type is enum.
	ConfigVariableTemplate_ENUM ConfigVariableTemplate_ValueType = 5
	// Value type is authorization code.
	ConfigVariableTemplate_AUTHORIZATION_CODE ConfigVariableTemplate_ValueType = 6
)

// Enum value maps for ConfigVariableTemplate_ValueType.
var (
	ConfigVariableTemplate_ValueType_name = map[int32]string{
		0: "VALUE_TYPE_UNSPECIFIED",
		1: "STRING",
		2: "INT",
		3: "BOOL",
		4: "SECRET",
		5: "ENUM",
		6: "AUTHORIZATION_CODE",
	}
	ConfigVariableTemplate_ValueType_value = map[string]int32{
		"VALUE_TYPE_UNSPECIFIED": 0,
		"STRING":                 1,
		"INT":                    2,
		"BOOL":                   3,
		"SECRET":                 4,
		"ENUM":                   5,
		"AUTHORIZATION_CODE":     6,
	}
)

func (x ConfigVariableTemplate_ValueType) Enum() *ConfigVariableTemplate_ValueType {
	p := new(ConfigVariableTemplate_ValueType)
	*p = x
	return p
}

func (x ConfigVariableTemplate_ValueType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ConfigVariableTemplate_ValueType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_connectors_v1_common_proto_enumTypes[1].Descriptor()
}

func (ConfigVariableTemplate_ValueType) Type() protoreflect.EnumType {
	return &file_google_cloud_connectors_v1_common_proto_enumTypes[1]
}

func (x ConfigVariableTemplate_ValueType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ConfigVariableTemplate_ValueType.Descriptor instead.
func (ConfigVariableTemplate_ValueType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_common_proto_rawDescGZIP(), []int{1, 0}
}

// Indicates the state of the config variable.
type ConfigVariableTemplate_State int32

const (
	// Status is unspecified.
	ConfigVariableTemplate_STATE_UNSPECIFIED ConfigVariableTemplate_State = 0
	// Config variable is active
	ConfigVariableTemplate_ACTIVE ConfigVariableTemplate_State = 1
	// Config variable is deprecated.
	ConfigVariableTemplate_DEPRECATED ConfigVariableTemplate_State = 2
)

// Enum value maps for ConfigVariableTemplate_State.
var (
	ConfigVariableTemplate_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "DEPRECATED",
	}
	ConfigVariableTemplate_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"DEPRECATED":        2,
	}
)

func (x ConfigVariableTemplate_State) Enum() *ConfigVariableTemplate_State {
	p := new(ConfigVariableTemplate_State)
	*p = x
	return p
}

func (x ConfigVariableTemplate_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ConfigVariableTemplate_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_connectors_v1_common_proto_enumTypes[2].Descriptor()
}

func (ConfigVariableTemplate_State) Type() protoreflect.EnumType {
	return &file_google_cloud_connectors_v1_common_proto_enumTypes[2]
}

func (x ConfigVariableTemplate_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ConfigVariableTemplate_State.Descriptor instead.
func (ConfigVariableTemplate_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_common_proto_rawDescGZIP(), []int{1, 1}
}

// Supported Principal values.
type RoleGrant_Principal int32

const (
	// Value type is not specified.
	RoleGrant_PRINCIPAL_UNSPECIFIED RoleGrant_Principal = 0
	// Service Account used for Connector workload identity
	// This is either the default service account if unspecified or Service
	// Account provided by Customers through BYOSA.
	RoleGrant_CONNECTOR_SA RoleGrant_Principal = 1
)

// Enum value maps for RoleGrant_Principal.
var (
	RoleGrant_Principal_name = map[int32]string{
		0: "PRINCIPAL_UNSPECIFIED",
		1: "CONNECTOR_SA",
	}
	RoleGrant_Principal_value = map[string]int32{
		"PRINCIPAL_UNSPECIFIED": 0,
		"CONNECTOR_SA":          1,
	}
)

func (x RoleGrant_Principal) Enum() *RoleGrant_Principal {
	p := new(RoleGrant_Principal)
	*p = x
	return p
}

func (x RoleGrant_Principal) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RoleGrant_Principal) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_connectors_v1_common_proto_enumTypes[3].Descriptor()
}

func (RoleGrant_Principal) Type() protoreflect.EnumType {
	return &file_google_cloud_connectors_v1_common_proto_enumTypes[3]
}

func (x RoleGrant_Principal) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RoleGrant_Principal.Descriptor instead.
func (RoleGrant_Principal) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_common_proto_rawDescGZIP(), []int{5, 0}
}

// Resource Type definition.
type RoleGrant_Resource_Type int32

const (
	// Value type is not specified.
	RoleGrant_Resource_TYPE_UNSPECIFIED RoleGrant_Resource_Type = 0
	// GCP Project Resource.
	RoleGrant_Resource_GCP_PROJECT RoleGrant_Resource_Type = 1
	// Any GCP Resource which is identified uniquely by IAM.
	RoleGrant_Resource_GCP_RESOURCE RoleGrant_Resource_Type = 2
	// GCP Secret Resource.
	RoleGrant_Resource_GCP_SECRETMANAGER_SECRET RoleGrant_Resource_Type = 3
	// GCP Secret Version Resource.
	RoleGrant_Resource_GCP_SECRETMANAGER_SECRET_VERSION RoleGrant_Resource_Type = 4
)

// Enum value maps for RoleGrant_Resource_Type.
var (
	RoleGrant_Resource_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "GCP_PROJECT",
		2: "GCP_RESOURCE",
		3: "GCP_SECRETMANAGER_SECRET",
		4: "GCP_SECRETMANAGER_SECRET_VERSION",
	}
	RoleGrant_Resource_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED":                 0,
		"GCP_PROJECT":                      1,
		"GCP_RESOURCE":                     2,
		"GCP_SECRETMANAGER_SECRET":         3,
		"GCP_SECRETMANAGER_SECRET_VERSION": 4,
	}
)

func (x RoleGrant_Resource_Type) Enum() *RoleGrant_Resource_Type {
	p := new(RoleGrant_Resource_Type)
	*p = x
	return p
}

func (x RoleGrant_Resource_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RoleGrant_Resource_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_connectors_v1_common_proto_enumTypes[4].Descriptor()
}

func (RoleGrant_Resource_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_connectors_v1_common_proto_enumTypes[4]
}

func (x RoleGrant_Resource_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RoleGrant_Resource_Type.Descriptor instead.
func (RoleGrant_Resource_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_common_proto_rawDescGZIP(), []int{5, 0, 0}
}

// Represents the metadata of the long-running operation.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Output only. Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Output only. Human-readable status of the operation, if any.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Output only. Identifies whether the user has requested cancellation
	// of the operation. Operations that have successfully been cancelled
	// have [Operation.error][] value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
	// corresponding to `Code.CANCELLED`.
	RequestedCancellation bool `protobuf:"varint,6,opt,name=requested_cancellation,json=requestedCancellation,proto3" json:"requested_cancellation,omitempty"`
	// Output only. API version used to start the operation.
	ApiVersion string `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_common_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_common_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_common_proto_rawDescGZIP(), []int{0}
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *OperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OperationMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *OperationMetadata) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *OperationMetadata) GetRequestedCancellation() bool {
	if x != nil {
		return x.RequestedCancellation
	}
	return false
}

func (x *OperationMetadata) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

// ConfigVariableTemplate provides metadata about a `ConfigVariable` that is
// used in a Connection.
type ConfigVariableTemplate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key of the config variable.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Type of the parameter: string, int, bool etc.
	// consider custom type for the benefit for the validation.
	ValueType ConfigVariableTemplate_ValueType `protobuf:"varint,2,opt,name=value_type,json=valueType,proto3,enum=google.cloud.connectors.v1.ConfigVariableTemplate_ValueType" json:"value_type,omitempty"`
	// Display name of the parameter.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Description.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Regular expression in RE2 syntax used for validating the `value` of a
	// `ConfigVariable`.
	ValidationRegex string `protobuf:"bytes,5,opt,name=validation_regex,json=validationRegex,proto3" json:"validation_regex,omitempty"`
	// Flag represents that this `ConfigVariable` must be provided for a
	// connection.
	Required bool `protobuf:"varint,6,opt,name=required,proto3" json:"required,omitempty"`
	// Role grant configuration for the config variable.
	RoleGrant *RoleGrant `protobuf:"bytes,7,opt,name=role_grant,json=roleGrant,proto3" json:"role_grant,omitempty"`
	// Enum options. To be populated if `ValueType` is `ENUM`
	EnumOptions []*EnumOption `protobuf:"bytes,8,rep,name=enum_options,json=enumOptions,proto3" json:"enum_options,omitempty"`
	// Authorization code link options. To be populated if `ValueType` is
	// `AUTHORIZATION_CODE`
	AuthorizationCodeLink *AuthorizationCodeLink `protobuf:"bytes,9,opt,name=authorization_code_link,json=authorizationCodeLink,proto3" json:"authorization_code_link,omitempty"`
	// State of the config variable.
	State ConfigVariableTemplate_State `protobuf:"varint,10,opt,name=state,proto3,enum=google.cloud.connectors.v1.ConfigVariableTemplate_State" json:"state,omitempty"`
}

func (x *ConfigVariableTemplate) Reset() {
	*x = ConfigVariableTemplate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_common_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfigVariableTemplate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigVariableTemplate) ProtoMessage() {}

func (x *ConfigVariableTemplate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_common_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigVariableTemplate.ProtoReflect.Descriptor instead.
func (*ConfigVariableTemplate) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_common_proto_rawDescGZIP(), []int{1}
}

func (x *ConfigVariableTemplate) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *ConfigVariableTemplate) GetValueType() ConfigVariableTemplate_ValueType {
	if x != nil {
		return x.ValueType
	}
	return ConfigVariableTemplate_VALUE_TYPE_UNSPECIFIED
}

func (x *ConfigVariableTemplate) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ConfigVariableTemplate) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ConfigVariableTemplate) GetValidationRegex() string {
	if x != nil {
		return x.ValidationRegex
	}
	return ""
}

func (x *ConfigVariableTemplate) GetRequired() bool {
	if x != nil {
		return x.Required
	}
	return false
}

func (x *ConfigVariableTemplate) GetRoleGrant() *RoleGrant {
	if x != nil {
		return x.RoleGrant
	}
	return nil
}

func (x *ConfigVariableTemplate) GetEnumOptions() []*EnumOption {
	if x != nil {
		return x.EnumOptions
	}
	return nil
}

func (x *ConfigVariableTemplate) GetAuthorizationCodeLink() *AuthorizationCodeLink {
	if x != nil {
		return x.AuthorizationCodeLink
	}
	return nil
}

func (x *ConfigVariableTemplate) GetState() ConfigVariableTemplate_State {
	if x != nil {
		return x.State
	}
	return ConfigVariableTemplate_STATE_UNSPECIFIED
}

// Secret provides a reference to entries in Secret Manager.
type Secret struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the secret version in the format,
	// format as: `projects/*/secrets/*/versions/*`.
	SecretVersion string `protobuf:"bytes,1,opt,name=secret_version,json=secretVersion,proto3" json:"secret_version,omitempty"`
}

func (x *Secret) Reset() {
	*x = Secret{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_common_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Secret) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Secret) ProtoMessage() {}

func (x *Secret) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_common_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Secret.ProtoReflect.Descriptor instead.
func (*Secret) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_common_proto_rawDescGZIP(), []int{2}
}

func (x *Secret) GetSecretVersion() string {
	if x != nil {
		return x.SecretVersion
	}
	return ""
}

// EnumOption definition
type EnumOption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Id of the option.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Display name of the option.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *EnumOption) Reset() {
	*x = EnumOption{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_common_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EnumOption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnumOption) ProtoMessage() {}

func (x *EnumOption) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_common_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnumOption.ProtoReflect.Descriptor instead.
func (*EnumOption) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_common_proto_rawDescGZIP(), []int{3}
}

func (x *EnumOption) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *EnumOption) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// ConfigVariable represents a configuration variable present in a Connection.
// or AuthConfig.
type ConfigVariable struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key of the config variable.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Value type of the config variable.
	//
	// Types that are assignable to Value:
	//
	//	*ConfigVariable_IntValue
	//	*ConfigVariable_BoolValue
	//	*ConfigVariable_StringValue
	//	*ConfigVariable_SecretValue
	Value isConfigVariable_Value `protobuf_oneof:"value"`
}

func (x *ConfigVariable) Reset() {
	*x = ConfigVariable{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_common_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfigVariable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigVariable) ProtoMessage() {}

func (x *ConfigVariable) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_common_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigVariable.ProtoReflect.Descriptor instead.
func (*ConfigVariable) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_common_proto_rawDescGZIP(), []int{4}
}

func (x *ConfigVariable) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (m *ConfigVariable) GetValue() isConfigVariable_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *ConfigVariable) GetIntValue() int64 {
	if x, ok := x.GetValue().(*ConfigVariable_IntValue); ok {
		return x.IntValue
	}
	return 0
}

func (x *ConfigVariable) GetBoolValue() bool {
	if x, ok := x.GetValue().(*ConfigVariable_BoolValue); ok {
		return x.BoolValue
	}
	return false
}

func (x *ConfigVariable) GetStringValue() string {
	if x, ok := x.GetValue().(*ConfigVariable_StringValue); ok {
		return x.StringValue
	}
	return ""
}

func (x *ConfigVariable) GetSecretValue() *Secret {
	if x, ok := x.GetValue().(*ConfigVariable_SecretValue); ok {
		return x.SecretValue
	}
	return nil
}

type isConfigVariable_Value interface {
	isConfigVariable_Value()
}

type ConfigVariable_IntValue struct {
	// Value is an integer
	IntValue int64 `protobuf:"varint,2,opt,name=int_value,json=intValue,proto3,oneof"`
}

type ConfigVariable_BoolValue struct {
	// Value is a bool.
	BoolValue bool `protobuf:"varint,3,opt,name=bool_value,json=boolValue,proto3,oneof"`
}

type ConfigVariable_StringValue struct {
	// Value is a string.
	StringValue string `protobuf:"bytes,4,opt,name=string_value,json=stringValue,proto3,oneof"`
}

type ConfigVariable_SecretValue struct {
	// Value is a secret.
	SecretValue *Secret `protobuf:"bytes,5,opt,name=secret_value,json=secretValue,proto3,oneof"`
}

func (*ConfigVariable_IntValue) isConfigVariable_Value() {}

func (*ConfigVariable_BoolValue) isConfigVariable_Value() {}

func (*ConfigVariable_StringValue) isConfigVariable_Value() {}

func (*ConfigVariable_SecretValue) isConfigVariable_Value() {}

// This configuration defines all the Cloud IAM roles that needs to be granted
// to a particular GCP resource for the selected prinicpal like service
// account. These configurations will let UI display to customers what
// IAM roles need to be granted by them. Or these configurations can be used
// by the UI to render a 'grant' button to do the same on behalf of the user.
type RoleGrant struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Prinicipal/Identity for whom the role need to assigned.
	Principal RoleGrant_Principal `protobuf:"varint,1,opt,name=principal,proto3,enum=google.cloud.connectors.v1.RoleGrant_Principal" json:"principal,omitempty"`
	// List of roles that need to be granted.
	Roles []string `protobuf:"bytes,2,rep,name=roles,proto3" json:"roles,omitempty"`
	// Resource on which the roles needs to be granted for the principal.
	Resource *RoleGrant_Resource `protobuf:"bytes,3,opt,name=resource,proto3" json:"resource,omitempty"`
	// Template that UI can use to provide helper text to customers.
	HelperTextTemplate string `protobuf:"bytes,4,opt,name=helper_text_template,json=helperTextTemplate,proto3" json:"helper_text_template,omitempty"`
}

func (x *RoleGrant) Reset() {
	*x = RoleGrant{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_common_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RoleGrant) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RoleGrant) ProtoMessage() {}

func (x *RoleGrant) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_common_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RoleGrant.ProtoReflect.Descriptor instead.
func (*RoleGrant) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_common_proto_rawDescGZIP(), []int{5}
}

func (x *RoleGrant) GetPrincipal() RoleGrant_Principal {
	if x != nil {
		return x.Principal
	}
	return RoleGrant_PRINCIPAL_UNSPECIFIED
}

func (x *RoleGrant) GetRoles() []string {
	if x != nil {
		return x.Roles
	}
	return nil
}

func (x *RoleGrant) GetResource() *RoleGrant_Resource {
	if x != nil {
		return x.Resource
	}
	return nil
}

func (x *RoleGrant) GetHelperTextTemplate() string {
	if x != nil {
		return x.HelperTextTemplate
	}
	return ""
}

// This configuration captures the details required to render an authorization
// link for the OAuth Authorization Code Flow.
type AuthorizationCodeLink struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The base URI the user must click to trigger the authorization code login
	// flow.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// The scopes for which the user will authorize GCP Connectors on the
	// connector data source.
	Scopes []string `protobuf:"bytes,2,rep,name=scopes,proto3" json:"scopes,omitempty"`
	// The client ID assigned to the GCP Connectors OAuth app for the connector
	// data source.
	ClientId string `protobuf:"bytes,3,opt,name=client_id,json=clientId,proto3" json:"client_id,omitempty"`
	// Whether to enable PKCE for the auth code flow.
	EnablePkce bool `protobuf:"varint,4,opt,name=enable_pkce,json=enablePkce,proto3" json:"enable_pkce,omitempty"`
}

func (x *AuthorizationCodeLink) Reset() {
	*x = AuthorizationCodeLink{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_common_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthorizationCodeLink) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthorizationCodeLink) ProtoMessage() {}

func (x *AuthorizationCodeLink) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_common_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthorizationCodeLink.ProtoReflect.Descriptor instead.
func (*AuthorizationCodeLink) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_common_proto_rawDescGZIP(), []int{6}
}

func (x *AuthorizationCodeLink) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *AuthorizationCodeLink) GetScopes() []string {
	if x != nil {
		return x.Scopes
	}
	return nil
}

func (x *AuthorizationCodeLink) GetClientId() string {
	if x != nil {
		return x.ClientId
	}
	return ""
}

func (x *AuthorizationCodeLink) GetEnablePkce() bool {
	if x != nil {
		return x.EnablePkce
	}
	return false
}

// Resource definition
type RoleGrant_Resource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Different types of resource supported.
	Type RoleGrant_Resource_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.connectors.v1.RoleGrant_Resource_Type" json:"type,omitempty"`
	// Template to uniquely represent a GCP resource in a format IAM expects
	// This is a template that can have references to other values provided in
	// the config variable template.
	PathTemplate string `protobuf:"bytes,3,opt,name=path_template,json=pathTemplate,proto3" json:"path_template,omitempty"`
}

func (x *RoleGrant_Resource) Reset() {
	*x = RoleGrant_Resource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_common_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RoleGrant_Resource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RoleGrant_Resource) ProtoMessage() {}

func (x *RoleGrant_Resource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_common_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RoleGrant_Resource.ProtoReflect.Descriptor instead.
func (*RoleGrant_Resource) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_common_proto_rawDescGZIP(), []int{5, 0}
}

func (x *RoleGrant_Resource) GetType() RoleGrant_Resource_Type {
	if x != nil {
		return x.Type
	}
	return RoleGrant_Resource_TYPE_UNSPECIFIED
}

func (x *RoleGrant_Resource) GetPathTemplate() string {
	if x != nil {
		return x.PathTemplate
	}
	return ""
}

var File_google_cloud_connectors_v1_common_proto protoreflect.FileDescriptor

var file_google_cloud_connectors_v1_common_proto_rawDesc = []byte{
	0x0a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xd5, 0x02, 0x0a, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a,
	0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x76, 0x65, 0x72, 0x62,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x76, 0x65, 0x72,
	0x62, 0x12, 0x2a, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3a, 0x0a,
	0x16, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x61, 0x6e, 0x63, 0x65,
	0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x15, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x43, 0x61, 0x6e,
	0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x70, 0x69,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x61, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22,
	0x91, 0x06, 0x0a, 0x16, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62,
	0x6c, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x5b, 0x0a, 0x0a,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x29,
	0x0a, 0x10, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x67,
	0x65, 0x78, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x67, 0x65, 0x78, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x71,
	0x75, 0x69, 0x72, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x72, 0x65, 0x71,
	0x75, 0x69, 0x72, 0x65, 0x64, 0x12, 0x44, 0x0a, 0x0a, 0x72, 0x6f, 0x6c, 0x65, 0x5f, 0x67, 0x72,
	0x61, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x6c, 0x65, 0x47, 0x72, 0x61, 0x6e, 0x74,
	0x52, 0x09, 0x72, 0x6f, 0x6c, 0x65, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x12, 0x49, 0x0a, 0x0c, 0x65,
	0x6e, 0x75, 0x6d, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x6e, 0x75, 0x6d, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x65, 0x6e, 0x75, 0x6d, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x69, 0x0a, 0x17, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x5f, 0x6c, 0x69, 0x6e,
	0x6b, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x15, 0x61, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x4c, 0x69, 0x6e,
	0x6b, 0x12, 0x4e, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x22, 0x74, 0x0a, 0x09, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a,
	0x0a, 0x16, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x54,
	0x52, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x49, 0x4e, 0x54, 0x10, 0x02, 0x12,
	0x08, 0x0a, 0x04, 0x42, 0x4f, 0x4f, 0x4c, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x45, 0x43,
	0x52, 0x45, 0x54, 0x10, 0x04, 0x12, 0x08, 0x0a, 0x04, 0x45, 0x4e, 0x55, 0x4d, 0x10, 0x05, 0x12,
	0x16, 0x0a, 0x12, 0x41, 0x55, 0x54, 0x48, 0x4f, 0x52, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x43, 0x4f, 0x44, 0x45, 0x10, 0x06, 0x22, 0x3a, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56,
	0x45, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x44, 0x45, 0x50, 0x52, 0x45, 0x43, 0x41, 0x54, 0x45,
	0x44, 0x10, 0x02, 0x22, 0x2f, 0x0a, 0x06, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x25, 0x0a,
	0x0e, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x22, 0x3f, 0x0a, 0x0a, 0x45, 0x6e, 0x75, 0x6d, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02,
	0x69, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xd9, 0x01, 0x0a, 0x0e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x1d, 0x0a, 0x09, 0x69, 0x6e,
	0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52,
	0x08, 0x69, 0x6e, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1f, 0x0a, 0x0a, 0x62, 0x6f, 0x6f,
	0x6c, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52,
	0x09, 0x62, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x23, 0x0a, 0x0c, 0x73, 0x74,
	0x72, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x0b, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x47, 0x0a, 0x0c, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x07, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x22, 0xa9, 0x04, 0x0a, 0x09, 0x52, 0x6f, 0x6c, 0x65, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x12,
	0x4d, 0x0a, 0x09, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x6f, 0x6c, 0x65, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x2e, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69,
	0x70, 0x61, 0x6c, 0x52, 0x09, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x12, 0x14,
	0x0a, 0x05, 0x72, 0x6f, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x05, 0x72,
	0x6f, 0x6c, 0x65, 0x73, 0x12, 0x4a, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x6c, 0x65, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x2e, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x12, 0x30, 0x0a, 0x14, 0x68, 0x65, 0x6c, 0x70, 0x65, 0x72, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x5f,
	0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12,
	0x68, 0x65, 0x6c, 0x70, 0x65, 0x72, 0x54, 0x65, 0x78, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x1a, 0xfe, 0x01, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12,
	0x47, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x6c, 0x65, 0x47,
	0x72, 0x61, 0x6e, 0x74, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x61, 0x74, 0x68,
	0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x70, 0x61, 0x74, 0x68, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x22, 0x83, 0x01,
	0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b,
	0x47, 0x43, 0x50, 0x5f, 0x50, 0x52, 0x4f, 0x4a, 0x45, 0x43, 0x54, 0x10, 0x01, 0x12, 0x10, 0x0a,
	0x0c, 0x47, 0x43, 0x50, 0x5f, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x10, 0x02, 0x12,
	0x1c, 0x0a, 0x18, 0x47, 0x43, 0x50, 0x5f, 0x53, 0x45, 0x43, 0x52, 0x45, 0x54, 0x4d, 0x41, 0x4e,
	0x41, 0x47, 0x45, 0x52, 0x5f, 0x53, 0x45, 0x43, 0x52, 0x45, 0x54, 0x10, 0x03, 0x12, 0x24, 0x0a,
	0x20, 0x47, 0x43, 0x50, 0x5f, 0x53, 0x45, 0x43, 0x52, 0x45, 0x54, 0x4d, 0x41, 0x4e, 0x41, 0x47,
	0x45, 0x52, 0x5f, 0x53, 0x45, 0x43, 0x52, 0x45, 0x54, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f,
	0x4e, 0x10, 0x04, 0x22, 0x38, 0x0a, 0x09, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c,
	0x12, 0x19, 0x0a, 0x15, 0x50, 0x52, 0x49, 0x4e, 0x43, 0x49, 0x50, 0x41, 0x4c, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x43,
	0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x4f, 0x52, 0x5f, 0x53, 0x41, 0x10, 0x01, 0x22, 0x7f, 0x0a,
	0x15, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x64, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x63, 0x6f, 0x70,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x73,
	0x12, 0x1b, 0x0a, 0x09, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x1f, 0x0a,
	0x0b, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x6b, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0a, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x6b, 0x63, 0x65, 0x2a, 0x50,
	0x0a, 0x0b, 0x4c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x53, 0x74, 0x61, 0x67, 0x65, 0x12, 0x1c, 0x0a,
	0x18, 0x4c, 0x41, 0x55, 0x4e, 0x43, 0x48, 0x5f, 0x53, 0x54, 0x41, 0x47, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50,
	0x52, 0x45, 0x56, 0x49, 0x45, 0x57, 0x10, 0x01, 0x12, 0x06, 0x0a, 0x02, 0x47, 0x41, 0x10, 0x02,
	0x12, 0x0e, 0x0a, 0x0a, 0x44, 0x45, 0x50, 0x52, 0x45, 0x43, 0x41, 0x54, 0x45, 0x44, 0x10, 0x03,
	0x42, 0x75, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e,
	0x76, 0x31, 0x42, 0x0b, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67,
	0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2f, 0x76, 0x31, 0x3b, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_connectors_v1_common_proto_rawDescOnce sync.Once
	file_google_cloud_connectors_v1_common_proto_rawDescData = file_google_cloud_connectors_v1_common_proto_rawDesc
)

func file_google_cloud_connectors_v1_common_proto_rawDescGZIP() []byte {
	file_google_cloud_connectors_v1_common_proto_rawDescOnce.Do(func() {
		file_google_cloud_connectors_v1_common_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_connectors_v1_common_proto_rawDescData)
	})
	return file_google_cloud_connectors_v1_common_proto_rawDescData
}

var file_google_cloud_connectors_v1_common_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_google_cloud_connectors_v1_common_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_cloud_connectors_v1_common_proto_goTypes = []interface{}{
	(LaunchStage)(0),                      // 0: google.cloud.connectors.v1.LaunchStage
	(ConfigVariableTemplate_ValueType)(0), // 1: google.cloud.connectors.v1.ConfigVariableTemplate.ValueType
	(ConfigVariableTemplate_State)(0),     // 2: google.cloud.connectors.v1.ConfigVariableTemplate.State
	(RoleGrant_Principal)(0),              // 3: google.cloud.connectors.v1.RoleGrant.Principal
	(RoleGrant_Resource_Type)(0),          // 4: google.cloud.connectors.v1.RoleGrant.Resource.Type
	(*OperationMetadata)(nil),             // 5: google.cloud.connectors.v1.OperationMetadata
	(*ConfigVariableTemplate)(nil),        // 6: google.cloud.connectors.v1.ConfigVariableTemplate
	(*Secret)(nil),                        // 7: google.cloud.connectors.v1.Secret
	(*EnumOption)(nil),                    // 8: google.cloud.connectors.v1.EnumOption
	(*ConfigVariable)(nil),                // 9: google.cloud.connectors.v1.ConfigVariable
	(*RoleGrant)(nil),                     // 10: google.cloud.connectors.v1.RoleGrant
	(*AuthorizationCodeLink)(nil),         // 11: google.cloud.connectors.v1.AuthorizationCodeLink
	(*RoleGrant_Resource)(nil),            // 12: google.cloud.connectors.v1.RoleGrant.Resource
	(*timestamppb.Timestamp)(nil),         // 13: google.protobuf.Timestamp
}
var file_google_cloud_connectors_v1_common_proto_depIdxs = []int32{
	13, // 0: google.cloud.connectors.v1.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	13, // 1: google.cloud.connectors.v1.OperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	1,  // 2: google.cloud.connectors.v1.ConfigVariableTemplate.value_type:type_name -> google.cloud.connectors.v1.ConfigVariableTemplate.ValueType
	10, // 3: google.cloud.connectors.v1.ConfigVariableTemplate.role_grant:type_name -> google.cloud.connectors.v1.RoleGrant
	8,  // 4: google.cloud.connectors.v1.ConfigVariableTemplate.enum_options:type_name -> google.cloud.connectors.v1.EnumOption
	11, // 5: google.cloud.connectors.v1.ConfigVariableTemplate.authorization_code_link:type_name -> google.cloud.connectors.v1.AuthorizationCodeLink
	2,  // 6: google.cloud.connectors.v1.ConfigVariableTemplate.state:type_name -> google.cloud.connectors.v1.ConfigVariableTemplate.State
	7,  // 7: google.cloud.connectors.v1.ConfigVariable.secret_value:type_name -> google.cloud.connectors.v1.Secret
	3,  // 8: google.cloud.connectors.v1.RoleGrant.principal:type_name -> google.cloud.connectors.v1.RoleGrant.Principal
	12, // 9: google.cloud.connectors.v1.RoleGrant.resource:type_name -> google.cloud.connectors.v1.RoleGrant.Resource
	4,  // 10: google.cloud.connectors.v1.RoleGrant.Resource.type:type_name -> google.cloud.connectors.v1.RoleGrant.Resource.Type
	11, // [11:11] is the sub-list for method output_type
	11, // [11:11] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_google_cloud_connectors_v1_common_proto_init() }
func file_google_cloud_connectors_v1_common_proto_init() {
	if File_google_cloud_connectors_v1_common_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_connectors_v1_common_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_common_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConfigVariableTemplate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_common_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Secret); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_common_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EnumOption); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_common_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConfigVariable); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_common_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RoleGrant); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_common_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuthorizationCodeLink); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_common_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RoleGrant_Resource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_connectors_v1_common_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*ConfigVariable_IntValue)(nil),
		(*ConfigVariable_BoolValue)(nil),
		(*ConfigVariable_StringValue)(nil),
		(*ConfigVariable_SecretValue)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_connectors_v1_common_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_connectors_v1_common_proto_goTypes,
		DependencyIndexes: file_google_cloud_connectors_v1_common_proto_depIdxs,
		EnumInfos:         file_google_cloud_connectors_v1_common_proto_enumTypes,
		MessageInfos:      file_google_cloud_connectors_v1_common_proto_msgTypes,
	}.Build()
	File_google_cloud_connectors_v1_common_proto = out.File
	file_google_cloud_connectors_v1_common_proto_rawDesc = nil
	file_google_cloud_connectors_v1_common_proto_goTypes = nil
	file_google_cloud_connectors_v1_common_proto_depIdxs = nil
}
