﻿/* ****************************************************************************

 * eID Middleware Project.
 * Copyright (C) 2008-2013 FedICT.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version
 * 3.0 as published by the Free Software Foundation.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, see
 * http://www.gnu.org/licenses/.

**************************************************************************** */
/**
* ATTENTION: THIS FILE IS GENERATED BY AN EXCEL MACRO
* ALL CHANGES MADE IN THIS CURRENT FILE WILL BE LOST BY NEXT EXPORT
* If you want to add/change a string or a translation,
* please do it in the language.xls file
* and then click on the export button.
* This will generated a whole new file.
*/

#ifndef __DLGS_LANGUAGE_H__
#define __DLGS_LANGUAGE_H__

#include <string>

namespace eIDMW
{

class CLang;

#define DEFINE_LANG_STR(code) static const wchar_t * const LANG_STR_ ## code []

#define LANG_STRCODE_EN L"EN"
#define LANG_STRCODE_NL L"NL"
#define LANG_STRCODE_FR L"FR"
#define LANG_STRCODE_DE L"DE"

typedef enum {
  LANG_EN=0,
  LANG_NL=1,
  LANG_FR=2,
  LANG_DE=3
} tLanguage;

DEFINE_LANG_STR(Yes) = {L"&Yes", L"&Ja", L"&Oui", L"&Ja"};
DEFINE_LANG_STR(No) = {L"&No", L"&Nee", L"&Non", L"&Nein"};
DEFINE_LANG_STR(Ok) = {L"&Ok", L"&Ok", L"O&k", L"&Ok"};
DEFINE_LANG_STR(Cancel) = {L"&Cancel", L"&Annuleren", L"&Annuler", L"&Abbrechen"};
DEFINE_LANG_STR(CancelNo) = {L"&Cancel (No)", L"&Annuleren (Nee)", L"&Annuler", L"&Abbrechen (Nein)"};
DEFINE_LANG_STR(Pin) = {L"PIN", L"PIN", L"PIN", L"PIN"};
DEFINE_LANG_STR(Puk) = {L"PUK", L"PUK", L"PUK", L"PUK"};
DEFINE_LANG_STR(Retry) = {L"&Retry", L"O&pnieuw", L"&Réessayer", L"&Erneut versuchen"};
DEFINE_LANG_STR(Always) = {L"Yes, always", L"Ja, altijd", L"Oui, toujours", L"Ja, immer"};
DEFINE_LANG_STR(Never) = {L"Ne&ver", L"N&ooit", L"&Jamais", L"&Nie"};
DEFINE_LANG_STR(Belpic) = {L"Belpic", L"Belpic", L"Belpic", L"Belpic"};
DEFINE_LANG_STR(Application) = {L"Application:", L"Programma:", L"Application:", L"Anwendung:"};
DEFINE_LANG_STR(Function) = {L"Function:", L"Function:", L"Fonction:", L"Funktion:"};
DEFINE_LANG_STR(AnApplicationWantsToAccessTheCard) = {L"An Application wants to access the card !", L"Een Programma wil toegang tot de kaart !", L"Une application essaye d'accéder à la carte !", L"Eine Anwendung will auf die Karte zugreifen!"};
DEFINE_LANG_STR(ReadIdentityData) = {L"Read Identity data", L"Identiteitsgegevens lezen", L"Lire les données d'identité", L"Identitätsdaten lesen"};
DEFINE_LANG_STR(ReadPhoto) = {L"Read Photo", L"Foto lezen", L"Lire la photo", L"Bild lesen"};
DEFINE_LANG_STR(ReadAddressData) = {L"Read Address data", L"Adresgegevens lezen", L"Lire l'adresse", L"Adressdaten lesen"};
DEFINE_LANG_STR(ReadCertificates) = {L"Read Certificates", L"Certificaten lezen", L"Lire les certificats", L"Zertifikate lesen"};
DEFINE_LANG_STR(ReadUnknownData) = {L"Read Unknown data", L"Onbekende data lezen", L"Lire des données", L"Unbekannte Daten lesen"};
DEFINE_LANG_STR(DoYouWantToAcceptIt) = {L"Do you want to accept it ?", L"Wil U dit toelaten ?", L"Acceptez-vous ?", L"Möchten Sie akzeptieren?"};
DEFINE_LANG_STR(ForAllOperations) = {L"For all operations", L"Voor alle gegevens", L"Pour toutes les opérations", L"Für alle Funktionen"};
DEFINE_LANG_STR(EnterYourPin) = {L"Enter your PIN", L"Geef uw PIN in", L"Entrer votre code PIN", L"PIN eingeben"};
DEFINE_LANG_STR(Asking) = {L"Asking", L"Geef", L"Entrez", L"Eingeben"};
DEFINE_LANG_STR(SigningWith) = {L"Signing with", L"Tekenen met", L"Signez avec", L"Unterschreiben mit"};
DEFINE_LANG_STR(PrivacyFilter) = {L"Privacy Filter", L"Privacy Filter", L"Privacy Filter", L"Datenschutz-Filter"};
DEFINE_LANG_STR(EnterYour) = {L"Enter your", L"Geef Uw", L"Entrez votre", L"Geben Sie Ihre"};
DEFINE_LANG_STR(ForVerification) = {L"for verification", L"voor verificatie", L"pour vérification", L"zwecks Bestätigung"};
DEFINE_LANG_STR(ToUnblock) = {L"to unblock", L"om vrij te geven", L"pour débloquer", L"um freizugeben"};
DEFINE_LANG_STR(Code) = {L"code", L"code", L"code", L"Kennzahl"};
DEFINE_LANG_STR(AndSigning) = {L"and signing", L"en om te tekenen", L"et signature", L"und Unterschrift"};
DEFINE_LANG_STR(AndSign) = {L"and sign", L"and tekenen", L"et signer", L"und unterschreiben"};
DEFINE_LANG_STR(RenewingPinCode) = {L"Renewing PIN code", L"PIN code wijzigen", L"Changement de code", L"PIN-Kennzahl erneuern"};
DEFINE_LANG_STR(CurrentPin) = {L"Current PIN", L"Huidige PIN", L"Code actuel", L"Aktuelle PIN"};
DEFINE_LANG_STR(NewPin) = {L"New PIN", L"Nieuwe PIN", L"Nouveau", L"Neue PIN"};
DEFINE_LANG_STR(ConfirmNewPin) = {L"Confirm new PIN", L"Bevestig nieuwe PIN", L"Confimez", L"Neue PIN bestätigen"};
DEFINE_LANG_STR(EnterYourNewPinCode) = {L"Enter your New PIN code", L"Geef Uw nieuwe PIN code", L"Entrez votre nouveau code PIN", L"Neue PIN-Kennzahl eingeben"};
DEFINE_LANG_STR(EnterYourNewPinCodeAgainToConfirm) = {L"Enter your New PIN code again to confirm", L"Bevestig Uw nieuwe PIN", L"Confimez votre nouveau code PIN", L"Neue PIN-Kennzahl erneut bestätigen"};
DEFINE_LANG_STR(ErrorTheNewPinCodesAreNotIdentical) = {L"Error: The new PIN codes are not identical", L"Fout: de nieuwe PIN codes verschillen", L"Erreur: Les codes PIN ne sont pas identiques", L"Fehler: Die PIN-Kennzahlen sind nicht identisch"};
DEFINE_LANG_STR(RetryEnterYourNewPinCode) = {L"Retry: Enter your New PIN code", L"Geef nogmaals uw nieuwe PIN code", L"Réessayez: Entrez votre nouveau code PIN", L"Erneut versuchen: Neue PIN-Kennzahl eingeben"};
DEFINE_LANG_STR(Bad) = {L"Bad", L"Foute", L"Erreur", L"Fehler"};
DEFINE_LANG_STR(Notification) = {L"Notification", L"Mededeling", L"Notification", L"Meldung"};
DEFINE_LANG_STR(RemainingAttempts) = {L"remaining attempts", L"overblijvende pogingen", L"essais restants", L"übrige Versuche"};
DEFINE_LANG_STR(TryAgainOrCancel) = {L"Try again or cancel?", L"Opnieuw of annuleren?", L"Essayez encore ou annulez", L"Erneut versuchen oder abbrechen?"};
DEFINE_LANG_STR(PinBlocked) = {L"PIN blocked", L"PIN geblokkeerd", L"Code PIN bloqué", L"PIN gesperrt"};
DEFINE_LANG_STR(PinpadInfo) = {L"Pinpad info", L"Pinpad info", L"Pinpad info", L"Pinpad-Info"};
DEFINE_LANG_STR(Message) = {L"Message", L"Message", L"Message", L"Nachricht"};
DEFINE_LANG_STR(SignaturePin) = {L"Signature PIN", L"Handtekening PIN", L"Signature PIN", L"Unterschrift-PIN"};
DEFINE_LANG_STR(AuthenticationPin) = {L"Authentication PIN", L"Authenticatie PIN", L"Authentification PIN", L"Authentisierungs-PIN"};
DEFINE_LANG_STR(TheRootCertificateIsNotCorrect) = {L"The Root Certificate is not correct.", L"Het basiscertificaat is niet correct.", L"Le certificat Root n'est pas correct.", L"Das Root-Zertifikat ist nicht korrekt."};
DEFINE_LANG_STR(ThisMayBeATestCard) = {L"This may be a test card.", L"Dit kan een testkaart zijn.", L"Il s'agit peut-être d'une carte de test.", L"Dies kann eine Testkarte sein."};
DEFINE_LANG_STR(PleaseEnterTheCorrectEidCard) = {L"Please enter the correct eID card.", L"Gelieve de geldige eID kaart in te steken.", L"Insérez une carte valide.", L"Bitte geben Sie die richtige eID-Karte ein."};
DEFINE_LANG_STR(Caution) = {L"Caution:", L"Let op:", L"Attention:", L"Achtung:"};
DEFINE_LANG_STR(YouAreAboutToMakeALegallyBindingElectronic) = {L"You are about to make a legally binding electronic signature with your identity card.", L"U gaat een wettelijk bindende electronische handtekening plaatsen met uw identiteitskaart.", L"Vous allez apposer une signature électronique juridiquement valide avec votre carte d'identité", L"Mit Ihrem Personalausweis werden Sie eine rechtsgültige elektronische Unterschrift eingeben."};
DEFINE_LANG_STR(PleaseEnterYourPin) = {L"Please enter your PIN", L"Geef uw PIN in", L"Entrez votre code PIN", L"Bitte geben Sie Ihre PIN ein"};
DEFINE_LANG_STR(PleaseEnterYourPinOnThePinpadReader) = {L"Please enter your PIN on the pinpad reader", L"Geef uw PIN in op de kaartlezer", L"Entrez votre code PIN sur le clavier du lecteur de carte", L"Bitte geben Sie Ihre PIN am Kartenlesegerät ein"};
DEFINE_LANG_STR(ToContinueOrClickTheCancelButton) = {L"to continue or click the Cancel button.", L"om verder te gaan", L"ou cliquez sur le bouton Annuler.", L"um fortzufahren, oder klicken Sie auf die Schaltfläche \"Abbrechen\"."};
DEFINE_LANG_STR(Warning) = {L"Warning:", L"Waarschuwing:", L"Avertissement:", L"Warnung:"};
DEFINE_LANG_STR(IfYouOnlyWantToLogOnToA) = {L"If you only want to log on to a web site or server, do NOT enter your PIN and click the Cancel button.", L"Als u enkel wil aanloggen op een web site of een server, geef uw PIN NIET in.", L"Si vous désirez seulement vous connecter à un site ou un serveur, n'entrez PAS votre code PIN.", L"Wenn Sie nur auf das Internet oder einen Server gehen möchten, geben Sie bitte Ihre PIN NICHT ein."};
DEFINE_LANG_STR(InOrderToAuthenticateYourself) = {L"in order to authenticate yourself.", L"om u te authentiseren", L"pour vous authentifier.", L"um sich zu authentisieren"};
DEFINE_LANG_STR(ChangeYourPinOnTheReader) = {L"Change your PIN on the reader", L"Verander uw PIN op de lezer", L"Modifiez votre code PIN sur le lecteur de carte", L"Bitte ändern Sie Ihren PIN am Kartenlesegerät"};
DEFINE_LANG_STR(PleaseEnterYourPuk) = {L"Please enter your PUK", L"Geef uw PUK in", L"Entrez votre code PUK", L"Bitte geben Sie Ihren PUK ein"};
DEFINE_LANG_STR(PleaseEnterYourPukOnThePinpadReader) = {L"Please enter your PUK on the pinpad reader", L"Geef uw PUK in op de kaartlezer", L"Entrez votre code PUK sur le clavier du lecteur de carte", L"Bitte geben Sie Ihren PUK am Kartenlesegerät ein"};
DEFINE_LANG_STR(Your) = {L"your", L"uw", L"votre", L"Ihre"};
DEFINE_LANG_STR(ChangeYourPin) = {L"Change your PIN", L"Wijzig uw PIN", L"Modifiez votre code PIN", L"Bitte ändern Sie Ihren PIN"};
DEFINE_LANG_STR(ChangeYourPuk) = {L"Change your PUK", L"Wijzig uw PUK", L"Modifiez votre code PUK", L"Bitte ändern Sie Ihren PUK"};
DEFINE_LANG_STR(OnTheReader) = {L"on the reader", L"op de lezer", L"sur le lecteur de carte", L"am Kartenlesegerät"};
DEFINE_LANG_STR(TheFollowingApplication1IsTrying) = {L"The following application '%1' is trying to read data on the eID card.\n\nDo you allow that?", L"Het volgende programma '%1' tracht gegevens te lezen van de eID kaart.\n\nStaat U dit toe?", L"Cette application '%1' essaye de lire vos données sur la carte eID.\n\nAcceptez-vous?", L"Das folgende Programm '%1' versucht, Daten auf der eID-Karte zu lesen.\n\nErlauben Sie das?"};
DEFINE_LANG_STR(UnknownApplication) = {L"??? Unknown application ???", L"??? Onbekend programma ???", L"??? Application inconnue ???", L"??? Unbekannt Anwendung ???"};
DEFINE_LANG_STR(PathOfTheApplication) = {L"PATH of the application :", L"PATH van het programma :", L"EMPLACEMENT de l'application :", L"PFAD der Anwendung :"};
//DEFINE_LANG_STR(EnterOldNewVerify) = {L"Please enter your old PIN, followed by your new PIN and then enter your new PIN once more for verification purposes.", L"Geef eerst uw oude PIN in, nadien uw nieuwe PIN, en ten slotte ter controle nogmaals uw nieuwe PIN.", L"Veillez d'abord introduire votre ancien code PIN et ensuite votre nouveau code PIN. Pour terminer, veuillez réintroduire votre nouveau code PIN à des fins de vérification.", L"Geben Sie zunächst Ihre alte PIN ein, dann Ihre neue PIN und abschließend zur Kontrolle noch einmal Ihre neue PIN."};
DEFINE_LANG_STR(EnterOldNewVerify) = {L"1) Enter your old PIN and press 'OK'. \n2) Enter your new PIN and press 'OK'.\n3) Enter your new PIN again and press 'OK'.",
																			L"1) Geef uw oude PIN in en druk op 'OK'. \n2) Geef uw nieuwe PIN in en druk op 'OK'.\n3) Geef uw nieuwe PIN opnieuw in en druk op 'OK'.",
																			L"1) Insérez votre ancien code PIN et appuyez sur « OK ».\n2) Insérez votre nouveau code PIN et appuyez sur « OK ».\n3) Insérez une nouvelle fois votre nouveau code PIN et appuyez sur « OK ».",
																			L"1) Geben Sie Ihre alte PIN ein und drücken Sie 'OK'.\n2) Geben Sie Ihre neue PIN ein und drücken Sie 'OK'.\n3) Geben Sie Ihre neue PIN erneut ein und drücken Sie 'OK'."};
DEFINE_LANG_STR(OldSDK35Notification) = {L"This application was built against the Belgium Identity Card SDK, version 3.5.\nThis version is considered deprecated and will not be supported by future versions of the eID middleware.\n\n\nPlease contact the application vendor.",																		
																			L"Deze applicatie is gebouwd met de 'Belgium Identity Card SDK, versie 3.5.\nDeze versie is verouderd en zal door toekomstige versies van de eID-middleware niet langer ondersteund worden\n\n\nGelieve contact op te nemen met de leverancier van de applicatie.",
																			L"Cette application a été développée pour le SDK (kit de développement logiciel) de la carte d’identité belge, version 3.5.\nCette version est considérée comme obsolète et ne sera pas compatible avec les futures versions du middleware eID.\n\n\nVeuillez prendre contact avec le fournisseur de l’application.",
																			L"Diese Anwendung wurde mit dem SDK Belgischer Personalausweis, Version 3.5, entwickelt. \nDiese Version gilt nun als veraltet und wird von zukünftigen Versionen der eID-Middleware nicht unterstützt.\n\n\nBitte wenden Sie sich an den Verkäufer der Anwendung."};

#define GETSTRING_DLG(code) LANG_STR_ ## code[CLang::GetLang()]
#ifndef WIN32
#define GETQSTRING_DLG(code) QString::fromWCharArray(LANG_STR_ ## code[CLang::GetLang()])
#endif

}

#endif // __DLGS_LANGUAGE_H__
