// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v3.21.12
// source: yandex/cloud/airflow/v1/cluster.proto

package airflow

import (
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	v1 "github.com/yandex-cloud/go-genproto/yandex/cloud/logging/v1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Cluster_Status int32

const (
	// Cluster state is unknown.
	Cluster_STATUS_UNKNOWN Cluster_Status = 0
	// Cluster is being created.
	Cluster_CREATING Cluster_Status = 1
	// Cluster is running normally.
	Cluster_RUNNING Cluster_Status = 2
	// Cluster encountered a problem and cannot operate.
	Cluster_ERROR Cluster_Status = 3
	// Cluster is stopping.
	Cluster_STOPPING Cluster_Status = 4
	// Cluster is stopped.
	Cluster_STOPPED Cluster_Status = 5
	// Cluster is starting.
	Cluster_STARTING Cluster_Status = 6
	// Cluster is being updated.
	Cluster_UPDATING Cluster_Status = 7
)

// Enum value maps for Cluster_Status.
var (
	Cluster_Status_name = map[int32]string{
		0: "STATUS_UNKNOWN",
		1: "CREATING",
		2: "RUNNING",
		3: "ERROR",
		4: "STOPPING",
		5: "STOPPED",
		6: "STARTING",
		7: "UPDATING",
	}
	Cluster_Status_value = map[string]int32{
		"STATUS_UNKNOWN": 0,
		"CREATING":       1,
		"RUNNING":        2,
		"ERROR":          3,
		"STOPPING":       4,
		"STOPPED":        5,
		"STARTING":       6,
		"UPDATING":       7,
	}
)

func (x Cluster_Status) Enum() *Cluster_Status {
	p := new(Cluster_Status)
	*p = x
	return p
}

func (x Cluster_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_airflow_v1_cluster_proto_enumTypes[0].Descriptor()
}

func (Cluster_Status) Type() protoreflect.EnumType {
	return &file_yandex_cloud_airflow_v1_cluster_proto_enumTypes[0]
}

func (x Cluster_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_Status.Descriptor instead.
func (Cluster_Status) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_airflow_v1_cluster_proto_rawDescGZIP(), []int{0, 0}
}

// Apache Airflow cluster.
type Cluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unique ID of the Apache Airflow cluster.
	// This ID is assigned by Cloud during cluster creation.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the folder that the Apache Airflow cluster belongs to.
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The time when the Apache Airflow cluster was created.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Name of the Apache Airflow cluster.
	// The name is unique within the folder. 1-64 characters long.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the Apache Airflow cluster. 0-256 characters long.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `key:value` pairs. Maximum of 64 per resource.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Monitoring systems relevant to the Apache Airflow cluster.
	Monitoring []*Monitoring `protobuf:"bytes,8,rep,name=monitoring,proto3" json:"monitoring,omitempty"`
	// Configuration of Apache Airflow components.
	Config *ClusterConfig `protobuf:"bytes,9,opt,name=config,proto3" json:"config,omitempty"`
	// Aggregated cluster health.
	Health Health `protobuf:"varint,10,opt,name=health,proto3,enum=yandex.cloud.airflow.v1.Health" json:"health,omitempty"`
	// Cluster status.
	Status Cluster_Status `protobuf:"varint,11,opt,name=status,proto3,enum=yandex.cloud.airflow.v1.Cluster_Status" json:"status,omitempty"`
	// Network related configuration options.
	Network *NetworkConfig `protobuf:"bytes,12,opt,name=network,proto3" json:"network,omitempty"`
	// Parameters of the location and access to the code that will be executed in the cluster.
	CodeSync *CodeSyncConfig `protobuf:"bytes,13,opt,name=code_sync,json=codeSync,proto3" json:"code_sync,omitempty"`
	// Deletion Protection inhibits deletion of the cluster.
	DeletionProtection bool `protobuf:"varint,14,opt,name=deletion_protection,json=deletionProtection,proto3" json:"deletion_protection,omitempty"`
	// Address of Apache Airflow web UI.
	WebserverUrl string `protobuf:"bytes,15,opt,name=webserver_url,json=webserverUrl,proto3" json:"webserver_url,omitempty"`
	// Service account used to access Cloud resources.
	// For more information, see [documentation](/docs/managed-airflow/concepts/impersonation).
	ServiceAccountId string `protobuf:"bytes,16,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	// Cloud Logging configuration.
	Logging *LoggingConfig `protobuf:"bytes,17,opt,name=logging,proto3" json:"logging,omitempty"`
	// Window of maintenance operations.
	MaintenanceWindow *MaintenanceWindow `protobuf:"bytes,18,opt,name=maintenance_window,json=maintenanceWindow,proto3" json:"maintenance_window,omitempty"`
	// Maintenance operation planned at nearest maintenance_window.
	PlannedOperation *MaintenanceOperation `protobuf:"bytes,19,opt,name=planned_operation,json=plannedOperation,proto3" json:"planned_operation,omitempty"`
}

func (x *Cluster) Reset() {
	*x = Cluster{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Cluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster) ProtoMessage() {}

func (x *Cluster) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster.ProtoReflect.Descriptor instead.
func (*Cluster) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_airflow_v1_cluster_proto_rawDescGZIP(), []int{0}
}

func (x *Cluster) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Cluster) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *Cluster) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *Cluster) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Cluster) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Cluster) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Cluster) GetMonitoring() []*Monitoring {
	if x != nil {
		return x.Monitoring
	}
	return nil
}

func (x *Cluster) GetConfig() *ClusterConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Cluster) GetHealth() Health {
	if x != nil {
		return x.Health
	}
	return Health_HEALTH_UNKNOWN
}

func (x *Cluster) GetStatus() Cluster_Status {
	if x != nil {
		return x.Status
	}
	return Cluster_STATUS_UNKNOWN
}

func (x *Cluster) GetNetwork() *NetworkConfig {
	if x != nil {
		return x.Network
	}
	return nil
}

func (x *Cluster) GetCodeSync() *CodeSyncConfig {
	if x != nil {
		return x.CodeSync
	}
	return nil
}

func (x *Cluster) GetDeletionProtection() bool {
	if x != nil {
		return x.DeletionProtection
	}
	return false
}

func (x *Cluster) GetWebserverUrl() string {
	if x != nil {
		return x.WebserverUrl
	}
	return ""
}

func (x *Cluster) GetServiceAccountId() string {
	if x != nil {
		return x.ServiceAccountId
	}
	return ""
}

func (x *Cluster) GetLogging() *LoggingConfig {
	if x != nil {
		return x.Logging
	}
	return nil
}

func (x *Cluster) GetMaintenanceWindow() *MaintenanceWindow {
	if x != nil {
		return x.MaintenanceWindow
	}
	return nil
}

func (x *Cluster) GetPlannedOperation() *MaintenanceOperation {
	if x != nil {
		return x.PlannedOperation
	}
	return nil
}

// Monitoring system.
type Monitoring struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the monitoring system.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the monitoring system.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Link to the monitoring system.
	Link string `protobuf:"bytes,3,opt,name=link,proto3" json:"link,omitempty"`
}

func (x *Monitoring) Reset() {
	*x = Monitoring{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Monitoring) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Monitoring) ProtoMessage() {}

func (x *Monitoring) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Monitoring.ProtoReflect.Descriptor instead.
func (*Monitoring) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_airflow_v1_cluster_proto_rawDescGZIP(), []int{1}
}

func (x *Monitoring) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Monitoring) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Monitoring) GetLink() string {
	if x != nil {
		return x.Link
	}
	return ""
}

type ClusterConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Version of Apache Airflow that runs on the cluster.
	// Use `airlow_version` instead.
	//
	// Deprecated: Marked as deprecated in yandex/cloud/airflow/v1/cluster.proto.
	VersionId string `protobuf:"bytes,1,opt,name=version_id,json=versionId,proto3" json:"version_id,omitempty"`
	// Configuration of the Apache Airflow application itself.
	Airflow *AirflowConfig `protobuf:"bytes,2,opt,name=airflow,proto3" json:"airflow,omitempty"`
	// Configuration of webserver instances.
	Webserver *WebserverConfig `protobuf:"bytes,3,opt,name=webserver,proto3" json:"webserver,omitempty"`
	// Configuration of scheduler instances.
	Scheduler *SchedulerConfig `protobuf:"bytes,4,opt,name=scheduler,proto3" json:"scheduler,omitempty"`
	// Configuration of triggerer instances.
	Triggerer *TriggererConfig `protobuf:"bytes,5,opt,name=triggerer,proto3" json:"triggerer,omitempty"`
	// Configuration of worker instances.
	Worker *WorkerConfig `protobuf:"bytes,6,opt,name=worker,proto3" json:"worker,omitempty"`
	// The list of additional packages installed in the cluster.
	Dependencies *Dependencies `protobuf:"bytes,7,opt,name=dependencies,proto3" json:"dependencies,omitempty"`
	// Configuration of Lockbox Secret Backend.
	Lockbox *LockboxConfig `protobuf:"bytes,8,opt,name=lockbox,proto3" json:"lockbox,omitempty"`
	// Apache Airflow version. Format: "Major.Minor"
	AirflowVersion string `protobuf:"bytes,9,opt,name=airflow_version,json=airflowVersion,proto3" json:"airflow_version,omitempty"`
	// Python version. Format: "Major.Minor"
	PythonVersion string `protobuf:"bytes,10,opt,name=python_version,json=pythonVersion,proto3" json:"python_version,omitempty"`
}

func (x *ClusterConfig) Reset() {
	*x = ClusterConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClusterConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterConfig) ProtoMessage() {}

func (x *ClusterConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterConfig.ProtoReflect.Descriptor instead.
func (*ClusterConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_airflow_v1_cluster_proto_rawDescGZIP(), []int{2}
}

// Deprecated: Marked as deprecated in yandex/cloud/airflow/v1/cluster.proto.
func (x *ClusterConfig) GetVersionId() string {
	if x != nil {
		return x.VersionId
	}
	return ""
}

func (x *ClusterConfig) GetAirflow() *AirflowConfig {
	if x != nil {
		return x.Airflow
	}
	return nil
}

func (x *ClusterConfig) GetWebserver() *WebserverConfig {
	if x != nil {
		return x.Webserver
	}
	return nil
}

func (x *ClusterConfig) GetScheduler() *SchedulerConfig {
	if x != nil {
		return x.Scheduler
	}
	return nil
}

func (x *ClusterConfig) GetTriggerer() *TriggererConfig {
	if x != nil {
		return x.Triggerer
	}
	return nil
}

func (x *ClusterConfig) GetWorker() *WorkerConfig {
	if x != nil {
		return x.Worker
	}
	return nil
}

func (x *ClusterConfig) GetDependencies() *Dependencies {
	if x != nil {
		return x.Dependencies
	}
	return nil
}

func (x *ClusterConfig) GetLockbox() *LockboxConfig {
	if x != nil {
		return x.Lockbox
	}
	return nil
}

func (x *ClusterConfig) GetAirflowVersion() string {
	if x != nil {
		return x.AirflowVersion
	}
	return ""
}

func (x *ClusterConfig) GetPythonVersion() string {
	if x != nil {
		return x.PythonVersion
	}
	return ""
}

type AirflowConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Properties to be passed to Apache Airflow configuration file.
	Config map[string]string `protobuf:"bytes,1,rep,name=config,proto3" json:"config,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *AirflowConfig) Reset() {
	*x = AirflowConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AirflowConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AirflowConfig) ProtoMessage() {}

func (x *AirflowConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AirflowConfig.ProtoReflect.Descriptor instead.
func (*AirflowConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_airflow_v1_cluster_proto_rawDescGZIP(), []int{3}
}

func (x *AirflowConfig) GetConfig() map[string]string {
	if x != nil {
		return x.Config
	}
	return nil
}

type WebserverConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of webserver instances in the cluster.
	Count int64 `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
	// Resources allocated to webserver instances.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
}

func (x *WebserverConfig) Reset() {
	*x = WebserverConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WebserverConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WebserverConfig) ProtoMessage() {}

func (x *WebserverConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WebserverConfig.ProtoReflect.Descriptor instead.
func (*WebserverConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_airflow_v1_cluster_proto_rawDescGZIP(), []int{4}
}

func (x *WebserverConfig) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

func (x *WebserverConfig) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

type SchedulerConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of scheduler instances in the cluster.
	Count int64 `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
	// Resources allocated to scheduler instances.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
}

func (x *SchedulerConfig) Reset() {
	*x = SchedulerConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SchedulerConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SchedulerConfig) ProtoMessage() {}

func (x *SchedulerConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SchedulerConfig.ProtoReflect.Descriptor instead.
func (*SchedulerConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_airflow_v1_cluster_proto_rawDescGZIP(), []int{5}
}

func (x *SchedulerConfig) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

func (x *SchedulerConfig) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

type TriggererConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of triggerer instances in the cluster.
	Count int64 `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
	// Resources allocated to triggerer instances.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
}

func (x *TriggererConfig) Reset() {
	*x = TriggererConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TriggererConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TriggererConfig) ProtoMessage() {}

func (x *TriggererConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TriggererConfig.ProtoReflect.Descriptor instead.
func (*TriggererConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_airflow_v1_cluster_proto_rawDescGZIP(), []int{6}
}

func (x *TriggererConfig) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

func (x *TriggererConfig) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

type WorkerConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The minimum number of worker instances in the cluster.
	MinCount int64 `protobuf:"varint,1,opt,name=min_count,json=minCount,proto3" json:"min_count,omitempty"`
	// The maximum number of worker instances in the cluster.
	MaxCount int64 `protobuf:"varint,2,opt,name=max_count,json=maxCount,proto3" json:"max_count,omitempty"`
	// Resources allocated to worker instances.
	Resources *Resources `protobuf:"bytes,3,opt,name=resources,proto3" json:"resources,omitempty"`
}

func (x *WorkerConfig) Reset() {
	*x = WorkerConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkerConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkerConfig) ProtoMessage() {}

func (x *WorkerConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkerConfig.ProtoReflect.Descriptor instead.
func (*WorkerConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_airflow_v1_cluster_proto_rawDescGZIP(), []int{7}
}

func (x *WorkerConfig) GetMinCount() int64 {
	if x != nil {
		return x.MinCount
	}
	return 0
}

func (x *WorkerConfig) GetMaxCount() int64 {
	if x != nil {
		return x.MaxCount
	}
	return 0
}

func (x *WorkerConfig) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

type Dependencies struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Python packages that are installed in the cluster.
	PipPackages []string `protobuf:"bytes,1,rep,name=pip_packages,json=pipPackages,proto3" json:"pip_packages,omitempty"`
	// System packages that are installed in the cluster.
	DebPackages []string `protobuf:"bytes,2,rep,name=deb_packages,json=debPackages,proto3" json:"deb_packages,omitempty"`
}

func (x *Dependencies) Reset() {
	*x = Dependencies{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Dependencies) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Dependencies) ProtoMessage() {}

func (x *Dependencies) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Dependencies.ProtoReflect.Descriptor instead.
func (*Dependencies) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_airflow_v1_cluster_proto_rawDescGZIP(), []int{8}
}

func (x *Dependencies) GetPipPackages() []string {
	if x != nil {
		return x.PipPackages
	}
	return nil
}

func (x *Dependencies) GetDebPackages() []string {
	if x != nil {
		return x.DebPackages
	}
	return nil
}

type NetworkConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// IDs of VPC network subnets where instances of the cluster are attached.
	SubnetIds []string `protobuf:"bytes,1,rep,name=subnet_ids,json=subnetIds,proto3" json:"subnet_ids,omitempty"`
	// User security groups.
	SecurityGroupIds []string `protobuf:"bytes,2,rep,name=security_group_ids,json=securityGroupIds,proto3" json:"security_group_ids,omitempty"`
}

func (x *NetworkConfig) Reset() {
	*x = NetworkConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkConfig) ProtoMessage() {}

func (x *NetworkConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkConfig.ProtoReflect.Descriptor instead.
func (*NetworkConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_airflow_v1_cluster_proto_rawDescGZIP(), []int{9}
}

func (x *NetworkConfig) GetSubnetIds() []string {
	if x != nil {
		return x.SubnetIds
	}
	return nil
}

func (x *NetworkConfig) GetSecurityGroupIds() []string {
	if x != nil {
		return x.SecurityGroupIds
	}
	return nil
}

type S3Config struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the Object Storage bucket that stores DAG files used in the cluster.
	Bucket string `protobuf:"bytes,3,opt,name=bucket,proto3" json:"bucket,omitempty"`
}

func (x *S3Config) Reset() {
	*x = S3Config{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *S3Config) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*S3Config) ProtoMessage() {}

func (x *S3Config) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use S3Config.ProtoReflect.Descriptor instead.
func (*S3Config) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_airflow_v1_cluster_proto_rawDescGZIP(), []int{10}
}

func (x *S3Config) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

type CodeSyncConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Source:
	//
	//	*CodeSyncConfig_S3
	Source isCodeSyncConfig_Source `protobuf_oneof:"source"`
}

func (x *CodeSyncConfig) Reset() {
	*x = CodeSyncConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CodeSyncConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CodeSyncConfig) ProtoMessage() {}

func (x *CodeSyncConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CodeSyncConfig.ProtoReflect.Descriptor instead.
func (*CodeSyncConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_airflow_v1_cluster_proto_rawDescGZIP(), []int{11}
}

func (m *CodeSyncConfig) GetSource() isCodeSyncConfig_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *CodeSyncConfig) GetS3() *S3Config {
	if x, ok := x.GetSource().(*CodeSyncConfig_S3); ok {
		return x.S3
	}
	return nil
}

type isCodeSyncConfig_Source interface {
	isCodeSyncConfig_Source()
}

type CodeSyncConfig_S3 struct {
	S3 *S3Config `protobuf:"bytes,1,opt,name=s3,proto3,oneof"`
}

func (*CodeSyncConfig_S3) isCodeSyncConfig_Source() {}

type LoggingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Logs generated by the Airflow components are delivered to Cloud Logging.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Destination of log records.
	//
	// Types that are assignable to Destination:
	//
	//	*LoggingConfig_FolderId
	//	*LoggingConfig_LogGroupId
	Destination isLoggingConfig_Destination `protobuf_oneof:"destination"`
	// Minimum log entry level.
	//
	// See [LogLevel.Level] for details.
	MinLevel v1.LogLevel_Level `protobuf:"varint,4,opt,name=min_level,json=minLevel,proto3,enum=yandex.cloud.logging.v1.LogLevel_Level" json:"min_level,omitempty"`
}

func (x *LoggingConfig) Reset() {
	*x = LoggingConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoggingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoggingConfig) ProtoMessage() {}

func (x *LoggingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoggingConfig.ProtoReflect.Descriptor instead.
func (*LoggingConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_airflow_v1_cluster_proto_rawDescGZIP(), []int{12}
}

func (x *LoggingConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (m *LoggingConfig) GetDestination() isLoggingConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *LoggingConfig) GetFolderId() string {
	if x, ok := x.GetDestination().(*LoggingConfig_FolderId); ok {
		return x.FolderId
	}
	return ""
}

func (x *LoggingConfig) GetLogGroupId() string {
	if x, ok := x.GetDestination().(*LoggingConfig_LogGroupId); ok {
		return x.LogGroupId
	}
	return ""
}

func (x *LoggingConfig) GetMinLevel() v1.LogLevel_Level {
	if x != nil {
		return x.MinLevel
	}
	return v1.LogLevel_Level(0)
}

type isLoggingConfig_Destination interface {
	isLoggingConfig_Destination()
}

type LoggingConfig_FolderId struct {
	// Logs should be written to default log group for specified folder.
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3,oneof"`
}

type LoggingConfig_LogGroupId struct {
	// Logs should be written to log group resolved by ID.
	LogGroupId string `protobuf:"bytes,3,opt,name=log_group_id,json=logGroupId,proto3,oneof"`
}

func (*LoggingConfig_FolderId) isLoggingConfig_Destination() {}

func (*LoggingConfig_LogGroupId) isLoggingConfig_Destination() {}

type LockboxConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The setting allows to enable Lockbox Secret Backend.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *LockboxConfig) Reset() {
	*x = LockboxConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LockboxConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LockboxConfig) ProtoMessage() {}

func (x *LockboxConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LockboxConfig.ProtoReflect.Descriptor instead.
func (*LockboxConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_airflow_v1_cluster_proto_rawDescGZIP(), []int{13}
}

func (x *LockboxConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

var File_yandex_cloud_airflow_v1_cluster_proto protoreflect.FileDescriptor

var file_yandex_cloud_airflow_v1_cluster_proto_rawDesc = []byte{
	0x0a, 0x25, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x17, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31,
	0x1a, 0x24, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x29, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x31, 0x2f,
	0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1d, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x27, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6c,
	0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x6c, 0x6f, 0x67, 0x5f, 0x65, 0x6e,
	0x74, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb7, 0x09, 0x0a, 0x07, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x49, 0x64, 0x12, 0x39, 0x0a, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x09, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x44, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x06,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x43, 0x0a, 0x0a, 0x6d, 0x6f,
	0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23,
	0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x6e, 0x67, 0x52, 0x0a, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x12,
	0x3e, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x37, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x1f, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68,
	0x52, 0x06, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x12, 0x3f, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65,
	0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x40, 0x0a, 0x07, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x44, 0x0a, 0x09, 0x63,
	0x6f, 0x64, 0x65, 0x5f, 0x73, 0x79, 0x6e, 0x63, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27,
	0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x64, 0x65, 0x53, 0x79, 0x6e,
	0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x08, 0x63, 0x6f, 0x64, 0x65, 0x53, 0x79, 0x6e,
	0x63, 0x12, 0x2f, 0x0a, 0x13, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72,
	0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12,
	0x64, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x77, 0x65, 0x62, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f,
	0x75, 0x72, 0x6c, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x77, 0x65, 0x62, 0x73, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x55, 0x72, 0x6c, 0x12, 0x36, 0x0a, 0x12, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x10, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x08, 0x8a, 0xc8, 0x31, 0x04, 0x3c, 0x3d, 0x35, 0x30, 0x52, 0x10, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x49, 0x64, 0x12,
	0x40, 0x0a, 0x07, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x67, 0x69,
	0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x07, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e,
	0x67, 0x12, 0x59, 0x0a, 0x12, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65,
	0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x72,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61,
	0x6e, 0x63, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x52, 0x11, 0x6d, 0x61, 0x69, 0x6e, 0x74,
	0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0x5a, 0x0a, 0x11,
	0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x31, 0x2e, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0x79, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x12, 0x0a,
	0x0e, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10,
	0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12,
	0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05,
	0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x4f, 0x50, 0x50,
	0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x45, 0x44,
	0x10, 0x05, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x41, 0x52, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x06,
	0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x07, 0x4a, 0x04,
	0x08, 0x07, 0x10, 0x08, 0x22, 0x56, 0x0a, 0x0a, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x6e, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6c, 0x69, 0x6e, 0x6b,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6c, 0x69, 0x6e, 0x6b, 0x22, 0xfa, 0x04, 0x0a,
	0x0d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x21,
	0x0a, 0x0a, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x12, 0x40, 0x0a, 0x07, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x69, 0x72,
	0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x07, 0x61, 0x69, 0x72, 0x66,
	0x6c, 0x6f, 0x77, 0x12, 0x4c, 0x0a, 0x09, 0x77, 0x65, 0x62, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31,
	0x2e, 0x57, 0x65, 0x62, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x04, 0xe8, 0xc7, 0x31, 0x01, 0x52, 0x09, 0x77, 0x65, 0x62, 0x73, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x12, 0x4c, 0x0a, 0x09, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x04,
	0xe8, 0xc7, 0x31, 0x01, 0x52, 0x09, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x12,
	0x46, 0x0a, 0x09, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x69,
	0x67, 0x67, 0x65, 0x72, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x09, 0x74, 0x72,
	0x69, 0x67, 0x67, 0x65, 0x72, 0x65, 0x72, 0x12, 0x43, 0x0a, 0x06, 0x77, 0x6f, 0x72, 0x6b, 0x65,
	0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x04,
	0xe8, 0xc7, 0x31, 0x01, 0x52, 0x06, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x12, 0x49, 0x0a, 0x0c,
	0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x25, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70,
	0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x52, 0x0c, 0x64, 0x65, 0x70, 0x65, 0x6e,
	0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x12, 0x40, 0x0a, 0x07, 0x6c, 0x6f, 0x63, 0x6b, 0x62,
	0x6f, 0x78, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65,
	0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x6b, 0x62, 0x6f, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x07, 0x6c, 0x6f, 0x63, 0x6b, 0x62, 0x6f, 0x78, 0x12, 0x27, 0x0a, 0x0f, 0x61, 0x69, 0x72,
	0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x79, 0x74, 0x68, 0x6f, 0x6e, 0x5f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x70, 0x79, 0x74, 0x68,
	0x6f, 0x6e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x96, 0x01, 0x0a, 0x0d, 0x41, 0x69,
	0x72, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4a, 0x0a, 0x06, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x39, 0x0a, 0x0b, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0x74, 0x0a, 0x0f, 0x57, 0x65, 0x62, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1f, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x42, 0x09, 0xfa, 0xc7, 0x31, 0x05, 0x31, 0x2d, 0x35, 0x31, 0x32, 0x52,
	0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x22, 0x74, 0x0a, 0x0f, 0x53, 0x63, 0x68, 0x65,
	0x64, 0x75, 0x6c, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1f, 0x0a, 0x05, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x42, 0x09, 0xfa, 0xc7, 0x31, 0x05,
	0x31, 0x2d, 0x35, 0x31, 0x32, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x09,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x22, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x22, 0x74,
	0x0a, 0x0f, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x1f, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03,
	0x42, 0x09, 0xfa, 0xc7, 0x31, 0x05, 0x30, 0x2d, 0x35, 0x31, 0x32, 0x52, 0x05, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x40, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x22, 0xa0, 0x01, 0x0a, 0x0c, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x26, 0x0a, 0x09, 0x6d, 0x69, 0x6e, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x42, 0x09, 0xfa, 0xc7, 0x31, 0x05, 0x30, 0x2d,
	0x35, 0x31, 0x32, 0x52, 0x08, 0x6d, 0x69, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x26, 0x0a,
	0x09, 0x6d, 0x61, 0x78, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03,
	0x42, 0x09, 0xfa, 0xc7, 0x31, 0x05, 0x31, 0x2d, 0x35, 0x31, 0x32, 0x52, 0x08, 0x6d, 0x61, 0x78,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65,
	0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x22, 0x54, 0x0a, 0x0c, 0x44, 0x65, 0x70, 0x65, 0x6e,
	0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x69, 0x70, 0x5f, 0x70,
	0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x70,
	0x69, 0x70, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x65,
	0x62, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x0b, 0x64, 0x65, 0x62, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x22, 0x5c, 0x0a,
	0x0d, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1d,
	0x0a, 0x0a, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x09, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x49, 0x64, 0x73, 0x12, 0x2c, 0x0a,
	0x12, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f,
	0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x73, 0x22, 0x22, 0x0a, 0x08, 0x53,
	0x33, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x16, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x22,
	0x55, 0x0a, 0x0e, 0x43, 0x6f, 0x64, 0x65, 0x53, 0x79, 0x6e, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x33, 0x0a, 0x02, 0x73, 0x33, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x72,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x33, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x48, 0x00, 0x52, 0x02, 0x73, 0x33, 0x42, 0x0e, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x12, 0x04, 0xc0, 0xc1, 0x31, 0x01, 0x22, 0x8b, 0x02, 0x0a, 0x0d, 0x4c, 0x6f, 0x67, 0x67, 0x69,
	0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x12, 0x42, 0x0a, 0x09, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xf2, 0xc7, 0x31, 0x1f, 0x28, 0x5b, 0x61, 0x2d, 0x7a,
	0x41, 0x2d, 0x5a, 0x5d, 0x5b, 0x2d, 0x61, 0x2d, 0x7a, 0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5f,
	0x2e, 0x5d, 0x7b, 0x30, 0x2c, 0x36, 0x33, 0x7d, 0x29, 0x3f, 0x48, 0x00, 0x52, 0x08, 0x66, 0x6f,
	0x6c, 0x64, 0x65, 0x72, 0x49, 0x64, 0x12, 0x47, 0x0a, 0x0c, 0x6c, 0x6f, 0x67, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xf2, 0xc7,
	0x31, 0x1f, 0x28, 0x5b, 0x61, 0x2d, 0x7a, 0x41, 0x2d, 0x5a, 0x5d, 0x5b, 0x2d, 0x61, 0x2d, 0x7a,
	0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5f, 0x2e, 0x5d, 0x7b, 0x30, 0x2c, 0x36, 0x33, 0x7d, 0x29,
	0x3f, 0x48, 0x00, 0x52, 0x0a, 0x6c, 0x6f, 0x67, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x12,
	0x44, 0x0a, 0x09, 0x6d, 0x69, 0x6e, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x27, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x67,
	0x4c, 0x65, 0x76, 0x65, 0x6c, 0x2e, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x08, 0x6d, 0x69, 0x6e,
	0x4c, 0x65, 0x76, 0x65, 0x6c, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x29, 0x0a, 0x0d, 0x4c, 0x6f, 0x63, 0x6b, 0x62, 0x6f, 0x78, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x42,
	0x62, 0x0a, 0x1b, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x70, 0x69, 0x2e, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x5a, 0x43,
	0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x79, 0x61, 0x6e, 0x64, 0x65,
	0x78, 0x2d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6f, 0x2d, 0x67, 0x65, 0x6e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2f, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x61, 0x69, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x31, 0x3b, 0x61, 0x69, 0x72, 0x66,
	0x6c, 0x6f, 0x77, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_yandex_cloud_airflow_v1_cluster_proto_rawDescOnce sync.Once
	file_yandex_cloud_airflow_v1_cluster_proto_rawDescData = file_yandex_cloud_airflow_v1_cluster_proto_rawDesc
)

func file_yandex_cloud_airflow_v1_cluster_proto_rawDescGZIP() []byte {
	file_yandex_cloud_airflow_v1_cluster_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_airflow_v1_cluster_proto_rawDescData = protoimpl.X.CompressGZIP(file_yandex_cloud_airflow_v1_cluster_proto_rawDescData)
	})
	return file_yandex_cloud_airflow_v1_cluster_proto_rawDescData
}

var file_yandex_cloud_airflow_v1_cluster_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_yandex_cloud_airflow_v1_cluster_proto_msgTypes = make([]protoimpl.MessageInfo, 16)
var file_yandex_cloud_airflow_v1_cluster_proto_goTypes = []any{
	(Cluster_Status)(0),           // 0: yandex.cloud.airflow.v1.Cluster.Status
	(*Cluster)(nil),               // 1: yandex.cloud.airflow.v1.Cluster
	(*Monitoring)(nil),            // 2: yandex.cloud.airflow.v1.Monitoring
	(*ClusterConfig)(nil),         // 3: yandex.cloud.airflow.v1.ClusterConfig
	(*AirflowConfig)(nil),         // 4: yandex.cloud.airflow.v1.AirflowConfig
	(*WebserverConfig)(nil),       // 5: yandex.cloud.airflow.v1.WebserverConfig
	(*SchedulerConfig)(nil),       // 6: yandex.cloud.airflow.v1.SchedulerConfig
	(*TriggererConfig)(nil),       // 7: yandex.cloud.airflow.v1.TriggererConfig
	(*WorkerConfig)(nil),          // 8: yandex.cloud.airflow.v1.WorkerConfig
	(*Dependencies)(nil),          // 9: yandex.cloud.airflow.v1.Dependencies
	(*NetworkConfig)(nil),         // 10: yandex.cloud.airflow.v1.NetworkConfig
	(*S3Config)(nil),              // 11: yandex.cloud.airflow.v1.S3Config
	(*CodeSyncConfig)(nil),        // 12: yandex.cloud.airflow.v1.CodeSyncConfig
	(*LoggingConfig)(nil),         // 13: yandex.cloud.airflow.v1.LoggingConfig
	(*LockboxConfig)(nil),         // 14: yandex.cloud.airflow.v1.LockboxConfig
	nil,                           // 15: yandex.cloud.airflow.v1.Cluster.LabelsEntry
	nil,                           // 16: yandex.cloud.airflow.v1.AirflowConfig.ConfigEntry
	(*timestamppb.Timestamp)(nil), // 17: google.protobuf.Timestamp
	(Health)(0),                   // 18: yandex.cloud.airflow.v1.Health
	(*MaintenanceWindow)(nil),     // 19: yandex.cloud.airflow.v1.MaintenanceWindow
	(*MaintenanceOperation)(nil),  // 20: yandex.cloud.airflow.v1.MaintenanceOperation
	(*Resources)(nil),             // 21: yandex.cloud.airflow.v1.Resources
	(v1.LogLevel_Level)(0),        // 22: yandex.cloud.logging.v1.LogLevel.Level
}
var file_yandex_cloud_airflow_v1_cluster_proto_depIdxs = []int32{
	17, // 0: yandex.cloud.airflow.v1.Cluster.created_at:type_name -> google.protobuf.Timestamp
	15, // 1: yandex.cloud.airflow.v1.Cluster.labels:type_name -> yandex.cloud.airflow.v1.Cluster.LabelsEntry
	2,  // 2: yandex.cloud.airflow.v1.Cluster.monitoring:type_name -> yandex.cloud.airflow.v1.Monitoring
	3,  // 3: yandex.cloud.airflow.v1.Cluster.config:type_name -> yandex.cloud.airflow.v1.ClusterConfig
	18, // 4: yandex.cloud.airflow.v1.Cluster.health:type_name -> yandex.cloud.airflow.v1.Health
	0,  // 5: yandex.cloud.airflow.v1.Cluster.status:type_name -> yandex.cloud.airflow.v1.Cluster.Status
	10, // 6: yandex.cloud.airflow.v1.Cluster.network:type_name -> yandex.cloud.airflow.v1.NetworkConfig
	12, // 7: yandex.cloud.airflow.v1.Cluster.code_sync:type_name -> yandex.cloud.airflow.v1.CodeSyncConfig
	13, // 8: yandex.cloud.airflow.v1.Cluster.logging:type_name -> yandex.cloud.airflow.v1.LoggingConfig
	19, // 9: yandex.cloud.airflow.v1.Cluster.maintenance_window:type_name -> yandex.cloud.airflow.v1.MaintenanceWindow
	20, // 10: yandex.cloud.airflow.v1.Cluster.planned_operation:type_name -> yandex.cloud.airflow.v1.MaintenanceOperation
	4,  // 11: yandex.cloud.airflow.v1.ClusterConfig.airflow:type_name -> yandex.cloud.airflow.v1.AirflowConfig
	5,  // 12: yandex.cloud.airflow.v1.ClusterConfig.webserver:type_name -> yandex.cloud.airflow.v1.WebserverConfig
	6,  // 13: yandex.cloud.airflow.v1.ClusterConfig.scheduler:type_name -> yandex.cloud.airflow.v1.SchedulerConfig
	7,  // 14: yandex.cloud.airflow.v1.ClusterConfig.triggerer:type_name -> yandex.cloud.airflow.v1.TriggererConfig
	8,  // 15: yandex.cloud.airflow.v1.ClusterConfig.worker:type_name -> yandex.cloud.airflow.v1.WorkerConfig
	9,  // 16: yandex.cloud.airflow.v1.ClusterConfig.dependencies:type_name -> yandex.cloud.airflow.v1.Dependencies
	14, // 17: yandex.cloud.airflow.v1.ClusterConfig.lockbox:type_name -> yandex.cloud.airflow.v1.LockboxConfig
	16, // 18: yandex.cloud.airflow.v1.AirflowConfig.config:type_name -> yandex.cloud.airflow.v1.AirflowConfig.ConfigEntry
	21, // 19: yandex.cloud.airflow.v1.WebserverConfig.resources:type_name -> yandex.cloud.airflow.v1.Resources
	21, // 20: yandex.cloud.airflow.v1.SchedulerConfig.resources:type_name -> yandex.cloud.airflow.v1.Resources
	21, // 21: yandex.cloud.airflow.v1.TriggererConfig.resources:type_name -> yandex.cloud.airflow.v1.Resources
	21, // 22: yandex.cloud.airflow.v1.WorkerConfig.resources:type_name -> yandex.cloud.airflow.v1.Resources
	11, // 23: yandex.cloud.airflow.v1.CodeSyncConfig.s3:type_name -> yandex.cloud.airflow.v1.S3Config
	22, // 24: yandex.cloud.airflow.v1.LoggingConfig.min_level:type_name -> yandex.cloud.logging.v1.LogLevel.Level
	25, // [25:25] is the sub-list for method output_type
	25, // [25:25] is the sub-list for method input_type
	25, // [25:25] is the sub-list for extension type_name
	25, // [25:25] is the sub-list for extension extendee
	0,  // [0:25] is the sub-list for field type_name
}

func init() { file_yandex_cloud_airflow_v1_cluster_proto_init() }
func file_yandex_cloud_airflow_v1_cluster_proto_init() {
	if File_yandex_cloud_airflow_v1_cluster_proto != nil {
		return
	}
	file_yandex_cloud_airflow_v1_common_proto_init()
	file_yandex_cloud_airflow_v1_maintenance_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*Cluster); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*Monitoring); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*ClusterConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*AirflowConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*WebserverConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*SchedulerConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*TriggererConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*WorkerConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*Dependencies); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*NetworkConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*S3Config); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*CodeSyncConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[12].Exporter = func(v any, i int) any {
			switch v := v.(*LoggingConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[13].Exporter = func(v any, i int) any {
			switch v := v.(*LockboxConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[11].OneofWrappers = []any{
		(*CodeSyncConfig_S3)(nil),
	}
	file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[12].OneofWrappers = []any{
		(*LoggingConfig_FolderId)(nil),
		(*LoggingConfig_LogGroupId)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_yandex_cloud_airflow_v1_cluster_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   16,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_yandex_cloud_airflow_v1_cluster_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_airflow_v1_cluster_proto_depIdxs,
		EnumInfos:         file_yandex_cloud_airflow_v1_cluster_proto_enumTypes,
		MessageInfos:      file_yandex_cloud_airflow_v1_cluster_proto_msgTypes,
	}.Build()
	File_yandex_cloud_airflow_v1_cluster_proto = out.File
	file_yandex_cloud_airflow_v1_cluster_proto_rawDesc = nil
	file_yandex_cloud_airflow_v1_cluster_proto_goTypes = nil
	file_yandex_cloud_airflow_v1_cluster_proto_depIdxs = nil
}
