/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.MisConfiguredException;
import com.intellij.profiler.MisConfiguredSettingsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u001aH\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b2\u0016\b\u0002\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u001aP\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b2\u0016\b\u0002\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u001a(\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u001a0\u0010\u0014\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u00a8\u0006\u0016"}, d2={"validateLocalPath", "Lcom/intellij/profiler/MisConfiguredException;", "path", "", "name", "project", "Lcom/intellij/openapi/project/Project;", "settingsCls", "Ljava/lang/Class;", "Lcom/intellij/openapi/options/Configurable;", "additionalConfiguration", "Lkotlin/Function1;", "", "Ljava/nio/file/Path;", "checkFilePathExist", "", "validateFrequency", "Lcom/intellij/profiler/MisConfiguredSettingsException;", "freq", "", "validateOutputDirectory", "directory", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nMisConfiguredException.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MisConfiguredException.kt\ncom/intellij/profiler/MisConfiguredExceptionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n1#2:96\n*E\n"})
public final class MisConfiguredExceptionKt {
    @Nullable
    public static final MisConfiguredException validateLocalPath(@NotNull String path, @NotNull String name, @NotNull Project project, @NotNull Class<? extends Configurable> settingsCls, @Nullable Function1<? super Configurable, Unit> additionalConfiguration) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(settingsCls, (String)"settingsCls");
        Path path2 = Path.of(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
        return MisConfiguredExceptionKt.validateLocalPath(path2, name, true, project, settingsCls, additionalConfiguration);
    }

    public static /* synthetic */ MisConfiguredException validateLocalPath$default(String string, String string2, Project project, Class clazz, Function1 function1, int n, Object object) {
        if ((n & 0x10) != 0) {
            function1 = null;
        }
        return MisConfiguredExceptionKt.validateLocalPath(string, string2, project, clazz, (Function1<? super Configurable, Unit>)function1);
    }

    @Nullable
    public static final MisConfiguredException validateLocalPath(@NotNull Path path, @NotNull String name, boolean checkFilePathExist, @NotNull Project project, @NotNull Class<? extends Configurable> settingsCls, @Nullable Function1<? super Configurable, Unit> additionalConfiguration) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(settingsCls, (String)"settingsCls");
        if (((CharSequence)((Object)path).toString()).length() == 0) {
            Object[] objectArray = new Object[]{name};
            return new MisConfiguredSettingsException(project, CommonProfilerBundleKt.profilerMessage("path.is.not.set", objectArray), settingsCls, additionalConfiguration);
        }
        if (checkFilePathExist && !Files.exists(path, new LinkOption[0])) {
            Object[] objectArray = new Object[]{name, path};
            return new MisConfiguredSettingsException(project, CommonProfilerBundleKt.profilerMessage("cant.find.file.at.path", objectArray), settingsCls, additionalConfiguration);
        }
        return null;
    }

    public static /* synthetic */ MisConfiguredException validateLocalPath$default(Path path, String string, boolean bl, Project project, Class clazz, Function1 function1, int n, Object object) {
        if ((n & 0x20) != 0) {
            function1 = null;
        }
        return MisConfiguredExceptionKt.validateLocalPath(path, string, bl, project, clazz, (Function1<? super Configurable, Unit>)function1);
    }

    @Nullable
    public static final MisConfiguredSettingsException validateFrequency(int freq, @NotNull Project project, @NotNull Class<? extends Configurable> settingsCls) {
        MisConfiguredSettingsException misConfiguredSettingsException;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(settingsCls, (String)"settingsCls");
        if (freq <= 0) {
            Object[] objectArray = new Object[]{freq};
            MisConfiguredSettingsException misConfiguredSettingsException2 = new MisConfiguredSettingsException(project, CommonProfilerBundleKt.profilerMessage("profiler.exceptions.invalid.frequency", objectArray), settingsCls, null, 8, null);
            misConfiguredSettingsException = misConfiguredSettingsException2;
        } else {
            misConfiguredSettingsException = null;
        }
        return misConfiguredSettingsException;
    }

    @Nullable
    public static final MisConfiguredException validateOutputDirectory(@NotNull Path directory, boolean checkFilePathExist, @NotNull Project project, @NotNull Class<? extends Configurable> settingsCls) {
        MisConfiguredSettingsException misConfiguredSettingsException;
        String message;
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(settingsCls, (String)"settingsCls");
        if (((CharSequence)((Object)directory).toString()).length() == 0) {
            return null;
        }
        if (!checkFilePathExist) {
            return null;
        }
        String string = message = !Files.exists(directory, new LinkOption[0]) ? CommonProfilerBundleKt.profilerMessage("profiler.exception.misconfig.dir.not.exist", new Object[0]) : (!Files.isWritable(directory) ? CommonProfilerBundleKt.profilerMessage("profiler.exception.misconfig.dir.cannotWrite", new Object[0]) : null);
        if (string != null) {
            String it = string;
            boolean bl = false;
            misConfiguredSettingsException = new MisConfiguredSettingsException(project, message, settingsCls, null, 8, null);
        } else {
            misConfiguredSettingsException = null;
        }
        return misConfiguredSettingsException;
    }
}

