/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.timeline;

import com.intellij.profiler.ui.timeline.TimelineComponent;
import com.intellij.ui.hover.HoverListener;
import com.intellij.ui.hover.TreeHoverListener;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\rJ\u001d\u0010\u000e\u001a\u00020\u000b2\u000e\u0010\u000f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007H\u0000\u00a2\u0006\u0002\b\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/profiler/ui/timeline/HoverHighlighter;", "", "<init>", "()V", "myTree", "Ljavax/swing/JTree;", "myChart", "Lcom/intellij/profiler/ui/timeline/TimelineComponent;", "myDefaultHoverListener", "Lcom/intellij/ui/hover/TreeHoverListener;", "addTree", "", "tree", "addTree$intellij_profiler_common", "addChart", "chart", "addChart$intellij_profiler_common", "Chart2TreeUpdateRowHoverListener", "RepaintChartTreeHoverListener", "intellij.profiler.common"})
public final class HoverHighlighter {
    private JTree myTree;
    private TimelineComponent<?, ?> myChart;
    @NotNull
    private final TreeHoverListener myDefaultHoverListener;

    public HoverHighlighter() {
        HoverListener hoverListener = TreeHoverListener.DEFAULT;
        Intrinsics.checkNotNull((Object)hoverListener, (String)"null cannot be cast to non-null type com.intellij.ui.hover.TreeHoverListener");
        this.myDefaultHoverListener = (TreeHoverListener)hoverListener;
    }

    public final void addTree$intellij_profiler_common(@NotNull JTree tree) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        this.myTree = tree;
        JTree jTree = this.myTree;
        if (jTree == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myTree");
            jTree = null;
        }
        this.myDefaultHoverListener.addTo((JComponent)jTree);
        RepaintChartTreeHoverListener repaintChartTreeHoverListener = new RepaintChartTreeHoverListener();
        JTree jTree2 = this.myTree;
        if (jTree2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myTree");
            jTree2 = null;
        }
        repaintChartTreeHoverListener.addTo(jTree2);
    }

    public final void addChart$intellij_profiler_common(@NotNull TimelineComponent<?, ?> chart2) {
        Intrinsics.checkNotNullParameter(chart2, (String)"chart");
        this.myChart = chart2;
        Chart2TreeUpdateRowHoverListener chart2TreeUpdateRowHoverListener = new Chart2TreeUpdateRowHoverListener();
        TimelineComponent<?, ?> timelineComponent = this.myChart;
        if (timelineComponent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myChart");
            timelineComponent = null;
        }
        chart2TreeUpdateRowHoverListener.addTo(timelineComponent);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J \u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001c\u0010\r\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/profiler/ui/timeline/HoverHighlighter$Chart2TreeUpdateRowHoverListener;", "Lcom/intellij/ui/hover/HoverListener;", "<init>", "(Lcom/intellij/profiler/ui/timeline/HoverHighlighter;)V", "mouseEntered", "", "component", "Ljava/awt/Component;", "x", "", "y", "mouseMoved", "mouseExited", "handleMovement", "intellij.profiler.common"})
    private final class Chart2TreeUpdateRowHoverListener
    extends HoverListener {
        public void mouseEntered(@NotNull Component component, int x, int y) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            this.handleMovement(x, y);
        }

        public void mouseMoved(@NotNull Component component, int x, int y) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            this.handleMovement(x, y);
        }

        public void mouseExited(@NotNull Component component) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            Chart2TreeUpdateRowHoverListener.handleMovement$default(this, 0, 0, 3, null);
        }

        private final void handleMovement(int x, int y) {
            JTree jTree = HoverHighlighter.this.myTree;
            if (jTree == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myTree");
                jTree = null;
            }
            int row = TreeUtil.getRowForLocation((JTree)jTree, (int)x, (int)y);
            TreeHoverListener treeHoverListener = HoverHighlighter.this.myDefaultHoverListener;
            JTree jTree2 = HoverHighlighter.this.myTree;
            if (jTree2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myTree");
                jTree2 = null;
            }
            treeHoverListener.onHover(jTree2, row);
        }

        static /* synthetic */ void handleMovement$default(Chart2TreeUpdateRowHoverListener chart2TreeUpdateRowHoverListener, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = -1;
            }
            if ((n3 & 2) != 0) {
                n2 = -1;
            }
            chart2TreeUpdateRowHoverListener.handleMovement(n, n2);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J \u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\r\u001a\u00020\u0005H\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/profiler/ui/timeline/HoverHighlighter$RepaintChartTreeHoverListener;", "Lcom/intellij/ui/hover/HoverListener;", "<init>", "(Lcom/intellij/profiler/ui/timeline/HoverHighlighter;)V", "mouseEntered", "", "component", "Ljava/awt/Component;", "x", "", "y", "mouseMoved", "mouseExited", "handleMovement", "intellij.profiler.common"})
    private final class RepaintChartTreeHoverListener
    extends HoverListener {
        public void mouseEntered(@NotNull Component component, int x, int y) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            this.handleMovement();
        }

        public void mouseMoved(@NotNull Component component, int x, int y) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            this.handleMovement();
        }

        public void mouseExited(@NotNull Component component) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            this.handleMovement();
        }

        private final void handleMovement() {
            TimelineComponent timelineComponent = HoverHighlighter.this.myChart;
            if (timelineComponent == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myChart");
                timelineComponent = null;
            }
            timelineComponent.repaint();
        }
    }
}

