/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.treetable;

import com.intellij.ui.components.JBTreeTable;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.HashSet;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public final class DefaultTreeTableCellRenderer
implements TableCellRenderer {
    private Border myBorder;
    @NotNull
    private final TableCellRenderer myDelegate;

    public DefaultTreeTableCellRenderer(@NotNull TableCellRenderer delegate) {
        if (delegate == null) {
            DefaultTreeTableCellRenderer.$$$reportNull$$$0(0);
        }
        this.myBorder = JBUI.Borders.empty((int)1);
        this.myDelegate = delegate;
    }

    public void setBorder(Border border) {
        this.myBorder = border;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component component = this.myDelegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        component.setBackground(UIUtil.getTableBackground((boolean)isSelected, (boolean)RenderingUtil.isFocused((JComponent)table)));
        component.setForeground(UIUtil.getTableForeground((boolean)isSelected, (boolean)RenderingUtil.isFocused((JComponent)table)));
        ((JComponent)component).setBorder(this.myBorder);
        return component;
    }

    public static void install(JBTreeTable table) {
        DefaultTreeTableCellRenderer.install(table, DefaultTreeTableCellRenderer::new);
    }

    public static void install(JBTreeTable table, Function<? super TableCellRenderer, ? extends TableCellRenderer> delegate) {
        TableModel model2 = table.getTable().getModel();
        HashSet installed = new HashSet();
        for (int i = 0; i < model2.getColumnCount(); ++i) {
            Class<?> columnClass = model2.getColumnClass(i);
            if (!installed.add(columnClass)) continue;
            TableCellRenderer renderer2 = table.getDefaultRenderer(columnClass);
            table.setDefaultRenderer(columnClass, delegate.apply(renderer2));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/profiler/ui/treetable/DefaultTreeTableCellRenderer", "<init>"));
    }
}

