/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.core;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.configurationStore.ComponentReloadingKt;
import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.ExportSettingsActionKt;
import com.intellij.configurationStore.FileSpec;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.settingsSync.core.FileState;
import com.intellij.settingsSync.core.FileStateKt;
import com.intellij.settingsSync.core.RestartForPluginDisable;
import com.intellij.settingsSync.core.RestartForPluginEnable;
import com.intellij.settingsSync.core.RestartForPluginInstall;
import com.intellij.settingsSync.core.RestartReason;
import com.intellij.settingsSync.core.SettingsProvider;
import com.intellij.settingsSync.core.SettingsSnapshot;
import com.intellij.settingsSync.core.SettingsSnapshotKt;
import com.intellij.settingsSync.core.SettingsSyncEventListener;
import com.intellij.settingsSync.core.SettingsSyncEvents;
import com.intellij.settingsSync.core.SettingsSyncFilteringKt;
import com.intellij.settingsSync.core.SettingsSyncIdeMediator;
import com.intellij.settingsSync.core.SettingsSyncIdeMediatorImpl;
import com.intellij.settingsSync.core.SettingsSyncSettings;
import com.intellij.settingsSync.core.SettingsSyncState;
import com.intellij.settingsSync.core.SyncSettingsEvent;
import com.intellij.settingsSync.core.notification.NotificationService;
import com.intellij.settingsSync.core.plugins.SettingsSyncPluginManager;
import com.intellij.settingsSync.core.plugins.SettingsSyncPluginsState;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 T2\u00020\u00012\u00020\u0002:\u0001TB%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"H\u0016J \u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(H\u0096@\u00a2\u0006\u0002\u0010)J\b\u0010*\u001a\u00020$H\u0002J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001e0,H\u0002J\b\u0010-\u001a\u00020$H\u0016J\b\u0010.\u001a\u00020$H\u0016J\u0018\u0010/\u001a\u00020&2\u0006\u00100\u001a\u00020\u00062\u0006\u00101\u001a\u00020&H\u0016J \u00102\u001a\u00020$2\u0006\u0010 \u001a\u00020\u00112\u0006\u00103\u001a\u0002042\u0006\u0010!\u001a\u00020\"H\u0016J.\u00105\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"2\u0014\u00106\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u000108\u0012\u0004\u0012\u00020$07H\u0016J\u0088\u0001\u00109\u001a\u00020\t2\u0006\u0010:\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"2!\u0010;\u001a\u001d\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b<\u0012\b\b=\u0012\u0004\b\b(=\u0012\u0004\u0012\u00020\t072K\u0010>\u001aG\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b<\u0012\b\b=\u0012\u0004\b\b(=\u0012\u0013\u0012\u001108\u00a2\u0006\f\b<\u0012\b\b=\u0012\u0004\b\b(@\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b<\u0012\b\b=\u0012\u0004\b\b(A\u0012\u0004\u0012\u00020\t0?H\u0016J\u0018\u0010B\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010C\u001a\u00020\t2\u0006\u0010D\u001a\u00020\u0006H\u0002J\u0010\u0010E\u001a\u00020\u00112\u0006\u0010F\u001a\u00020\u0011H\u0002J\u0016\u0010G\u001a\u00020$2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020J0IH\u0002J)\u0010K\u001a\u0002HL\"\u0004\b\u0000\u0010L2\u0006\u0010 \u001a\u00020\u00112\f\u0010M\u001a\b\u0012\u0004\u0012\u0002HL0\bH\u0002\u00a2\u0006\u0002\u0010NJ)\u0010O\u001a\u0002HL\"\u0004\b\u0000\u0010L2\u0006\u0010 \u001a\u00020\u00112\f\u0010P\u001a\b\u0012\u0004\u0012\u0002HL0\bH\u0002\u00a2\u0006\u0002\u0010NJ'\u0010Q\u001a\u0014 R*\t\u0018\u00010\u0014\u00a2\u0006\u0002\b\u00120\u0014\u00a2\u0006\u0002\b\u00122\u0006\u0010 \u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010SR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR3\u0010\u000f\u001a'\u0012\u000e\u0012\f0\u0011\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0002\b\u0013\u0012\u000e\u0012\f0\u0014\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0002\b\u00130\u0010\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u00168\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001aR\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"Lcom/intellij/settingsSync/core/SettingsSyncIdeMediatorImpl;", "Lcom/intellij/configurationStore/StreamProvider;", "Lcom/intellij/settingsSync/core/SettingsSyncIdeMediator;", "componentStore", "Lcom/intellij/configurationStore/ComponentStoreImpl;", "rootConfig", "Ljava/nio/file/Path;", "enabledCondition", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/configurationStore/ComponentStoreImpl;Ljava/nio/file/Path;Lkotlin/jvm/functions/Function0;)V", "appConfig", "getAppConfig", "()Ljava/nio/file/Path;", "fileSpecsToLocks", "Ljava/util/concurrent/ConcurrentMap;", "", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "Ljava/util/concurrent/locks/ReadWriteLock;", "files2applyLast", "", "getFiles2applyLast$intellij_settingsSync_core", "()Ljava/util/List;", "isExclusive", "()Z", "enabled", "getEnabled", "restartRequiredReasons", "Lcom/intellij/settingsSync/core/RestartReason;", "isApplicable", "fileSpec", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "applyToIde", "", "snapshot", "Lcom/intellij/settingsSync/core/SettingsSnapshot;", "settings", "Lcom/intellij/settingsSync/core/SettingsSyncState;", "(Lcom/intellij/settingsSync/core/SettingsSnapshot;Lcom/intellij/settingsSync/core/SettingsSyncState;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "notifyRestartNeeded", "mergeRestartReasons", "", "activateStreamProvider", "removeStreamProvider", "getInitialSnapshot", "appConfigPath", "lastSavedSnapshot", "write", "content", "", "read", "consumer", "Lkotlin/Function1;", "Ljava/io/InputStream;", "processChildren", "path", "filter", "Lkotlin/ParameterName;", "name", "processor", "Lkotlin/Function3;", "input", "readOnly", "delete", "deleteOrLogError", "file", "getFileRelativeToRootConfig", "fileSpecPassedToProvider", "writeStatesToAppConfig", "fileStates", "", "Lcom/intellij/settingsSync/core/FileState;", "writeUnderLock", "R", "writingProcedure", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "readUnderLock", "readingProcedure", "getOrCreateLock", "kotlin.jvm.PlatformType", "(Ljava/lang/String;)Ljava/util/concurrent/locks/ReadWriteLock;", "Companion", "intellij.settingsSync.core"})
@SourceDebugExtension(value={"SMAP\nSettingsSyncIdeMediatorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsSyncIdeMediatorImpl.kt\ncom/intellij/settingsSync/core/SettingsSyncIdeMediatorImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,328:1\n1#2:329\n1#2:375\n774#3:330\n865#3,2:331\n1485#3:333\n1510#3,3:334\n1513#3,3:344\n1368#3:357\n1454#3,5:358\n1368#3:363\n1454#3,5:364\n1368#3:369\n1454#3,5:370\n1557#3:385\n1628#3,3:386\n3193#3,10:389\n381#4,7:337\n487#4,7:378\n136#5,9:347\n216#5:356\n217#5:376\n145#5:377\n15#6:399\n*S KotlinDebug\n*F\n+ 1 SettingsSyncIdeMediatorImpl.kt\ncom/intellij/settingsSync/core/SettingsSyncIdeMediatorImpl\n*L\n106#1:375\n81#1:330\n81#1:331,2\n106#1:333\n106#1:334,3\n106#1:344,3\n108#1:357\n108#1:358,5\n109#1:363\n109#1:364,5\n110#1:369\n110#1:370,5\n131#1:385\n131#1:386,3\n286#1:389,10\n106#1:337,7\n127#1:378,7\n106#1:347,9\n106#1:356\n106#1:376\n106#1:377\n309#1:399\n*E\n"})
public final class SettingsSyncIdeMediatorImpl
implements StreamProvider,
SettingsSyncIdeMediator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ComponentStoreImpl componentStore;
    @NotNull
    private final Path rootConfig;
    @NotNull
    private final Function0<Boolean> enabledCondition;
    @NotNull
    private final ConcurrentMap<String, ReadWriteLock> fileSpecsToLocks;
    @VisibleForTesting
    @NotNull
    private final List<String> files2applyLast;
    @NotNull
    private final List<RestartReason> restartRequiredReasons;
    @NotNull
    private static final Logger LOG;

    public SettingsSyncIdeMediatorImpl(@NotNull ComponentStoreImpl componentStore, @NotNull Path rootConfig, @NotNull Function0<Boolean> enabledCondition) {
        Intrinsics.checkNotNullParameter((Object)componentStore, (String)"componentStore");
        Intrinsics.checkNotNullParameter((Object)rootConfig, (String)"rootConfig");
        Intrinsics.checkNotNullParameter(enabledCondition, (String)"enabledCondition");
        this.componentStore = componentStore;
        this.rootConfig = rootConfig;
        this.enabledCondition = enabledCondition;
        ConcurrentMap concurrentMap = ConcurrentCollectionFactory.createConcurrentMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentMap(...)");
        this.fileSpecsToLocks = concurrentMap;
        Object[] objectArray = new String[]{"colors.scheme.xml"};
        this.files2applyLast = CollectionsKt.mutableListOf((Object[])objectArray);
        this.restartRequiredReasons = new ArrayList();
        SettingsSyncEvents.Companion.getInstance().addListener(new SettingsSyncEventListener(){

            @Override
            public void restartRequired(RestartReason reason) {
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                restartRequiredReasons.add(reason);
            }
        });
    }

    private final Path getAppConfig() {
        Path path = this.rootConfig.resolve("options");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public final List<String> getFiles2applyLast$intellij_settingsSync_core() {
        return this.files2applyLast;
    }

    public boolean isExclusive() {
        return true;
    }

    public boolean getEnabled() {
        return (Boolean)this.enabledCondition.invoke();
    }

    public boolean isApplicable(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
        return roamingType.isRoamable();
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object applyToIde(@NotNull SettingsSnapshot var1_1, @Nullable SettingsSyncState var2_2, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof applyToIde.1)) ** GOTO lbl-1000
        var16_4 = $completion;
        if ((var16_4.label & -2147483648) != 0) {
            var16_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ SettingsSyncIdeMediatorImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.applyToIde(null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var17_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var6_7 = snapshot.getFileStates();
                var7_8 = var6_7.iterator();
                while (var7_8.hasNext()) {
                    var8_11 /* !! */  = var7_8.next();
                    it = (FileState)var8_11 /* !! */ ;
                    $i$a$-find-SettingsSyncIdeMediatorImpl$applyToIde$settingsSyncFileState$1 = false;
                    if (!Intrinsics.areEqual((Object)it.getFile(), (Object)"options/settingsSync.xml")) continue;
                    v0 = var8_11 /* !! */ ;
                    ** GOTO lbl22
                }
                v0 = null;
lbl22:
                // 2 sources

                settingsSyncFileState = v0;
                if (settings != null) {
                    SettingsSyncIdeMediatorImpl.LOG.info("applying sync settings from SettingsSyncState");
                    SettingsSyncSettings.Companion.getInstance().applyFromState((SettingsSyncState)settings);
                } else if (settingsSyncFileState != null) {
                    this.writeStatesToAppConfig(CollectionsKt.listOf((Object)settingsSyncFileState));
                }
                if (snapshot.getPlugins() != null) {
                    $continuation.L$0 = this;
                    $continuation.L$1 = snapshot;
                    $continuation.L$2 = settingsSyncFileState;
                    $continuation.label = 1;
                    v1 = SettingsSyncPluginManager.Companion.getInstance().pushChangesToIde(snapshot.getPlugins(), (Continuation<? super Unit>)$continuation);
                    if (v1 == var17_6) {
                        return var17_6;
                    }
                }
                ** GOTO lbl44
            }
            case 1: {
                settingsSyncFileState = (FileState)$continuation.L$2;
                snapshot = (SettingsSnapshot)$continuation.L$1;
                this = (SettingsSyncIdeMediatorImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl44:
                // 2 sources

                if (!AppMode.isRemoteDevHost()) {
                    $this$filter$iv = snapshot.getFileStates();
                    $i$f$filter = false;
                    var8_11 /* !! */  = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (FileState)element$iv$iv;
                        $i$a$-filter-SettingsSyncIdeMediatorImpl$applyToIde$regularFileStates$1 = false;
                        if (!(Intrinsics.areEqual((Object)it, (Object)settingsSyncFileState) == false)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    regularFileStates = (List)destination$iv$iv;
                    this.writeStatesToAppConfig(regularFileStates);
                    for (Map.Entry var7_10 : snapshot.getSettingsFromProviders().entrySet()) {
                        id = (String)var7_10.getKey();
                        provider = SettingsSyncIdeMediatorImpl.Companion.findProviderById$intellij_settingsSync_core(id, state = var7_10.getValue());
                        if (provider != null) {
                            SettingsSyncIdeMediatorImpl.LOG.debug("Applying settings for provider '" + id + "'");
                            provider.applyNewSettings(state);
                            continue;
                        }
                        SettingsSyncIdeMediatorImpl.LOG.warn("Couldn't find provider for id '" + id + "' and state '" + state.getClass() + "'");
                    }
                }
                this.notifyRestartNeeded();
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void notifyRestartNeeded() {
        List<RestartReason> mergedReasons = this.mergeRestartReasons();
        if (mergedReasons.isEmpty()) {
            return;
        }
        NotificationService.Companion.getInstance().notifyRestartNeeded((Collection<? extends RestartReason>)mergedReasons);
    }

    /*
     * WARNING - void declaration
     */
    private final List<RestartReason> mergeRestartReasons() {
        void $this$mapNotNullTo$iv$iv;
        Map $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = this.restartRequiredReasons;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object element$iv$iv = iterator.next();
            RestartReason it = (RestartReason)element$iv$iv;
            boolean bl = false;
            Class<?> key$iv$iv = it.getClass();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$mapNotNull$iv = destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$groupByTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            RestartReason restartReason;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl3 = false;
            Class clazz = (Class)entry.getKey();
            List reasons = (List)entry.getValue();
            Class clazz2 = clazz;
            if (Intrinsics.areEqual((Object)clazz2, RestartForPluginInstall.class)) {
                $this$flatMap$iv = reasons;
                $i$f$flatMap = false;
                Iterable iterable2 = $this$flatMap$iv;
                destination$iv$iv = new ArrayList();
                $i$f$flatMapTo = false;
                for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
                    it = (RestartReason)element$iv$iv2;
                    boolean bl4 = false;
                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.settingsSync.core.RestartForPluginInstall");
                    list$iv$iv = ((RestartForPluginInstall)it).getPlugins();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                Collection collection = (List)destination$iv$iv;
                restartReason = new RestartForPluginInstall(collection);
            } else if (Intrinsics.areEqual((Object)clazz2, RestartForPluginEnable.class)) {
                $this$flatMap$iv = reasons;
                $i$f$flatMap = false;
                $this$flatMapTo$iv$iv = $this$flatMap$iv;
                destination$iv$iv = new ArrayList();
                $i$f$flatMapTo = false;
                for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
                    it = (RestartReason)element$iv$iv2;
                    boolean bl5 = false;
                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.settingsSync.core.RestartForPluginEnable");
                    list$iv$iv = ((RestartForPluginEnable)it).getPlugins();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                Collection collection = (List)destination$iv$iv;
                restartReason = new RestartForPluginEnable(collection);
            } else if (Intrinsics.areEqual((Object)clazz2, RestartForPluginDisable.class)) {
                $this$flatMap$iv = reasons;
                $i$f$flatMap = false;
                $this$flatMapTo$iv$iv = $this$flatMap$iv;
                destination$iv$iv = new ArrayList();
                $i$f$flatMapTo = false;
                for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
                    it = (RestartReason)element$iv$iv2;
                    boolean bl6 = false;
                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.settingsSync.core.RestartForPluginDisable");
                    list$iv$iv = ((RestartForPluginDisable)it).getPlugins();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                Collection collection = (List)destination$iv$iv;
                restartReason = new RestartForPluginDisable(collection);
            } else {
                restartReason = null;
            }
            if (restartReason == null) continue;
            RestartReason it$iv$iv = restartReason;
            boolean bl7 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void activateStreamProvider() {
        this.componentStore.getStorageManager().addStreamProvider((StreamProvider)this, true);
    }

    @Override
    public void removeStreamProvider() {
        this.componentStore.getStorageManager().removeStreamProvider(this.getClass());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SettingsSnapshot getInitialSnapshot(@NotNull Path appConfigPath, @NotNull SettingsSnapshot lastSavedSnapshot) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map.Entry entry$iv2;
        void $this$filterKeys$iv;
        Intrinsics.checkNotNullParameter((Object)appConfigPath, (String)"appConfigPath");
        Intrinsics.checkNotNullParameter((Object)lastSavedSnapshot, (String)"lastSavedSnapshot");
        Map map = ExportSettingsActionKt.getExportableComponentsMap$default((boolean)false, (StateStorageManager)this.componentStore.getStorageManager(), (boolean)false, (boolean)false, (int)4, null);
        boolean $i$f$filterKeys = false;
        Object result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv2 : $this$filterKeys$iv.entrySet()) {
            FileSpec it = (FileSpec)entry$iv2.getKey();
            boolean bl = false;
            if (!SettingsSyncFilteringKt.isSyncCategoryEnabled(it.rawFileSpec)) continue;
            ((HashMap)result$iv).put(entry$iv2.getKey(), entry$iv2.getValue());
        }
        Map exportableItems = (Map)result$iv;
        Set filesToExport = ExportSettingsActionKt.getExportableItemsFromLocalStorage((Map)exportableItems, (StateStorageManager)this.componentStore.getStorageManager()).keySet();
        Set<FileState> fileStates = FileStateKt.collectFileStatesFromFiles(filesToExport, appConfigPath);
        result$iv = fileStates;
        Logger logger = LOG;
        boolean $i$f$map = false;
        entry$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FileState fileState = (FileState)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFile());
        }
        logger.debug("Collected files for the following fileSpecs: " + (List)destination$iv$iv);
        SettingsSyncPluginsState pluginsState = SettingsSyncPluginManager.Companion.getInstance().updateStateFromIdeOnStart$intellij_settingsSync_core(lastSavedSnapshot.getPlugins());
        LOG.debug("Collected following plugin state: " + pluginsState);
        Map settingsFromProviders = new LinkedHashMap();
        SettingsProvider.Companion.getSETTINGS_PROVIDER_EP().forEachExtensionSafe(arg_0 -> SettingsSyncIdeMediatorImpl.getInitialSnapshot$lambda$9(settingsFromProviders, arg_0));
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        return new SettingsSnapshot(new SettingsSnapshot.MetaInfo(instant, SettingsSnapshotKt.getLocalApplicationInfo(), false, 4, null), fileStates, pluginsState, settingsFromProviders, SetsKt.emptySet());
    }

    public void write(@NotNull String fileSpec, @NotNull byte[] content, @NotNull RoamingType roamingType) {
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
        String file = this.getFileRelativeToRootConfig(fileSpec);
        this.writeUnderLock(file, () -> SettingsSyncIdeMediatorImpl.write$lambda$10(this, file, content));
        boolean syncEnabled = SettingsSyncFilteringKt.isSyncCategoryEnabled(fileSpec);
        LOG.debug("Sync is " + (syncEnabled ? "enabled" : "disabled") + " for " + fileSpec + " (" + file + ")");
        if (!syncEnabled) {
            return;
        }
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        SettingsSnapshot snapshot = new SettingsSnapshot(new SettingsSnapshot.MetaInfo(instant, SettingsSnapshotKt.getLocalApplicationInfo(), false, 4, null), SetsKt.setOf((Object)new FileState.Modified(file, content)), null, MapsKt.emptyMap(), SetsKt.emptySet());
        SettingsSyncEvents.Companion.getInstance().fireSettingsChanged(new SyncSettingsEvent.IdeChange(snapshot));
    }

    public boolean read(@NotNull String fileSpec, @NotNull RoamingType roamingType, @NotNull Function1<? super InputStream, Unit> consumer) {
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        if (!this.isApplicable(fileSpec, roamingType)) {
            return false;
        }
        Path path = this.getAppConfig().resolve(fileSpec);
        String adjustedSpec = this.getFileRelativeToRootConfig(fileSpec);
        return (Boolean)this.readUnderLock(adjustedSpec, () -> SettingsSyncIdeMediatorImpl.read$lambda$11(consumer, path, fileSpec));
    }

    public boolean processChildren(@NotNull String path, @NotNull RoamingType roamingType, @NotNull Function1<? super String, Boolean> filter, @NotNull Function3<? super String, ? super InputStream, ? super Boolean, Boolean> processor) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        Path folder = this.rootConfig.resolve(path);
        Intrinsics.checkNotNull((Object)folder);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(folder, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return true;
        }
        Files.walkFileTree(folder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(filter, this, processor){
            final /* synthetic */ Function1<String, Boolean> $filter;
            final /* synthetic */ SettingsSyncIdeMediatorImpl this$0;
            final /* synthetic */ Function3<String, InputStream, Boolean, Boolean> $processor;
            {
                this.$filter = $filter;
                this.this$0 = $receiver;
                this.$processor = $processor;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                if (!((Boolean)this.$filter.invoke((Object)PathsKt.getName((Path)file))).booleanValue()) {
                    return FileVisitResult.CONTINUE;
                }
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.isRegularFile(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    return FileVisitResult.CONTINUE;
                }
                OpenOption[] openOptionArray = new OpenOption[]{};
                InputStream inputStream = Files.newInputStream(file, Arrays.copyOf(openOptionArray, openOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                Closeable closeable = inputStream;
                SettingsSyncIdeMediatorImpl settingsSyncIdeMediatorImpl = this.this$0;
                Function3<String, InputStream, Boolean, Boolean> function3 = this.$processor;
                Throwable throwable = null;
                try {
                    InputStream inputStream2 = (InputStream)closeable;
                    boolean bl2 = false;
                    Path path = SettingsSyncIdeMediatorImpl.access$getRootConfig$p(settingsSyncIdeMediatorImpl).relativize(file);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"relativize(...)");
                    String fileSpec = PathsKt.getInvariantSeparatorsPathString((Path)path);
                    bl = StreamProvider.read$default((StreamProvider)settingsSyncIdeMediatorImpl, (String)fileSpec, null, arg_0 -> processChildren.1.visitFile$lambda$1$lambda$0(function3, file, inputStream2, arg_0), (int)2, null);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                boolean shouldProceed = bl;
                return shouldProceed ? FileVisitResult.CONTINUE : FileVisitResult.TERMINATE;
            }

            private static final Unit visitFile$lambda$1$lambda$0(Function3 $processor, Path $file, InputStream $inputStream, InputStream it) {
                $processor.invoke((Object)((Object)$file.getFileName()).toString(), (Object)$inputStream, (Object)false);
                return Unit.INSTANCE;
            }
        });
        return true;
    }

    public boolean delete(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
        if (!this.isApplicable(fileSpec, roamingType)) {
            return false;
        }
        String adjustedSpec = this.getFileRelativeToRootConfig(fileSpec);
        Path file = this.rootConfig.resolve(adjustedSpec);
        Intrinsics.checkNotNull((Object)file);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            LOG.debug("File " + file + " doesn't exist, no need to delete");
            return true;
        }
        boolean deleted = (Boolean)this.writeUnderLock(adjustedSpec, () -> SettingsSyncIdeMediatorImpl.delete$lambda$12(this, file));
        if (deleted) {
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            SettingsSnapshot snapshot = new SettingsSnapshot(new SettingsSnapshot.MetaInfo(instant, SettingsSnapshotKt.getLocalApplicationInfo(), false, 4, null), SetsKt.setOf((Object)new FileState.Deleted(adjustedSpec)), null, MapsKt.emptyMap(), SetsKt.emptySet());
            SettingsSyncEvents.Companion.getInstance().fireSettingsChanged(new SyncSettingsEvent.IdeChange(snapshot));
        }
        return deleted;
    }

    private final boolean deleteOrLogError(Path file) {
        try {
            Files.delete(file);
            return true;
        }
        catch (Exception e) {
            LOG.error("Couldn't delete " + ((Object)file).toString(), (Throwable)e);
            return false;
        }
    }

    private final String getFileRelativeToRootConfig(String fileSpecPassedToProvider) {
        return !StringsKt.contains$default((CharSequence)fileSpecPassedToProvider, (CharSequence)"/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)fileSpecPassedToProvider, (String)(StoreUtilKt.getPerOsSettingsStorageFolderName() + "/"), (boolean)false, (int)2, null) ? "options/" + fileSpecPassedToProvider : fileSpecPassedToProvider;
    }

    private final void writeStatesToAppConfig(Collection<? extends FileState> fileStates) {
        ArrayList<String> changedFileSpecs = new ArrayList<String>();
        ArrayList<String> deletedFileSpecs = new ArrayList<String>();
        for (FileState fileState : fileStates) {
            boolean bl;
            String fileSpec = StringsKt.removePrefix((String)fileState.getFile(), (CharSequence)"options/");
            if (!SettingsSyncFilteringKt.isSyncCategoryEnabled(fileSpec)) continue;
            Path file = this.rootConfig.resolve(fileState.getFile());
            FileState fileState2 = fileState;
            if (fileState2 instanceof FileState.Modified) {
                this.writeUnderLock(fileSpec, () -> SettingsSyncIdeMediatorImpl.writeStatesToAppConfig$lambda$13(file, fileState));
                bl = changedFileSpecs.add(fileSpec);
                continue;
            }
            if (fileState2 instanceof FileState.Deleted) {
                this.writeUnderLock(fileSpec, () -> SettingsSyncIdeMediatorImpl.writeStatesToAppConfig$lambda$14(file));
                bl = deletedFileSpecs.add(fileSpec);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        ActionsKt.invokeAndWaitIfNeeded$default(null, () -> SettingsSyncIdeMediatorImpl.writeStatesToAppConfig$lambda$16(changedFileSpecs, this, deletedFileSpecs), (int)1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R> R writeUnderLock(String fileSpec, Function0<? extends R> writingProcedure) {
        Object object;
        Lock lock = this.getOrCreateLock(fileSpec).writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)lock, (String)"writeLock(...)");
        Lock lock2 = lock;
        lock2.lock();
        try {
            boolean bl = false;
            object = writingProcedure.invoke();
        }
        finally {
            lock2.unlock();
        }
        return (R)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R> R readUnderLock(String fileSpec, Function0<? extends R> readingProcedure) {
        Object object;
        Lock lock = this.getOrCreateLock(fileSpec).readLock();
        Intrinsics.checkNotNullExpressionValue((Object)lock, (String)"readLock(...)");
        Lock lock2 = lock;
        lock2.lock();
        try {
            boolean bl = false;
            object = readingProcedure.invoke();
        }
        finally {
            lock2.unlock();
        }
        return (R)object;
    }

    private final ReadWriteLock getOrCreateLock(String fileSpec) {
        return this.fileSpecsToLocks.computeIfAbsent(fileSpec, arg_0 -> SettingsSyncIdeMediatorImpl.getOrCreateLock$lambda$20(SettingsSyncIdeMediatorImpl::getOrCreateLock$lambda$19, arg_0));
    }

    private static final void getInitialSnapshot$lambda$9(Map $settingsFromProviders, SettingsProvider it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object currentSettings = it.collectCurrentSettings();
        if (currentSettings != null) {
            $settingsFromProviders.put(it.getId(), currentSettings);
        }
    }

    private static final Path write$lambda$10(SettingsSyncIdeMediatorImpl this$0, String $file, byte[] $content) {
        Path path = this$0.rootConfig.resolve($file);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return PathKt.write((Path)path, (byte[])$content);
    }

    private static final boolean read$lambda$11(Function1 $consumer, Path $path, String $fileSpec) {
        boolean bl;
        try {
            Intrinsics.checkNotNull((Object)$path);
            $consumer.invoke((Object)PathKt.inputStreamIfExists((Path)$path));
            bl = true;
        }
        catch (Throwable e) {
            Attachment[] attachmentArray;
            try {
                Intrinsics.checkNotNull((Object)$path);
                attachmentArray = new Attachment($fileSpec, PathsKt.readText$default((Path)$path, null, (int)1, null));
            }
            catch (Throwable errorReadingFile) {
                attachmentArray = new Attachment("file-read-error", errorReadingFile);
            }
            Attachment[] attachment = attachmentArray;
            attachmentArray = new Attachment[]{attachment};
            LOG.error("Couldn't read " + $fileSpec, e, attachmentArray);
            bl = false;
        }
        return bl;
    }

    private static final boolean delete$lambda$12(SettingsSyncIdeMediatorImpl this$0, Path $file) {
        Intrinsics.checkNotNull((Object)$file);
        return this$0.deleteOrLogError($file);
    }

    private static final Path writeStatesToAppConfig$lambda$13(Path $file, FileState $fileState) {
        Intrinsics.checkNotNull((Object)$file);
        return PathKt.write((Path)$file, (byte[])((FileState.Modified)$fileState).getContent());
    }

    private static final boolean writeStatesToAppConfig$lambda$14(Path $file) {
        Intrinsics.checkNotNull((Object)$file);
        return Files.deleteIfExists($file);
    }

    private static final Unit writeStatesToAppConfig$lambda$16(ArrayList $changedFileSpecs, SettingsSyncIdeMediatorImpl this$0, ArrayList $deletedFileSpecs) {
        Iterable $this$partition$iv = $changedFileSpecs;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            boolean bl2 = !this$0.files2applyLast.contains(it) ? first$iv.add(element$iv) : second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List normalChanged = (List)pair.component1();
        List lastChanged = (List)pair.component2();
        ComponentReloadingKt.reloadComponents$default((ComponentStoreImpl)this$0.componentStore, (Collection)normalChanged, (Collection)$deletedFileSpecs, null, (boolean)false, (int)12, null);
        if (!((Collection)lastChanged).isEmpty()) {
            ComponentReloadingKt.reloadComponents$default((ComponentStoreImpl)this$0.componentStore, (Collection)lastChanged, (Collection)CollectionsKt.emptyList(), null, (boolean)false, (int)12, null);
        }
        return Unit.INSTANCE;
    }

    private static final ReadWriteLock getOrCreateLock$lambda$19(String it) {
        return new ReentrantReadWriteLock();
    }

    private static final ReadWriteLock getOrCreateLock$lambda$20(Function1 $tmp0, Object p0) {
        return (ReadWriteLock)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Path access$getRootConfig$p(SettingsSyncIdeMediatorImpl $this) {
        return $this.rootConfig;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SettingsSyncIdeMediatorImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\b\u001a\n\u0012\u0004\u0012\u0002H\n\u0018\u00010\t\"\b\b\u0000\u0010\n*\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u0002H\nH\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/settingsSync/core/SettingsSyncIdeMediatorImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "findProviderById", "Lcom/intellij/settingsSync/core/SettingsProvider;", "T", "id", "", "state", "findProviderById$intellij_settingsSync_core", "(Ljava/lang/String;Ljava/lang/Object;)Lcom/intellij/settingsSync/core/SettingsProvider;", "intellij.settingsSync.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        @Nullable
        public final <T> SettingsProvider<T> findProviderById$intellij_settingsSync_core(@NotNull String id, @NotNull T state) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter(state, (String)"state");
            SettingsProvider provider = (SettingsProvider)SettingsProvider.Companion.getSETTINGS_PROVIDER_EP().findFirstSafe(arg_0 -> Companion.findProviderById$lambda$0(id, arg_0));
            if (provider != null) {
                try {
                    return provider;
                }
                catch (Exception e) {
                    this.getLOG().error("Could not cast the provider '" + provider.getId() + "' to expected class " + state.getClass(), (Throwable)e);
                }
            } else {
                this.getLOG().warn("Couldn't find provider for state class '" + state.getClass() + "'");
            }
            return null;
        }

        private static final boolean findProviderById$lambda$0(String $id, SettingsProvider it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.areEqual((Object)it.getId(), (Object)$id);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

