/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.npm.registry;

import com.google.gson.JsonObject;
import com.intellij.javascript.nodejs.npm.AvailablePackageVersions;
import com.intellij.javascript.nodejs.npm.registry.CustomNpmRegistryService;
import com.intellij.javascript.nodejs.npm.registry.NpmRegistryService;
import com.intellij.javascript.nodejs.npm.registry.NpmRegistryServiceImpl;
import com.intellij.javascript.nodejs.npm.registry.PublicNpmRegistryServiceImpl;
import com.intellij.javascript.nodejs.packageJson.NodePackageBasicInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 '2\u00020\u0001:\u0001'B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J>\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018H\u0016J6\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00160\u00192\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096@\u00a2\u0006\u0002\u0010\u001eJ \u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001b0 2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J*\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u001d2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096@\u00a2\u0006\u0002\u0010$J*\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\"0 2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u001d2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010&\u001a\u0004\u0018\u00010\u0013*\u0004\u0018\u00010\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/javascript/nodejs/npm/registry/NpmRegistryServiceImpl;", "Lcom/intellij/javascript/nodejs/npm/registry/NpmRegistryService;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "custom", "Lcom/intellij/javascript/nodejs/npm/registry/CustomNpmRegistryService;", "public", "Lcom/intellij/javascript/nodejs/npm/registry/PublicNpmRegistryServiceImpl;", "findPackages", "", "searchQuery", "Lcom/intellij/javascript/nodejs/npm/registry/NpmRegistryService$SearchQuery;", "limit", "", "contextFileOrDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "filter", "Lcom/intellij/openapi/util/Condition;", "Lcom/intellij/javascript/nodejs/packageJson/NodePackageBasicInfo;", "consumer", "Ljava/util/function/Consumer;", "Lkotlinx/coroutines/flow/Flow;", "getCachedOrFetchPackageVersions", "Lcom/intellij/javascript/nodejs/npm/AvailablePackageVersions;", "packageName", "", "(Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getCachedOrFetchPackageVersionsFuture", "Ljava/util/concurrent/CompletableFuture;", "fetchPackageJson", "Lcom/google/gson/JsonObject;", "versionOrRange", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fetchPackageJsonFuture", "orProjectRoot", "Companion", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nNpmRegistryServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NpmRegistryServiceImpl.kt\ncom/intellij/javascript/nodejs/npm/registry/NpmRegistryServiceImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n62#2,5:138\n62#2,5:145\n62#2,5:150\n62#2,5:157\n62#2,5:162\n62#2,5:167\n62#2,5:172\n62#2,5:177\n15#2:182\n1863#3,2:143\n1863#3,2:155\n*S KotlinDebug\n*F\n+ 1 NpmRegistryServiceImpl.kt\ncom/intellij/javascript/nodejs/npm/registry/NpmRegistryServiceImpl\n*L\n36#1:138,5\n41#1:145,5\n47#1:150,5\n52#1:157,5\n84#1:162,5\n88#1:167,5\n94#1:172,5\n98#1:177,5\n130#1:182\n38#1:143,2\n49#1:155,2\n*E\n"})
public final class NpmRegistryServiceImpl
extends NpmRegistryService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CustomNpmRegistryService custom;
    @NotNull
    private final PublicNpmRegistryServiceImpl public;
    @NotNull
    private static final Logger LOG;

    public NpmRegistryServiceImpl(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.custom = new CustomNpmRegistryService(this.project);
        this.public = new PublicNpmRegistryServiceImpl(coroutineScope);
    }

    @Override
    public void findPackages(@NotNull NpmRegistryService.SearchQuery searchQuery, int limit, @Nullable VirtualFile contextFileOrDir, @NotNull Condition<NodePackageBasicInfo> filter, @NotNull Consumer<NodePackageBasicInfo> consumer) {
        CustomNpmRegistryService.Registry registry;
        Intrinsics.checkNotNullParameter((Object)searchQuery, (String)"searchQuery");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        VirtualFile fileOrDir = this.orProjectRoot(contextFileOrDir);
        if (!NpmRegistryServiceImpl.Companion.isPublicNpmRegistryAllowed()) {
            if (fileOrDir != null) {
                Logger $this$debug_u24default$iv = LOG;
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug("Completing " + searchQuery.query + " from custom npm registry, public npm registry disabled", e$iv);
                }
                List<NodePackageBasicInfo> list = this.custom.findPackages(null, fileOrDir, searchQuery.query, limit, filter);
                Intrinsics.checkNotNullExpressionValue(list, (String)"findPackages(...)");
                List<NodePackageBasicInfo> packages = list;
                Iterable $this$forEach$iv = packages;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    NodePackageBasicInfo p0 = (NodePackageBasicInfo)element$iv;
                    boolean bl = false;
                    consumer.accept(p0);
                }
            } else {
                Logger $this$debug_u24default$iv = LOG;
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug("Completing " + searchQuery.query + " from custom npm registry, but no context file specified. Skipped.", e$iv);
                }
            }
            return;
        }
        CustomNpmRegistryService.Registry registry2 = registry = fileOrDir != null ? this.custom.findRegistry(fileOrDir, searchQuery.query) : null;
        if (registry != null && fileOrDir != null) {
            Logger $this$debug_u24default$iv = LOG;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Completing " + searchQuery.query + " from custom npm registry " + registry, e$iv);
            }
            List<NodePackageBasicInfo> list = this.custom.findPackages(registry, fileOrDir, searchQuery.query, limit, filter);
            Intrinsics.checkNotNullExpressionValue(list, (String)"findPackages(...)");
            List<NodePackageBasicInfo> packages = list;
            Iterable $this$forEach$iv = packages;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                NodePackageBasicInfo p0 = (NodePackageBasicInfo)element$iv;
                boolean bl = false;
                consumer.accept(p0);
            }
        } else {
            Logger $this$debug_u24default$iv = LOG;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Completing " + searchQuery.query + " from public npm registry", e$iv);
            }
            this.public.findPackages(searchQuery, limit, fileOrDir, filter, consumer);
        }
    }

    @Override
    @NotNull
    public Flow<NodePackageBasicInfo> findPackages(@NotNull NpmRegistryService.SearchQuery searchQuery, int limit, @Nullable VirtualFile contextFileOrDir, @NotNull Condition<NodePackageBasicInfo> filter) {
        Intrinsics.checkNotNullParameter((Object)searchQuery, (String)"searchQuery");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        ArrayList result2 = new ArrayList();
        this.findPackages(searchQuery, limit, contextFileOrDir, filter, arg_0 -> NpmRegistryServiceImpl.findPackages$lambda$5(result2, arg_0));
        return FlowKt.asFlow((Iterable)result2);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object getCachedOrFetchPackageVersions(@NotNull String var1_1, @Nullable VirtualFile var2_2, @NotNull Continuation<? super AvailablePackageVersions> $completion) {
        if (!($completion instanceof getCachedOrFetchPackageVersions.1)) ** GOTO lbl-1000
        var5_4 = $completion;
        if ((var5_4.label & -2147483648) != 0) {
            var5_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ NpmRegistryServiceImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getCachedOrFetchPackageVersions(null, null, (Continuation<? super AvailablePackageVersions>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = FutureKt.await((CompletionStage)this.getCachedOrFetchPackageVersionsFuture((String)packageName, (VirtualFile)contextFileOrDir), (Continuation)$continuation);
                if (v0 == var6_6) {
                    return var6_6;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"await(...)");
                return v0;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @NotNull
    public CompletableFuture<AvailablePackageVersions> getCachedOrFetchPackageVersionsFuture(@NotNull String packageName, @Nullable VirtualFile contextFileOrDir) {
        CustomNpmRegistryService.Registry registry;
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        VirtualFile fileOrDir = this.orProjectRoot(contextFileOrDir);
        if (!NpmRegistryServiceImpl.Companion.isPublicNpmRegistryAllowed()) {
            if (fileOrDir != null) {
                Logger $this$debug_u24default$iv = LOG;
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug("getCachedOrFetchPackageVersionsFuture(" + packageName + ") from custom npm registry, public npm registry disabled", e$iv);
                }
                CompletableFuture<AvailablePackageVersions> completableFuture = this.custom.getPackageVersions(fileOrDir, packageName);
                Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"getPackageVersions(...)");
                return completableFuture;
            }
            Logger $this$debug_u24default$iv = LOG;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("getCachedOrFetchPackageVersionsFuture(" + packageName + ") from custom npm registry, but no context file specified. Skipped.", e$iv);
            }
            CompletableFuture<AvailablePackageVersions> completableFuture = CompletableFuture.completedFuture(AvailablePackageVersions.createEmpty());
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        CustomNpmRegistryService.Registry registry2 = registry = fileOrDir != null ? this.custom.findRegistry(fileOrDir, packageName) : null;
        if (registry != null && fileOrDir != null) {
            Logger $this$debug_u24default$iv = LOG;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("getCachedOrFetchPackageVersionsFuture(" + packageName + ") from custom npm registry " + registry, e$iv);
            }
            CompletableFuture<AvailablePackageVersions> completableFuture = this.custom.getPackageVersions(fileOrDir, packageName);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"getPackageVersions(...)");
            return completableFuture;
        }
        Logger $this$debug_u24default$iv = LOG;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("getCachedOrFetchPackageVersionsFuture(" + packageName + ") from public npm registry", e$iv);
        }
        return this.public.getCachedOrFetchPackageVersionsFuture(packageName, fileOrDir);
    }

    @Override
    @Nullable
    public Object fetchPackageJson(@NotNull String packageName, @NotNull String versionOrRange, @Nullable VirtualFile contextFileOrDir, @NotNull Continuation<? super JsonObject> $completion) {
        if (NpmRegistryServiceImpl.Companion.isPublicNpmRegistryAllowed()) {
            return this.public.fetchPackageJson(packageName, versionOrRange, contextFileOrDir, $completion);
        }
        return null;
    }

    @Override
    @NotNull
    public CompletableFuture<JsonObject> fetchPackageJsonFuture(@NotNull String packageName, @NotNull String versionOrRange, @Nullable VirtualFile contextFileOrDir) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)versionOrRange, (String)"versionOrRange");
        if (NpmRegistryServiceImpl.Companion.isPublicNpmRegistryAllowed()) {
            return this.public.fetchPackageJsonFuture(packageName, versionOrRange, contextFileOrDir);
        }
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    private final VirtualFile orProjectRoot(VirtualFile $this$orProjectRoot) {
        VirtualFile virtualFile = $this$orProjectRoot;
        if (virtualFile == null) {
            virtualFile = ProjectUtil.guessProjectDir((Project)this.project);
        }
        return virtualFile;
    }

    private static final void findPackages$lambda$5(ArrayList $result, NodePackageBasicInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $result.add(it);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NpmRegistryServiceImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/javascript/nodejs/npm/registry/NpmRegistryServiceImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "isPublicNpmRegistryAllowed", "", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isPublicNpmRegistryAllowed() {
            return Registry.Companion.is("allow.public.npm.registry.access", true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

