/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library.download;

import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.templates.github.DownloadUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.UnknownHostException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDownloadManager {
    private ProgressIndicator myProgress;
    private final String myTestRoot;
    private final String myTargetDirPath;
    private JSDownloadException myLastException;
    private String myActualSource;
    private String myTargetFilePath;

    public JSDownloadManager(@Nullable String testRoot) {
        this(JSDownloadManager.getDefaultTargetDirPath(), testRoot);
    }

    public JSDownloadManager(@NotNull String targetDirPath, @Nullable String testRoot) {
        if (targetDirPath == null) {
            JSDownloadManager.$$$reportNull$$$0(0);
        }
        this.myTestRoot = testRoot;
        this.myTargetDirPath = targetDirPath;
        this.myLastException = null;
    }

    public static String getDefaultTargetDirPath() {
        return JSUtils.getExtLibsDirPath();
    }

    public void setProgressIndicator(@Nullable ProgressIndicator progressIndicator) {
        this.myProgress = progressIndicator;
    }

    @Nullable
    public String downloadLibrary(@NotNull String location, @NotNull String defaultExtension) {
        if (location == null) {
            JSDownloadManager.$$$reportNull$$$0(1);
        }
        if (defaultExtension == null) {
            JSDownloadManager.$$$reportNull$$$0(2);
        }
        this.myActualSource = location;
        this.myLastException = null;
        String adjustedLocation = this.getLocation(location, true);
        try {
            String adjustedFileName = this.getResultFileName(location, defaultExtension, true);
            return this.fetch(adjustedLocation, adjustedFileName);
        }
        catch (JSDownloadException e) {
            String originalLocation = this.getLocation(location, false);
            if (e.getCause() instanceof IOException && !originalLocation.equals(adjustedLocation)) {
                return this.downloadFile(originalLocation, defaultExtension);
            }
            this.myLastException = e;
            return null;
        }
    }

    @Nullable
    private String downloadFile(@NotNull String location, @NotNull String defaultExtension) {
        if (location == null) {
            JSDownloadManager.$$$reportNull$$$0(3);
        }
        if (defaultExtension == null) {
            JSDownloadManager.$$$reportNull$$$0(4);
        }
        this.myActualSource = location;
        this.myLastException = null;
        try {
            String targetFileName = this.getResultFileName(location, defaultExtension, false);
            return this.fetch(location, targetFileName);
        }
        catch (JSDownloadException e) {
            this.myLastException = e;
            return null;
        }
    }

    @NotNull
    protected String getLocation(@NotNull String location, boolean adjustLocation) {
        if (location == null) {
            JSDownloadManager.$$$reportNull$$$0(5);
        }
        String string = adjustLocation ? JSLibraryUtil.getDevVersionLocation(location, true) : location;
        if (string == null) {
            JSDownloadManager.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    protected String getResultFileName(@NotNull String location, @NotNull String defaultExtension, boolean adjustLocation) {
        String fileName;
        String currentExtension;
        if (location == null) {
            JSDownloadManager.$$$reportNull$$$0(7);
        }
        if (defaultExtension == null) {
            JSDownloadManager.$$$reportNull$$$0(8);
        }
        if ((currentExtension = FileUtilRt.getExtension((String)(fileName = JSLibraryUtil.makeUniqueFileName(location, adjustLocation)))).isEmpty() || FileTypeManager.getInstance().getFileTypeByExtension(currentExtension) == UnknownFileType.INSTANCE) {
            String string = fileName + defaultExtension;
            if (string == null) {
                JSDownloadManager.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = fileName;
        if (string == null) {
            JSDownloadManager.$$$reportNull$$$0(10);
        }
        return string;
    }

    public String getActualSource() {
        return this.myActualSource;
    }

    @Nullable
    public JSDownloadException getLastException() {
        return this.myLastException;
    }

    @NotNull
    private String fetch(String location, String targetFileName) throws JSDownloadException {
        this.myTargetFilePath = this.fetchImpl(location, targetFileName);
        if (this.myTargetFilePath == null) {
            JSDownloadManager.$$$reportNull$$$0(11);
        }
        return this.myTargetFilePath;
    }

    @NotNull
    protected String fetchImpl(String location, String targetFileName) throws JSDownloadException {
        String string;
        File targetDir = new File(this.myTargetDirPath);
        if (!targetDir.exists() && !targetDir.mkdirs()) {
            throw new JSDownloadException("Can not create " + this.myTargetDirPath + " directory.");
        }
        if (((String)location).startsWith("//")) {
            location = "http:" + (String)location;
        }
        String targetPath = this.myTargetDirPath + File.separatorChar + targetFileName;
        File targetFile = new File(targetPath);
        try {
            if (this.myTestRoot == null) {
                this.downloadImpl((String)location, targetFile);
            } else {
                File f = new File(((String)location).replaceFirst("^(http|https)://", FileUtil.toSystemIndependentName((String)this.myTestRoot) + "/"));
                FileUtil.copy((File)f, (File)targetFile);
            }
            string = targetPath;
        }
        catch (IOException e) {
            if (targetFile.exists()) {
                FileUtil.delete((File)targetFile);
            }
            throw new JSDownloadException(e);
        }
        if (string == null) {
            JSDownloadManager.$$$reportNull$$$0(12);
        }
        return string;
    }

    protected void downloadImpl(@NotNull String location, @NotNull File targetFile) throws IOException {
        if (location == null) {
            JSDownloadManager.$$$reportNull$$$0(13);
        }
        if (targetFile == null) {
            JSDownloadManager.$$$reportNull$$$0(14);
        }
        DownloadUtil.downloadAtomically((ProgressIndicator)this.myProgress, (String)location, (File)targetFile);
    }

    @Nullable
    public String getTargetFilePath() {
        return this.myTargetFilePath;
    }

    @NotNull
    public String getTargetDirPath() {
        String string = this.myTargetDirPath;
        if (string == null) {
            JSDownloadManager.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Nullable
    public ProgressIndicator getProgressIndicator() {
        return this.myProgress;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 9, 10, 11, 12, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDirPath";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultExtension";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/library/download/JSDownloadManager";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/library/download/JSDownloadManager";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultFileName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "fetch";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchImpl";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDirPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "downloadLibrary";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "downloadFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getResultFileName";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "downloadImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 9, 10, 11, 12, 15 -> new IllegalStateException(string);
        };
    }

    public static class JSDownloadException
    extends Exception {
        public JSDownloadException(String message) {
            super(message);
        }

        public JSDownloadException(Throwable e) {
            super(e);
        }

        @NotNull
        public String getReason() {
            Throwable t = this.getCause();
            if (t == null) {
                String string = StringUtil.notNullize((String)this.getMessage());
                if (string == null) {
                    JSDownloadException.$$$reportNull$$$0(0);
                }
                return string;
            }
            if (t instanceof FileNotFoundException) {
                return "File not found";
            }
            if (t instanceof UnknownHostException) {
                return "Unknown host";
            }
            String string = StringUtil.notNullize((String)t.getMessage());
            if (string == null) {
                JSDownloadException.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/download/JSDownloadManager$JSDownloadException", "getReason"));
        }
    }
}

