/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGlobalModuleExportDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.ActionScriptTextReferenceResolver;
import com.intellij.lang.javascript.psi.impl.JSReferenceSet;
import com.intellij.lang.javascript.psi.impl.JSReferenceSetElement;
import com.intellij.lang.javascript.psi.impl.JSTextReferenceResolver;
import com.intellij.lang.javascript.psi.resolve.JSReferenceResolver;
import com.intellij.lang.javascript.psi.resolve.JSTagContextBuilder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.QualifiedName;
import com.intellij.psi.xml.XmlToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTextReference
extends JSReferenceSetElement
implements EmptyResolveMessageProvider {
    protected JSTextReference(@NotNull JSReferenceSet set, @NotNull String s, int offset) {
        if (set == null) {
            JSTextReference.$$$reportNull$$$0(0);
        }
        if (s == null) {
            JSTextReference.$$$reportNull$$$0(1);
        }
        this(set, s, new TextRange(offset, offset + s.length()));
    }

    protected JSTextReference(@NotNull JSReferenceSet set, @NotNull String s, @NotNull TextRange rangeInElement) {
        if (set == null) {
            JSTextReference.$$$reportNull$$$0(2);
        }
        if (s == null) {
            JSTextReference.$$$reportNull$$$0(3);
        }
        if (rangeInElement == null) {
            JSTextReference.$$$reportNull$$$0(4);
        }
        super(set, s, rangeInElement);
    }

    @Override
    @NotNull
    public JSQualifiedName getQualifiedName() {
        List<Object> qualifierComponents = null;
        PsiReference prevContextReference = null;
        for (PsiReference ref2 : this.mySet.myReferences) {
            if (ref2 == this) break;
            if (qualifierComponents == null) {
                qualifierComponents = new ArrayList<String>(3);
            }
            qualifierComponents.add(ref2.getCanonicalText());
            prevContextReference = ref2;
        }
        if (qualifierComponents != null) {
            String qName;
            PsiElement psiElement = prevContextReference.resolve();
            if (psiElement instanceof XmlToken) {
                JSTagContextBuilder builder2 = new JSTagContextBuilder(psiElement, "HTMLElement");
                psiElement = builder2.element;
            }
            if (psiElement instanceof JSClass && (qName = ((JSClass)psiElement).getQualifiedName()) != null) {
                qualifierComponents = new ArrayList(3);
                qualifierComponents.addAll(QualifiedName.fromDottedString((String)qName).getComponents());
            }
            if (psiElement instanceof JSFile || psiElement instanceof TypeScriptGlobalModuleExportDeclaration) {
                qualifierComponents = Collections.emptyList();
            }
        }
        JSQualifiedName jSQualifiedName = this.qNameFromNames(qualifierComponents);
        if (jSQualifiedName == null) {
            JSTextReference.$$$reportNull$$$0(5);
        }
        return jSQualifiedName;
    }

    @NotNull
    protected JSQualifiedName qNameFromNames(@Nullable List<String> contextNames) {
        JSQualifiedNameImpl qualifier = contextNames != null ? JSQualifiedNameImpl.fromComponents(contextNames) : null;
        JSQualifiedNameImpl jSQualifiedNameImpl = JSQualifiedNameImpl.create(this.getCanonicalText(), qualifier);
        if (jSQualifiedNameImpl == null) {
            JSTextReference.$$$reportNull$$$0(6);
        }
        return jSQualifiedNameImpl;
    }

    @Override
    protected ResolveResult @NotNull [] doResolve() {
        PsiFile psiFile = this.mySet.getElement().getContainingFile();
        if (this.useActionScriptIndex(psiFile)) {
            ResolveResult[] resolveResultArray = ActionScriptTextReferenceResolver.resolve(this);
            if (resolveResultArray == null) {
                JSTextReference.$$$reportNull$$$0(7);
            }
            return resolveResultArray;
        }
        ResolveResult[] resolveResultArray = super.doResolve();
        if (resolveResultArray == null) {
            JSTextReference.$$$reportNull$$$0(8);
        }
        return resolveResultArray;
    }

    @Override
    @NotNull
    public JSReferenceResolver createResolver() {
        return new JSTextReferenceResolver(this.getElement(), this.isPrimary());
    }

    public boolean useActionScriptIndex(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            JSTextReference.$$$reportNull$$$0(9);
        }
        return DialectDetector.isActionScript((PsiElement)psiFile);
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        Object text = this.getCanonicalText();
        text = "'" + ((String)text).replace("'", "''") + "'";
        String string = JavaScriptBundle.message("javascript.unresolved.variable.or.type.name.message2", text);
        if (string == null) {
            JSTextReference.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInElement";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSTextReference";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSTextReference";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "qNameFromNames";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolve";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "useActionScriptIndex";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8, 10 -> new IllegalStateException(string);
        };
    }
}

