/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.changeSignature;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptParameterImpl;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSParameterInfo
implements ParameterInfo {
    public static final JSParameterInfo[] EMPTY_ARRAY = new JSParameterInfo[0];
    public static final ArrayFactory<JSParameterInfo> ARRAY_FACTORY = count -> count == 0 ? EMPTY_ARRAY : new JSParameterInfo[count];
    private final int myOldIndex;
    private String myTypeText;
    private String myCallValue;
    private String myInitializer;
    private String myModifiers = "";
    private String myOldModifiers = "";
    private String myDeclarationText;
    private boolean myIsDestructuring;
    private boolean myIsOptional;
    private boolean myIsParameterProperty;
    @Nullable
    private DialectOptionHolder myDialect;

    public static JSParameterInfo build(@NotNull JSParameterListElement parameterListElement, int index) {
        JSExpression initializerExpr;
        if (parameterListElement == null) {
            JSParameterInfo.$$$reportNull$$$0(0);
        }
        String initializer = (initializerExpr = parameterListElement.getInitializer()) == null ? null : initializerExpr.getText();
        String typeText = JSParameterInfo.buildTypeText(parameterListElement);
        JSParameter jsParameter = (JSParameter)ObjectUtils.tryCast((Object)parameterListElement, JSParameter.class);
        String modifiers = jsParameter != null && jsParameter.getAttributeList() != null ? jsParameter.getAttributeList().getText() : "";
        JSParameterInfo result2 = new JSParameterInfo(JSParameterInfo.buildDeclarationText(parameterListElement), typeText, initializer, null, index, parameterListElement.isOptional());
        result2.myModifiers = modifiers;
        result2.myIsDestructuring = parameterListElement instanceof JSDestructuringParameter;
        result2.myDialect = DialectDetector.dialectOfElement((PsiElement)parameterListElement);
        result2.myIsParameterProperty = parameterListElement instanceof JSParameter && TypeScriptPsiUtil.isFieldParameter((JSParameter)parameterListElement);
        return result2;
    }

    @NotNull
    private static String buildTypeText(@NotNull JSParameterListElement parameter) {
        JSType type2;
        DialectOptionHolder dialect;
        if (parameter == null) {
            JSParameterInfo.$$$reportNull$$$0(1);
        }
        if ((dialect = DialectDetector.dialectOfElement((PsiElement)parameter)) == null || !dialect.hasFeature(JSLanguageFeature.TYPES)) {
            return "";
        }
        JSType jSType = type2 = parameter instanceof TypeScriptParameterImpl ? TypeScriptPsiUtil.getTypeFromDeclaration((StubBasedPsiElementBase)parameter) : parameter.getJSType();
        if (dialect.isECMA4 && parameter.isRest()) {
            return "...";
        }
        if (type2 != null) {
            if (dialect.isTypeScript || dialect.isFlow) {
                String string = type2.getTypeText(JSType.TypeTextFormat.CODE);
                if (string == null) {
                    JSParameterInfo.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = type2.getResolvedTypeText();
            if (string == null) {
                JSParameterInfo.$$$reportNull$$$0(3);
            }
            return string;
        }
        return "";
    }

    private static String buildDeclarationText(@NotNull JSParameterListElement parameterListElement) {
        if (parameterListElement == null) {
            JSParameterInfo.$$$reportNull$$$0(4);
        }
        if (!DialectDetector.isActionScript((PsiElement)parameterListElement) && parameterListElement.isRest()) {
            return "..." + parameterListElement.getName();
        }
        if (parameterListElement instanceof TypeScriptParameterImpl && ((TypeScriptParameterImpl)parameterListElement).isDeclaredOptional()) {
            return parameterListElement.getName() + "?";
        }
        return parameterListElement.getName();
    }

    public JSParameterInfo(String declarationText, String type2, String initializer, String callValue, int oldIndex, boolean optional, @Nullable DialectOptionHolder dialect) {
        this(declarationText, type2, initializer, callValue, oldIndex);
        this.myIsOptional = optional;
        this.myDialect = dialect;
    }

    public JSParameterInfo(String declarationText, String type2, String initializer, String callValue, int oldIndex, boolean optional) {
        this(declarationText, type2, initializer, callValue, oldIndex);
        this.myIsOptional = optional;
    }

    public JSParameterInfo(String declarationText, String type2, String initializer, String callValue, int oldIndex) {
        this.myDeclarationText = declarationText;
        this.myInitializer = initializer;
        this.myOldIndex = oldIndex;
        this.myTypeText = type2;
        this.myCallValue = callValue;
    }

    public String getDeclarationText() {
        return this.myDeclarationText;
    }

    public void setDeclarationText(String value) {
        this.myDeclarationText = value;
    }

    public String getName() {
        return this.getDeclarationText();
    }

    public void setName(String name) {
        throw new UnsupportedOperationException();
    }

    public int getOldIndex() {
        return this.myOldIndex;
    }

    public String getDefaultValue() {
        return this.myCallValue;
    }

    public void setCallValue(String defaultValue) {
        this.myCallValue = defaultValue;
    }

    public String getTypeText() {
        return "null".equals(this.myTypeText) ? "*" : this.myTypeText;
    }

    public String getModifiersText() {
        return this.myModifiers;
    }

    public void setModifiersText(String modifiers) {
        this.myModifiers = modifiers;
    }

    public String getOldModifiers() {
        return this.myOldModifiers;
    }

    public void setOldModifiers(String oldModifiers) {
        this.myOldModifiers = oldModifiers;
    }

    public void setTypeText(String type2) {
        this.myTypeText = type2;
    }

    public boolean isUseAnySingleVariable() {
        return false;
    }

    public void setUseAnySingleVariable(boolean b) {
        throw new UnsupportedOperationException();
    }

    public String getInitializer() {
        return this.myInitializer;
    }

    public void setInitializer(String initializer) {
        this.myInitializer = initializer;
    }

    public boolean isOptional() {
        return this.myIsOptional;
    }

    public void setOptional(boolean optional) {
        this.myIsOptional = optional;
    }

    public boolean isDestructuringParameter() {
        return this.myIsDestructuring;
    }

    public boolean isRest() {
        return StringUtil.equals((CharSequence)this.myTypeText, (CharSequence)"...") || StringUtil.startsWith((CharSequence)this.myDeclarationText, (CharSequence)"...");
    }

    public boolean isParameterProperty() {
        return this.myIsParameterProperty;
    }

    @Nullable
    public DialectOptionHolder getDialect() {
        return this.myDialect;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterListElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/changeSignature/JSParameterInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/changeSignature/JSParameterInfo";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTypeText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeText";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildDeclarationText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

