/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.formatting.number;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchNamedGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.formatting.number.NumberFormat;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0080\b\u0018\u0000 $2\u00020\u0001:\u0001$B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\fH\u00d6\u0001J\b\u0010\"\u001a\u00020\u001fH\u0002J\b\u0010#\u001a\u00020\u0003H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0011\u0010\u0014\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u0011\u0010\u0016\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0010\u00a8\u0006%"}, d2={"Lorg/jetbrains/letsPlot/commons/formatting/number/FormattedNumber;", "", "integerPart", "", "fractionalPart", "exponentialPart", "expType", "Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$ExponentNotationType;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$ExponentNotationType;)V", "getExpType", "()Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$ExponentNotationType;", "exponentialLength", "", "getExponentialLength", "()I", "getExponentialPart", "()Ljava/lang/String;", "fractionalLength", "getFractionalLength", "getFractionalPart", "fullLength", "getFullLength", "integerLength", "getIntegerLength", "getIntegerPart", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "omitUnit", "toString", "Companion", "commons"})
@SourceDebugExtension(value={"SMAP\nFormattedNumber.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FormattedNumber.kt\norg/jetbrains/letsPlot/commons/formatting/number/FormattedNumber\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,49:1\n1#2:50\n*E\n"})
public final class FormattedNumber {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String integerPart;
    @NotNull
    private final String fractionalPart;
    @NotNull
    private final String exponentialPart;
    @NotNull
    private final NumberFormat.ExponentNotationType expType;
    private final int integerLength;
    private final int fractionalLength;
    private final int fullLength;
    @NotNull
    private static final Regex POWER_REGEX = new Regex("^\u00b7\\\\\\(10\\^\\{(?<degree>-?\\d+)\\}\\\\\\)$");

    public FormattedNumber(@NotNull String integerPart, @NotNull String fractionalPart, @NotNull String exponentialPart, @NotNull NumberFormat.ExponentNotationType expType) {
        Intrinsics.checkNotNullParameter((Object)integerPart, (String)"integerPart");
        Intrinsics.checkNotNullParameter((Object)fractionalPart, (String)"fractionalPart");
        Intrinsics.checkNotNullParameter((Object)exponentialPart, (String)"exponentialPart");
        Intrinsics.checkNotNullParameter((Object)((Object)expType), (String)"expType");
        this.integerPart = integerPart;
        this.fractionalPart = fractionalPart;
        this.exponentialPart = exponentialPart;
        this.expType = expType;
        this.integerLength = this.omitUnit() ? 0 : this.integerPart.length();
        this.fractionalLength = ((CharSequence)this.fractionalPart).length() == 0 ? 0 : this.fractionalPart.length() + 1;
        this.fullLength = this.integerLength + this.fractionalLength + this.getExponentialLength();
    }

    public /* synthetic */ FormattedNumber(String string, String string2, String string3, NumberFormat.ExponentNotationType exponentNotationType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            string3 = "";
        }
        if ((n & 8) != 0) {
            exponentNotationType = NumberFormat.ExponentNotationType.E;
        }
        this(string, string2, string3, exponentNotationType);
    }

    @NotNull
    public final String getIntegerPart() {
        return this.integerPart;
    }

    @NotNull
    public final String getFractionalPart() {
        return this.fractionalPart;
    }

    @NotNull
    public final String getExponentialPart() {
        return this.exponentialPart;
    }

    @NotNull
    public final NumberFormat.ExponentNotationType getExpType() {
        return this.expType;
    }

    public final int getIntegerLength() {
        return this.integerLength;
    }

    public final int getFractionalLength() {
        return this.fractionalLength;
    }

    public final int getExponentialLength() {
        MatchResult matchResult = Regex.find$default((Regex)POWER_REGEX, (CharSequence)this.exponentialPart, (int)0, (int)2, null);
        if (matchResult == null) {
            return this.exponentialPart.length();
        }
        MatchResult match2 = matchResult;
        MatchGroupCollection matchGroupCollection = match2.getGroups();
        Intrinsics.checkNotNull((Object)matchGroupCollection, (String)"null cannot be cast to non-null type kotlin.text.MatchNamedGroupCollection");
        MatchNamedGroupCollection matchGroups = (MatchNamedGroupCollection)matchGroupCollection;
        Object object = matchGroups.get("degree");
        if (object == null || (object = object.getValue()) == null) {
            return this.exponentialPart.length();
        }
        int degreeLength = ((String)object).length();
        int fullLength = 2 + degreeLength;
        return this.omitUnit() ? fullLength : 1 + fullLength;
    }

    public final int getFullLength() {
        return this.fullLength;
    }

    @NotNull
    public String toString() {
        String string;
        String it = string = ".";
        boolean bl = false;
        String string2 = ((CharSequence)this.fractionalPart).length() > 0 ? string : null;
        if (string2 == null) {
            string2 = "";
        }
        String fractionDelimiter = string2;
        String fullString = this.integerPart + fractionDelimiter + this.fractionalPart + this.exponentialPart;
        return this.omitUnit() ? StringsKt.replace$default((String)fullString, (String)"1\u00b7", (String)"", (boolean)false, (int)4, null) : fullString;
    }

    private final boolean omitUnit() {
        return this.expType == NumberFormat.ExponentNotationType.POW && Intrinsics.areEqual((Object)this.integerPart, (Object)"1") && ((CharSequence)this.fractionalPart).length() == 0 && ((CharSequence)this.exponentialPart).length() > 0;
    }

    @NotNull
    public final String component1() {
        return this.integerPart;
    }

    @NotNull
    public final String component2() {
        return this.fractionalPart;
    }

    @NotNull
    public final String component3() {
        return this.exponentialPart;
    }

    @NotNull
    public final NumberFormat.ExponentNotationType component4() {
        return this.expType;
    }

    @NotNull
    public final FormattedNumber copy(@NotNull String integerPart, @NotNull String fractionalPart, @NotNull String exponentialPart, @NotNull NumberFormat.ExponentNotationType expType) {
        Intrinsics.checkNotNullParameter((Object)integerPart, (String)"integerPart");
        Intrinsics.checkNotNullParameter((Object)fractionalPart, (String)"fractionalPart");
        Intrinsics.checkNotNullParameter((Object)exponentialPart, (String)"exponentialPart");
        Intrinsics.checkNotNullParameter((Object)((Object)expType), (String)"expType");
        return new FormattedNumber(integerPart, fractionalPart, exponentialPart, expType);
    }

    public static /* synthetic */ FormattedNumber copy$default(FormattedNumber formattedNumber, String string, String string2, String string3, NumberFormat.ExponentNotationType exponentNotationType, int n, Object object) {
        if ((n & 1) != 0) {
            string = formattedNumber.integerPart;
        }
        if ((n & 2) != 0) {
            string2 = formattedNumber.fractionalPart;
        }
        if ((n & 4) != 0) {
            string3 = formattedNumber.exponentialPart;
        }
        if ((n & 8) != 0) {
            exponentNotationType = formattedNumber.expType;
        }
        return formattedNumber.copy(string, string2, string3, exponentNotationType);
    }

    public int hashCode() {
        int result2 = this.integerPart.hashCode();
        result2 = result2 * 31 + this.fractionalPart.hashCode();
        result2 = result2 * 31 + this.exponentialPart.hashCode();
        result2 = result2 * 31 + this.expType.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FormattedNumber)) {
            return false;
        }
        FormattedNumber formattedNumber = (FormattedNumber)other;
        if (!Intrinsics.areEqual((Object)this.integerPart, (Object)formattedNumber.integerPart)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fractionalPart, (Object)formattedNumber.fractionalPart)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.exponentialPart, (Object)formattedNumber.exponentialPart)) {
            return false;
        }
        return this.expType == formattedNumber.expType;
    }

    public FormattedNumber() {
        this(null, null, null, null, 15, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/letsPlot/commons/formatting/number/FormattedNumber$Companion;", "", "()V", "POWER_REGEX", "Lkotlin/text/Regex;", "getPOWER_REGEX$annotations", "commons"})
    public static final class Companion {
        private Companion() {
        }

        private static /* synthetic */ void getPOWER_REGEX$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

