/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.intern.spatial.projections;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.math.MathKt;
import org.jetbrains.letsPlot.commons.intern.spatial.projections.Projection;
import org.jetbrains.letsPlot.commons.intern.spatial.projections.ProjectionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/spatial/projections/ConicConformalProjection;", "Lorg/jetbrains/letsPlot/commons/intern/spatial/projections/Projection;", "y0", "", "y1", "(DD)V", "f", "n", "invert", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "v", "project", "validDomain", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "Companion", "commons"})
public final class ConicConformalProjection
implements Projection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double n;
    private final double f;
    @NotNull
    private static final DoubleRectangle VALID_RECTANGLE = DoubleRectangle.Companion.LTRB(-180.0, -65.0, 180.0, 90.0);
    private static final double EPSILON = 0.001;

    public ConicConformalProjection(double y0, double y1) {
        double cy0 = Math.cos(y0);
        this.n = y0 == y1 ? Math.sin(y0) : Math.log(cy0 / Math.cos(y1)) / Math.log(ConicConformalProjection.Companion.tany(y1) / ConicConformalProjection.Companion.tany(y0));
        this.f = cy0 * Math.pow(ConicConformalProjection.Companion.tany(y0), this.n) / this.n;
    }

    @Override
    @NotNull
    public DoubleRectangle validDomain() {
        return VALID_RECTANGLE;
    }

    @Override
    @Nullable
    public DoubleVector project(@NotNull DoubleVector v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        double x2 = MathKt.toRadians(v.getX());
        double y2 = MathKt.toRadians(v.getY());
        if (this.f > 0.0) {
            if (y2 < -1.5697963267948967) {
                y2 = -1.5697963267948967;
            }
        } else if (y2 > 1.5697963267948967) {
            y2 = 1.5697963267948967;
        }
        double r = this.f / Math.pow(ConicConformalProjection.Companion.tany(y2), this.n);
        double px = r * Math.sin(this.n * x2);
        double py = this.f - r * Math.cos(this.n * x2);
        return ProjectionsKt.finiteDoubleVectorOrNull(px, py);
    }

    @Override
    @Nullable
    public DoubleVector invert(@NotNull DoubleVector v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        double x2 = v.getX();
        double y2 = v.getY();
        double fy = this.f - y2;
        double r = Math.signum(this.n) * Math.sqrt(x2 * x2 + fy * fy);
        double ix = MathKt.toDegrees(Math.atan2(x2, Math.abs(fy)) / this.n * Math.signum(fy));
        double iy = MathKt.toDegrees((double)2 * Math.atan(Math.pow(this.f / r, 1.0 / this.n)) - 1.5707963267948966);
        return ProjectionsKt.finiteDoubleVectorOrNull(ix, iy);
    }

    @Override
    public boolean getNonlinear() {
        return Projection.DefaultImpls.getNonlinear(this);
    }

    @Override
    public boolean getCylindrical() {
        return Projection.DefaultImpls.getCylindrical(this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/spatial/projections/ConicConformalProjection$Companion;", "", "()V", "EPSILON", "", "VALID_RECTANGLE", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "tany", "y", "commons"})
    public static final class Companion {
        private Companion() {
        }

        private final double tany(double y2) {
            return Math.tan((1.5707963267948966 + y2) / (double)2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

