/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.editor;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.less.psi.LESSFile;

public final class LessBraceInterpolationTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        if (project == null) {
            LessBraceInterpolationTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            LessBraceInterpolationTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            LessBraceInterpolationTypedHandler.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            LessBraceInterpolationTypedHandler.$$$reportNull$$$0(3);
        }
        if (file instanceof LESSFile && c == '{') {
            Document document = editor.getDocument();
            int offset = editor.getCaretModel().getOffset();
            CharSequence chars = document.getCharsSequence();
            if (offset > 0 && chars.charAt(offset - 1) == '@') {
                if (LessBraceInterpolationTypedHandler.alreadyHasEnding(chars, c, '}', offset)) {
                    TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                    if (result == null) {
                        LessBraceInterpolationTypedHandler.$$$reportNull$$$0(4);
                    }
                    return result;
                }
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"{}", (boolean)true, (int)1);
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    LessBraceInterpolationTypedHandler.$$$reportNull$$$0(5);
                }
                return result;
            }
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            LessBraceInterpolationTypedHandler.$$$reportNull$$$0(6);
        }
        return result;
    }

    private static boolean alreadyHasEnding(CharSequence chars, char startChar, char endChar, int offset) {
        int i;
        for (i = offset; i < chars.length() && chars.charAt(i) != startChar && chars.charAt(i) != endChar && chars.charAt(i) != '\n'; ++i) {
        }
        return i + 1 < chars.length() && chars.charAt(i) == endChar;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/less/editor/LessBraceInterpolationTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/less/editor/LessBraceInterpolationTypedHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

