/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.outputs.util;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.softwrap.EmptySoftWrapPainter;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapPainter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0000\u001a$\u0010\u000b\u001a\u00020\f*\u00020\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0000\u001a)\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000b\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u00132\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u001a\u001a\u0010\u0014\u001a\u00020\u0004*\u00020\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0016H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"4\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003*\u00020\u00062\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038@@BX\u0080\u000e\u00a2\u0006\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"key", "Ljava/lang/Object;", "value", "", "", "oldStrings", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "getOldStrings", "(Lcom/intellij/execution/impl/ConsoleViewImpl;)Ljava/util/List;", "setOldStrings", "(Lcom/intellij/execution/impl/ConsoleViewImpl;Ljava/util/List;)V", "setContent", "", "strings", "processOutputType", "Lcom/intellij/execution/process/ProcessOutputType;", "calculateStringToAppend", "currentText", "", "Lcom/intellij/openapi/util/NlsSafe;", "trimLineEndIfNecessary", "stringsIterator", "", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nConsoleViewUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsoleViewUtils.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/util/ConsoleViewUtilsKt\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n19#2:118\n1#3:119\n*S KotlinDebug\n*F\n+ 1 ConsoleViewUtils.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/util/ConsoleViewUtilsKt\n*L\n19#1:118\n*E\n"})
public final class ConsoleViewUtilsKt {
    @NotNull
    private static final Object key = new Object();

    @NotNull
    public static final List<String> getOldStrings(@NotNull ConsoleViewImpl $this$oldStrings) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$oldStrings, (String)"<this>");
        Object $this$asSafely$iv = $this$oldStrings.getClientProperty(key);
        boolean $i$f$asSafely = false;
        Object object = $this$asSafely$iv;
        if (!(object instanceof List)) {
            object = null;
        }
        if ((list = (List)object) == null) {
            List list2;
            List it = list2 = CollectionsKt.emptyList();
            boolean bl = false;
            ConsoleViewUtilsKt.setOldStrings($this$oldStrings, it);
            list = list2;
        }
        return list;
    }

    private static final void setOldStrings(ConsoleViewImpl $this$oldStrings, List<String> value) {
        $this$oldStrings.putClientProperty(key, value);
    }

    public static final void setContent(@NotNull ConsoleViewImpl $this$setContent, @NotNull List<String> strings, @NotNull ProcessOutputType processOutputType) {
        Intrinsics.checkNotNullParameter((Object)$this$setContent, (String)"<this>");
        Intrinsics.checkNotNullParameter(strings, (String)"strings");
        Intrinsics.checkNotNullParameter((Object)processOutputType, (String)"processOutputType");
        ThreadingAssertions.assertEventDispatchThread();
        ApplicationManager.getApplication().runWriteIntentReadAction(() -> ConsoleViewUtilsKt.setContent$lambda$1($this$setContent));
        if (Intrinsics.areEqual(ConsoleViewUtilsKt.getOldStrings($this$setContent), strings)) {
            return;
        }
        Object object = $this$setContent.getEditor();
        if (object == null || (object = object.getDocument()) == null || (object = object.getCharsSequence()) == null) {
            object = "";
        }
        Object text = object;
        List<String> newStrings = ConsoleViewUtilsKt.calculateStringToAppend((CharSequence)text, strings);
        AnsiEscapeDecoder decoder = new AnsiEscapeDecoder();
        for (String string : newStrings) {
            decoder.escapeText(string, (Key)processOutputType, (arg_0, arg_1) -> ConsoleViewUtilsKt.setContent$lambda$2(processOutputType, $this$setContent, arg_0, arg_1));
        }
        ApplicationManager.getApplication().runWriteIntentReadAction(() -> ConsoleViewUtilsKt.setContent$lambda$3($this$setContent));
        $this$setContent.revalidate();
        Object object2 = $this$setContent.getEditor();
        if (object2 != null && (object2 = object2.getContentComponent()) != null) {
            ((JComponent)object2).revalidate();
        }
        ApplicationManager.getApplication().runWriteIntentReadAction(() -> ConsoleViewUtilsKt.setContent$lambda$4($this$setContent));
        ConsoleViewUtilsKt.setOldStrings($this$setContent, CollectionsKt.toList((Iterable)strings));
    }

    public static /* synthetic */ void setContent$default(ConsoleViewImpl consoleViewImpl, List list, ProcessOutputType processOutputType, int n, Object object) {
        if ((n & 2) != 0) {
            processOutputType = ProcessOutputType.STDOUT;
        }
        ConsoleViewUtilsKt.setContent(consoleViewImpl, list, processOutputType);
    }

    private static final List<String> calculateStringToAppend(CharSequence currentText, List<String> strings) {
        Object object;
        int pointer = 0;
        Iterator<String> stringsIterator = strings.iterator();
        String lastLine = "";
        int lastLineStart = 0;
        int lastLinePointer = 0;
        while (stringsIterator.hasNext()) {
            lastLine = ConsoleViewUtilsKt.trimLineEndIfNecessary(stringsIterator.next(), stringsIterator);
            for (lastLinePointer = 0; pointer < currentText.length() && lastLinePointer < lastLine.length() && lastLine.charAt(lastLinePointer) == currentText.charAt(pointer); ++lastLinePointer, ++pointer) {
                if (currentText.charAt(pointer) != '\n' && currentText.charAt(pointer) != '\r') continue;
                lastLineStart = pointer + 1;
            }
            if (lastLinePointer >= lastLine.length()) continue;
        }
        List result = new ArrayList();
        if (pointer == currentText.length()) {
            String string = lastLine.substring(lastLinePointer);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        } else {
            int sameChars = pointer - lastLinePointer;
            int differentChars = currentText.length() - pointer;
            if (sameChars > differentChars) {
                String string = StringsKt.repeat((CharSequence)"\b", (int)differentChars);
                String string2 = lastLine.substring(lastLinePointer);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                object = string + string2;
            } else {
                object = "\r" + lastLine;
            }
        }
        String append = object;
        result.add(append);
        while (stringsIterator.hasNext()) {
            result.add(ConsoleViewUtilsKt.trimLineEndIfNecessary(stringsIterator.next(), stringsIterator));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static final String trimLineEndIfNecessary(String $this$trimLineEndIfNecessary, Iterator<String> stringsIterator) {
        void var2_2;
        String it = StringsKt.replace$default((String)$this$trimLineEndIfNecessary, (String)"\r\n", (String)"\n", (boolean)false, (int)4, null);
        boolean bl = false;
        return !stringsIterator.hasNext() ? ((Object)StringsKt.trimEnd((CharSequence)it)).toString() : var2_2;
    }

    private static final Unit setContent$lambda$1(ConsoleViewImpl $this_setContent) {
        $this_setContent.flushDeferredText();
        return Unit.INSTANCE;
    }

    private static final void setContent$lambda$2(ProcessOutputType $processOutputType, ConsoleViewImpl $this_setContent, String text, Key attributes) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Key key = Registry.Companion.is("jupyter.output.colored.errors") || !Intrinsics.areEqual((Object)$processOutputType, (Object)ProcessOutputType.STDERR) ? attributes : (Key)$processOutputType;
        Intrinsics.checkNotNull((Object)key);
        Key attr = key;
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.getConsoleViewType((Key)attr);
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"getConsoleViewType(...)");
        $this_setContent.print(text, consoleViewContentType);
    }

    private static final Unit setContent$lambda$3(ConsoleViewImpl $this_setContent) {
        $this_setContent.flushDeferredText();
        return Unit.INSTANCE;
    }

    private static final Unit setContent$lambda$4(ConsoleViewImpl $this_setContent) {
        block0: {
            Editor editor = $this_setContent.getEditor();
            EditorImpl editorImpl = editor instanceof EditorImpl ? (EditorImpl)editor : null;
            if (editorImpl == null || (editorImpl = editorImpl.getSoftWrapModel()) == null) break block0;
            editorImpl.setSoftWrapPainter((SoftWrapPainter)EmptySoftWrapPainter.INSTANCE);
        }
        return Unit.INSTANCE;
    }
}

