/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.community.impl.huggingFace.service;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.python.community.impl.huggingFace.cache.HuggingFaceCacheFillService;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.python.packaging.PyPackageInstallUtils;
import com.jetbrains.python.packaging.common.PythonPackageManagementListener;
import com.jetbrains.python.packaging.management.PythonPackageManager;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0012H\u0002J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0015H\u0002J\b\u0010\u0019\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/python/community/impl/huggingFace/service/HuggingFaceLibrariesTracker;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "isAnyHFLibraryInstalled", "", "connection", "Lcom/intellij/util/messages/MessageBusConnection;", "cacheFillService", "Lcom/intellij/python/community/impl/huggingFace/cache/HuggingFaceCacheFillService;", "relevantLibraries", "", "", "setupSdkListener", "", "detachSdkListener", "getProjectPythonSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "updateHFLibraryInstallStatus", "isAnyHFLibraryInstalledInSdk", "sdk", "dispose", "intellij.python.community.impl.huggingFace"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nHuggingFaceLibrariesTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HuggingFaceLibrariesTracker.kt\ncom/intellij/python/community/impl/huggingFace/service/HuggingFaceLibrariesTracker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1755#2,3:81\n*S KotlinDebug\n*F\n+ 1 HuggingFaceLibrariesTracker.kt\ncom/intellij/python/community/impl/huggingFace/service/HuggingFaceLibrariesTracker\n*L\n75#1:81,3\n*E\n"})
public final class HuggingFaceLibrariesTracker
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    private volatile boolean isAnyHFLibraryInstalled;
    @Nullable
    private MessageBusConnection connection;
    @NotNull
    private final HuggingFaceCacheFillService cacheFillService;
    @NotNull
    private final Set<String> relevantLibraries;

    public HuggingFaceLibrariesTracker(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
        this.connection = this.project.getMessageBus().connect((Disposable)this);
        Object object = this.project.getService(HuggingFaceCacheFillService.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
        this.cacheFillService = (HuggingFaceCacheFillService)object;
        Object[] objectArray = new String[]{"diffusers", "transformers", "allennlp", "spacy", "asteroid", "flair", "keras", "sentence-transformers", "stable-baselines3", "adapters", "huggingface_hub"};
        this.relevantLibraries = SetsKt.setOf((Object[])objectArray);
        this.setupSdkListener();
    }

    public final boolean isAnyHFLibraryInstalled() {
        return this.isAnyHFLibraryInstalled;
    }

    private final void setupSdkListener() {
        block0: {
            MessageBusConnection messageBusConnection = this.connection;
            if (messageBusConnection == null) break block0;
            messageBusConnection.subscribe(PythonPackageManager.Companion.getPACKAGE_MANAGEMENT_TOPIC(), (Object)new PythonPackageManagementListener(this){
                final /* synthetic */ HuggingFaceLibrariesTracker this$0;
                {
                    this.this$0 = $receiver;
                }

                public void packagesChanged(Sdk sdk2) {
                    Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
                    Sdk projectSdk = HuggingFaceLibrariesTracker.access$getProjectPythonSdk(this.this$0);
                    if (Intrinsics.areEqual((Object)sdk2, (Object)projectSdk)) {
                        BuildersKt.launch$default((CoroutineScope)HuggingFaceLibrariesTracker.access$getCoroutineScope$p(this.this$0), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ HuggingFaceLibrariesTracker this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        HuggingFaceLibrariesTracker.access$updateHFLibraryInstallStatus(this.this$0);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null);
                    }
                }
            });
        }
    }

    private final void detachSdkListener() {
        MessageBusConnection messageBusConnection = this.connection;
        if (messageBusConnection != null) {
            messageBusConnection.disconnect();
        }
        this.connection = null;
    }

    private final Sdk getProjectPythonSdk() {
        return PythonSdkUtil.findPythonSdk((Module)ArraysKt.firstOrNull((Object[])ProjectUtil.getModules((Project)this.project)));
    }

    private final void updateHFLibraryInstallStatus() {
        if (this.isAnyHFLibraryInstalled) {
            return;
        }
        Sdk sdk2 = this.getProjectPythonSdk();
        if (sdk2 == null) {
            return;
        }
        Sdk sdk3 = sdk2;
        if (this.isAnyHFLibraryInstalledInSdk(sdk3)) {
            this.isAnyHFLibraryInstalled = true;
            this.cacheFillService.triggerCacheFillIfNeeded();
            this.detachSdkListener();
        }
    }

    private final boolean isAnyHFLibraryInstalledInSdk(Sdk sdk2) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.relevantLibraries;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String lib = (String)element$iv;
                    boolean bl2 = false;
                    if (!(PyPackageInstallUtils.INSTANCE.getPackageVersion(this.project, sdk2, lib) != null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public void dispose() {
        this.detachSdkListener();
    }

    public static final /* synthetic */ Sdk access$getProjectPythonSdk(HuggingFaceLibrariesTracker $this) {
        return $this.getProjectPythonSdk();
    }

    public static final /* synthetic */ CoroutineScope access$getCoroutineScope$p(HuggingFaceLibrariesTracker $this) {
        return $this.coroutineScope;
    }

    public static final /* synthetic */ void access$updateHFLibraryInstallStatus(HuggingFaceLibrariesTracker $this) {
        $this.updateHFLibraryInstallStatus();
    }
}

