/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsonpath.psi;

import com.intellij.jsonpath.psi.JsonPathStringLiteral;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class JsonPathPsiUtils {
    private static final String ourEscapesTable = "\"\"\\\\//b\bf\fn\nr\rt\t";
    static final Key<List<Pair<TextRange, String>>> STRING_FRAGMENTS = new Key("JSONPATH string fragments");

    private JsonPathPsiUtils() {
    }

    @NotNull
    public static List<Pair<TextRange, String>> getTextFragments(@NotNull JsonPathStringLiteral literal) {
        int contentEnd;
        List cached;
        if (literal == null) {
            JsonPathPsiUtils.$$$reportNull$$$0(0);
        }
        if ((cached = (List)literal.getUserData(STRING_FRAGMENTS)) != null) {
            List list = cached;
            if (list == null) {
                JsonPathPsiUtils.$$$reportNull$$$0(1);
            }
            return list;
        }
        ArrayList<Pair<TextRange, String>> result = new ArrayList<Pair>();
        String text = literal.getText();
        int length = text.length();
        int pos = 1;
        int unescapedSequenceStart = 1;
        while (pos < length) {
            if (text.charAt(pos) == '\\') {
                if (unescapedSequenceStart != pos) {
                    result.add(Pair.create((Object)new TextRange(unescapedSequenceStart, pos), (Object)text.substring(unescapedSequenceStart, pos)));
                }
                if (pos == length - 1) {
                    result.add(Pair.create((Object)new TextRange(pos, pos + 1), (Object)"\\"));
                    break;
                }
                char next = text.charAt(pos + 1);
                switch (next) {
                    case '\"': 
                    case '/': 
                    case '\\': 
                    case 'b': 
                    case 'f': 
                    case 'n': 
                    case 'r': 
                    case 't': {
                        int idx = ourEscapesTable.indexOf(next);
                        result.add((Pair<TextRange, String>)Pair.create((Object)new TextRange(pos, pos + 2), (Object)ourEscapesTable.substring(idx + 1, idx + 2)));
                        pos += 2;
                        break;
                    }
                    case 'u': {
                        int i;
                        for (i = pos + 2; i < pos + 6 && i != length && StringUtil.isHexDigit((char)text.charAt(i)); ++i) {
                        }
                        result.add((Pair<TextRange, String>)Pair.create((Object)new TextRange(pos, i), (Object)text.substring(pos, i)));
                        pos = i;
                        break;
                    }
                    default: {
                        result.add((Pair<TextRange, String>)Pair.create((Object)new TextRange(pos, pos + 2), (Object)text.substring(pos, pos + 2)));
                        pos += 2;
                    }
                }
                unescapedSequenceStart = pos;
                continue;
            }
            ++pos;
        }
        int n = contentEnd = text.charAt(0) == text.charAt(length - 1) ? length - 1 : length;
        if (unescapedSequenceStart < contentEnd) {
            result.add(Pair.create((Object)new TextRange(unescapedSequenceStart, contentEnd), (Object)text.substring(unescapedSequenceStart, contentEnd)));
        }
        result = Collections.unmodifiableList(result);
        literal.putUserData(STRING_FRAGMENTS, result);
        ArrayList<Pair<TextRange, String>> arrayList = result;
        if (arrayList == null) {
            JsonPathPsiUtils.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsonpath/psi/JsonPathPsiUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsonpath/psi/JsonPathPsiUtils";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextFragments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTextFragments";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

