/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jinja.ref;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.jinja.ref.Jinja2Reference;
import com.intellij.jinja.template.psi.impl.DjangoTagElementImpl;
import com.intellij.jinja.template.psi.impl.Jinja2BlockNameImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Jinja2BlockNameReference
extends Jinja2Reference {
    public Jinja2BlockNameReference(@NotNull PsiElement element) {
        if (element == null) {
            Jinja2BlockNameReference.$$$reportNull$$$0(0);
        }
        super(element);
    }

    public PsiElement resolve() {
        FindOpenBlockProcessor processor = new FindOpenBlockProcessor(this.getElement().getText());
        Jinja2BlockNameReference.processPrecedingBlockTags(this.getElement(), processor);
        if (processor.getOpenBlock() != null) {
            return PsiTreeUtil.findChildOfType((PsiElement)processor.getOpenBlock(), Jinja2BlockNameImpl.class);
        }
        return null;
    }

    public Object @NotNull [] getVariants() {
        FindPrecedingBlocksProcessor processor = new FindPrecedingBlocksProcessor();
        Jinja2BlockNameReference.processPrecedingBlockTags(this.getElement(), processor);
        ArrayList<LookupElementBuilder> result = new ArrayList<LookupElementBuilder>();
        for (Jinja2BlockNameImpl tag : processor.getOpenBlocks()) {
            result.add(LookupElementBuilder.create((String)tag.getName()));
        }
        Object[] objectArray = result.toArray();
        if (objectArray == null) {
            Jinja2BlockNameReference.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    public static void processPrecedingBlockTags(PsiElement element, BlockProcessor blockProcessor) {
        DjangoTagElementImpl parent = (DjangoTagElementImpl)PsiTreeUtil.getParentOfType((PsiElement)element, DjangoTagElementImpl.class);
        while ((parent = (DjangoTagElementImpl)PsiTreeUtil.getPrevSiblingOfType((PsiElement)parent, DjangoTagElementImpl.class)) == null || !(!"block".equals(parent.getName()) ? "endblock".equals(parent.getName()) && !blockProcessor.endBlock(parent) : !blockProcessor.block(parent))) {
            if (parent != null) continue;
        }
    }

    @Nullable
    public String getOpenBlockCandidateName() {
        Jinja2BlockNameImpl blockName;
        FindMatchingOpenBlock processor = new FindMatchingOpenBlock();
        Jinja2BlockNameReference.processPrecedingBlockTags(this.getElement(), processor);
        if (processor.getMatchingOpenBlock() != null && (blockName = (Jinja2BlockNameImpl)PsiTreeUtil.findChildOfType((PsiElement)processor.getMatchingOpenBlock(), Jinja2BlockNameImpl.class)) != null) {
            return blockName.getName();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jinja/ref/Jinja2BlockNameReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jinja/ref/Jinja2BlockNameReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static final class FindOpenBlockProcessor
    implements BlockProcessor {
        private final String name;
        private DjangoTagElementImpl openBlock;

        private FindOpenBlockProcessor(@NotNull String name) {
            if (name == null) {
                FindOpenBlockProcessor.$$$reportNull$$$0(0);
            }
            this.openBlock = null;
            this.name = name;
        }

        @Nullable
        public DjangoTagElementImpl getOpenBlock() {
            return this.openBlock;
        }

        @Override
        public boolean block(DjangoTagElementImpl block) {
            Jinja2BlockNameImpl blockName = (Jinja2BlockNameImpl)PsiTreeUtil.findChildOfType((PsiElement)block, Jinja2BlockNameImpl.class);
            if (blockName != null && this.name.equals(blockName.getName())) {
                this.openBlock = block;
                return false;
            }
            return true;
        }

        @Override
        public boolean endBlock(DjangoTagElementImpl endBlock) {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/jinja/ref/Jinja2BlockNameReference$FindOpenBlockProcessor", "<init>"));
        }
    }

    private static interface BlockProcessor {
        public boolean block(DjangoTagElementImpl var1);

        public boolean endBlock(DjangoTagElementImpl var1);
    }

    private static class FindPrecedingBlocksProcessor
    implements BlockProcessor {
        private final Stack<DjangoTagElementImpl> closeTags = new Stack();
        private final List<Jinja2BlockNameImpl> openBlocks = new ArrayList<Jinja2BlockNameImpl>();

        private FindPrecedingBlocksProcessor() {
        }

        @Override
        public boolean block(DjangoTagElementImpl block) {
            if (this.closeTags.empty()) {
                return this.foundNotMatchingBlock(block);
            }
            this.closeTags.pop();
            return true;
        }

        protected boolean foundNotMatchingBlock(DjangoTagElementImpl block) {
            Jinja2BlockNameImpl blockName = (Jinja2BlockNameImpl)PsiTreeUtil.findChildOfType((PsiElement)block, Jinja2BlockNameImpl.class);
            if (blockName != null) {
                this.openBlocks.add(blockName);
            }
            return true;
        }

        @Override
        public boolean endBlock(DjangoTagElementImpl endBlock) {
            this.closeTags.push((Object)endBlock);
            return true;
        }

        public List<Jinja2BlockNameImpl> getOpenBlocks() {
            return this.openBlocks;
        }
    }

    private static class FindMatchingOpenBlock
    extends FindPrecedingBlocksProcessor {
        private DjangoTagElementImpl myOpenBlock = null;

        private FindMatchingOpenBlock() {
        }

        @Override
        protected boolean foundNotMatchingBlock(DjangoTagElementImpl block) {
            this.myOpenBlock = block;
            return false;
        }

        public DjangoTagElementImpl getMatchingOpenBlock() {
            return this.myOpenBlock;
        }
    }
}

