/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.profiler.calltree;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.ui.NativeCallStackElementRenderer;
import java.awt.FontMetrics;
import java.awt.geom.Rectangle2D;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J \u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/python/profiler/calltree/PyCallStackElementRenderer;", "Lcom/intellij/profiler/ui/NativeCallStackElementRenderer;", "<init>", "()V", "getText", "", "node", "Lcom/intellij/profiler/api/BaseCallStackElement;", "fillTextInsideNode", "rect", "Ljava/awt/geom/Rectangle2D;", "fontMetrics", "Ljava/awt/FontMetrics;", "Companion", "intellij.python.profiler"})
public final class PyCallStackElementRenderer
extends NativeCallStackElementRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NlsSafe
    @NotNull
    public String getText(@NotNull BaseCallStackElement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return node.fullName();
    }

    @NotNull
    public String fillTextInsideNode(@NotNull BaseCallStackElement node, @NotNull Rectangle2D rect, @NotNull FontMetrics fontMetrics) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"fontMetrics");
        return PyCallStackElementRenderer.Companion.fitTextToRect(node.toString(), rect, fontMetrics);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\u000b\u001a\u00020\f*\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/python/profiler/calltree/PyCallStackElementRenderer$Companion;", "", "<init>", "()V", "fitTextToRect", "", "text", "rect", "Ljava/awt/geom/Rectangle2D;", "fontMetrics", "Ljava/awt/FontMetrics;", "averageCharWidth", "", "intellij.python.profiler"})
    public static final class Companion {
        private Companion() {
        }

        private final String fitTextToRect(String text, Rectangle2D rect, FontMetrics fontMetrics) {
            int availableWidth = (int)Math.round((rect.getWidth() - 0.0) / this.averageCharWidth(text, fontMetrics));
            String string = StringUtil.shortenTextWithEllipsis((String)text, (int)RangesKt.coerceAtLeast((int)availableWidth, (int)1), (int)0, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenTextWithEllipsis(...)");
            return string;
        }

        private final double averageCharWidth(String $this$averageCharWidth, FontMetrics fontMetrics) {
            return $this$averageCharWidth.chars().map(arg_0 -> Companion.averageCharWidth$lambda$0(fontMetrics, arg_0)).average().getAsDouble();
        }

        private static final int averageCharWidth$lambda$0(FontMetrics $fontMetrics, int it) {
            return $fontMetrics.charWidth(it);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

