/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.options;

import com.intellij.copyright.CopyrightBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.maddyhome.idea.copyright.CopyrightProfile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

public final class ExternalOptionHelper {
    private static final Logger logger = Logger.getInstance((String)ExternalOptionHelper.class.getName());

    @Nullable
    public static List<CopyrightProfile> loadOptions(File file) {
        try {
            ArrayList<CopyrightProfile> profiles = new ArrayList<CopyrightProfile>();
            Element root = JDOMUtil.load((File)file);
            if (root.getName().equals("component")) {
                Element copyrightElement = root.getChild("copyright");
                if (copyrightElement != null) {
                    ExternalOptionHelper.extractNewNoticeAndKeyword(copyrightElement, profiles);
                }
            } else {
                for (Element component : root.getChildren("component")) {
                    String name = component.getAttributeValue("name");
                    if (name.equals("CopyrightManager")) {
                        for (Element o : component.getChildren("copyright")) {
                            ExternalOptionHelper.extractNewNoticeAndKeyword(o, profiles);
                        }
                        continue;
                    }
                    if (!name.equals("copyright")) continue;
                    ExternalOptionHelper.extractNoticeAndKeyword(component, profiles);
                }
            }
            return profiles;
        }
        catch (Exception e) {
            logger.info((Throwable)e);
            Messages.showErrorDialog((String)e.getMessage(), (String)CopyrightBundle.message("dialog.title.import.failure", new Object[0]));
            return null;
        }
    }

    public static void extractNoticeAndKeyword(Element valueElement, List<? super CopyrightProfile> profiles) {
        CopyrightProfile profile = new CopyrightProfile();
        boolean extract = false;
        for (Element l : valueElement.getChildren("LanguageOptions")) {
            if (!l.getAttributeValue("name").equals("__TEMPLATE__")) continue;
            for (Element o1 : l.getChildren("option")) {
                extract |= ExternalOptionHelper.extract(profile, o1);
            }
        }
        if (extract) {
            profiles.add(profile);
        }
    }

    public static void extractNewNoticeAndKeyword(Element valueElement, List<? super CopyrightProfile> profiles) {
        CopyrightProfile profile = new CopyrightProfile();
        boolean extract = false;
        for (Element l : valueElement.getChildren("option")) {
            extract |= ExternalOptionHelper.extract(profile, l);
        }
        if (extract) {
            profiles.add(profile);
        }
    }

    private static boolean extract(CopyrightProfile profile, Element el) {
        if (el.getAttributeValue("name").equals("notice")) {
            profile.setNotice(el.getAttributeValue("value"));
            return true;
        }
        if (el.getAttributeValue("name").equals("keyword")) {
            profile.setKeyword(el.getAttributeValue("value"));
        } else if (el.getAttributeValue("name").equals("myName")) {
            profile.setName(el.getAttributeValue("value"));
        } else if (el.getAttributeValue("name").equals("allowReplaceKeyword")) {
            profile.setAllowReplaceRegexp(StringUtil.escapeToRegexp((String)el.getAttributeValue("value")));
        } else if (el.getAttributeValue("name").equals("allowReplaceRegexp")) {
            profile.setAllowReplaceRegexp(el.getAttributeValue("value"));
        }
        return false;
    }

    private ExternalOptionHelper() {
    }
}

