/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.internal.toolboxFeed;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.ide.ui.IdeUiService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.UriUtilKt;
import com.intellij.util.io.HttpRequests;
import com.jetbrains.gateway.internal.GatewayCoreRegistry;
import com.jetbrains.gateway.internal.toolboxFeed.GatewayToolboxFeedTokenProvider;
import com.jetbrains.gateway.internal.toolboxFeed.ToolboxFeed;
import com.jetbrains.gateway.internal.toolboxFeed.ToolboxFeedSignatureManager;
import com.jetbrains.gateway.ssh.AvailableIde;
import com.jetbrains.gateway.ssh.DeployTargetOS;
import com.jetbrains.gateway.ssh.Download;
import com.jetbrains.gateway.ssh.IntelliJPlatformProduct;
import com.jetbrains.gateway.ssh.ReleaseType;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.AwaitKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tukaani.xz.XZInputStream;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0016\u0018\u0000 #2\u00020\u0001:\u0001#B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0086@\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0094@\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0014J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\r\u001a\u0004\u0018\u00010\u000bH\u0014J\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u000bH\u0094@\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0012H\u0002J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0012H\u0002R\u0014\u0010\u001e\u001a\u00020\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010 \u00a8\u0006$"}, d2={"Lcom/jetbrains/gateway/internal/toolboxFeed/ToolboxFeed;", "", "<init>", "()V", "getAvailableIdesFromToolboxFeed", "", "Lcom/jetbrains/gateway/ssh/AvailableIde;", "deployTargetOs", "Lcom/jetbrains/gateway/ssh/DeployTargetOS;", "(Lcom/jetbrains/gateway/ssh/DeployTargetOS;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fetchTemporaryDownloadUrl", "", "url", "token", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isNightlyFeedEnabled", "", "downloadFeed", "", "uri", "Ljava/net/URI;", "downloadAndParseFeed", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "authenticationToken", "getAuthorizationToken", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "readTree", "rawData", "unpackXz", "data", "secureNightlyFeedUri", "getSecureNightlyFeedUri", "()Ljava/net/URI;", "secureNightlyArmFeedUri", "getSecureNightlyArmFeedUri", "Companion", "intellij.gateway.core"})
@SourceDebugExtension(value={"SMAP\nToolboxFeed.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolboxFeed.kt\ncom/jetbrains/gateway/internal/toolboxFeed/ToolboxFeed\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,183:1\n1#2:184\n*E\n"})
public class ToolboxFeed {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final URI secureNightlyFeedUri = new URI("https://secure.feed.toolbox.app/feeds/v1/nightly.feed.xz.signed");
    @NotNull
    private final URI secureNightlyArmFeedUri = new URI("https://secure.feed.toolbox.app/feeds/v1/nightly-arm.feed.xz.signed");
    @NotNull
    private static final Logger LOG;

    @Nullable
    public final Object getAvailableIdesFromToolboxFeed(@NotNull DeployTargetOS deployTargetOs, @NotNull Continuation<? super List<AvailableIde>> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends AvailableIde>>, Object>(this, deployTargetOs, null){
            Object L$1;
            Object L$2;
            Object L$3;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ToolboxFeed this$0;
            final /* synthetic */ DeployTargetOS $deployTargetOs;
            {
                this.this$0 = $receiver;
                this.$deployTargetOs = $deployTargetOs;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object var1_1) {
                var35_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$withContext = (CoroutineScope)this.L$0;
                        if (!this.this$0.isNightlyFeedEnabled()) {
                            ToolboxFeed.access$getLOG$cp().debug("Fetching nightly feeds from toolbox is disabled in registry");
                            return CollectionsKt.emptyList();
                        }
                        switch (getAvailableIdesFromToolboxFeed.WhenMappings.$EnumSwitchMapping$0[this.$deployTargetOs.getOsKind().ordinal()]) {
                            case 1: {
                                if (GatewayCoreRegistry.INSTANCE.isWindowsDeployEnabled()) {
                                    ToolboxFeed.access$getLOG$cp().info("Windows deployment enabled, but feed most likely only has nsis installers while we only support zip ones.");
                                }
                                v0 = new Pair((Object)"windows", (Object)"zip");
                                break;
                            }
                            case 2: {
                                v0 = new Pair((Object)"linux", (Object)"tar.gz");
                                break;
                            }
                            case 3: {
                                if (GatewayCoreRegistry.INSTANCE.isMacDeployEnabled()) {
                                    v0 = new Pair((Object)"mac", (Object)"dmg");
                                    break;
                                }
                                v0 = new Pair(null, null);
                                break;
                            }
                            case 4: {
                                v0 = new Pair(null, null);
                                break;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                        var3_4 = v0;
                        required_os = (String)var3_4.component1();
                        required_package_type = (String)var3_4.component2();
                        if (required_os == null) {
                            ToolboxFeed.access$getLOG$cp().info("Unsupported deploy target os '" + this.$deployTargetOs.getOsKind() + "', will not try toolbox nightly feed.");
                            return CollectionsKt.emptyList();
                        }
                        switch (getAvailableIdesFromToolboxFeed.WhenMappings.$EnumSwitchMapping$1[this.$deployTargetOs.getOsArch().ordinal()]) {
                            case 1: {
                                v1 = "x64";
                                break;
                            }
                            case 2: {
                                v1 = "arm64";
                                break;
                            }
                            default: {
                                ToolboxFeed.access$getLOG$cp().info("Unknown target arch: " + this.$deployTargetOs.getOsArch());
                                return CollectionsKt.emptyList();
                            }
                        }
                        required_cpu_arch = v1;
                        this.L$0 = $this$withContext;
                        this.L$1 = required_os;
                        this.L$2 = required_package_type;
                        this.L$3 = required_cpu_arch;
                        this.label = 1;
                        v2 = this.this$0.getAuthorizationToken((Continuation<? super String>)((Continuation)this));
                        if (v2 == var35_2) {
                            return var35_2;
                        }
                        ** GOTO lbl62
                    }
                    case 1: {
                        required_cpu_arch = (String)this.L$3;
                        required_package_type = (String)this.L$2;
                        required_os = (String)this.L$1;
                        $this$withContext = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl62:
                        // 2 sources

                        if ((authToken = (String)v2) == null) {
                            ToolboxFeed.access$getLOG$cp().info("Auth token for toolbox feed is not available, skipping toolbox nightly feed");
                            return CollectionsKt.emptyList();
                        }
                        isMacOsArm = this.$deployTargetOs.getOsKind() == DeployTargetOS.OSKind.MacOs && this.$deployTargetOs.getOsArch() == DeployTargetOS.OSArch.ARM_64;
                        feedUri = isMacOsArm != false ? this.this$0.getSecureNightlyArmFeedUri() : this.this$0.getSecureNightlyFeedUri();
                        feed = ToolboxFeed.access$downloadAndParseFeed(this.this$0, feedUri, authToken);
                        v3 = feed.get("feed_generation_time");
                        ToolboxFeed.access$getLOG$cp().info("Loaded Toolbox Feed from " + feedUri + " feed_generation_time=" + (v3 != null ? v3.asText() : null));
                        var13_12 /* !! */  = feed.get("entries");
                        v4 = var13_12 /* !! */  instanceof ArrayNode != false ? (ArrayNode)var13_12 /* !! */  : null;
                        if (v4 == null) {
                            v4 = JsonNodeFactory.instance.arrayNode();
                        }
                        entries = v4;
                        Intrinsics.checkNotNull((Object)entries);
                        var12_14 = (Iterable)entries;
                        var13_12 /* !! */  = this.this$0;
                        $i$f$mapNotNull = false;
                        var15_16 = $this$mapNotNull$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$mapNotNullTo = false;
                        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        $i$f$forEach = false;
                        var20_21 = $this$forEach$iv$iv$iv.iterator();
                        while (var20_21.hasNext()) {
                            element$iv$iv = element$iv$iv$iv = var20_21.next();
                            $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                            entry = (JsonNode)element$iv$iv;
                            $i$a$-mapNotNull-ToolboxFeed$getAvailableIdesFromToolboxFeed$2$1 = false;
                            v5 = entry.get("package");
                            v6 = v5 != null && (v5 = v5.get("os")) != null ? v5.asText() : (os = null);
                            if (!Intrinsics.areEqual((Object)os, (Object)required_os)) {
                                v7 = null;
                            } else {
                                v8 = entry.get("package");
                                v9 = v8 != null && (v8 = v8.get("type")) != null ? v8.asText() : (type = null);
                                if (!Intrinsics.areEqual((Object)type, (Object)required_package_type)) {
                                    v7 = null;
                                } else {
                                    v10 = entry.get("quality");
                                    v11 = v10 != null && (v10 = v10.get("name")) != null ? v10.asText() : (quality = null);
                                    if (!Intrinsics.areEqual((Object)quality, (Object)"Nightly") && !Intrinsics.areEqual((Object)quality, (Object)"Dev")) {
                                        v7 = null;
                                    } else {
                                        v12 /* !! */  = entry.get("package");
                                        if (v12 /* !! */  == null || (v12 /* !! */  = v12 /* !! */ .get("requirements")) == null || (v12 /* !! */  = v12 /* !! */ .get("cpu_arch")) == null || (v12 /* !! */  = v12 /* !! */ .get("$eq")) == null || (v12 /* !! */  = v12 /* !! */ .asText()) == null) {
                                            v7 = null;
                                        } else {
                                            cpu_req /* !! */  = v12 /* !! */ ;
                                            if (!Intrinsics.areEqual((Object)cpu_req /* !! */ , (Object)required_cpu_arch)) {
                                                v7 = null;
                                            } else {
                                                v13 /* !! */  = entry.get("package");
                                                if (v13 /* !! */  == null || (v13 /* !! */  = v13 /* !! */ .get("url")) == null || (v13 /* !! */  = v13 /* !! */ .asText()) == null) {
                                                    v7 = null;
                                                } else {
                                                    url /* !! */  = v13 /* !! */ ;
                                                    v14 /* !! */  = entry.get("intellij_platform");
                                                    v7 = v14 /* !! */  == null || (v14 /* !! */  = v14 /* !! */ .get("product_code")) == null || (v14 /* !! */  = v14 /* !! */ .asText()) == null ? null : (IntelliJPlatformProduct.Companion.fromProductCode((String)(productCode /* !! */  = v14 /* !! */ )) == null ? null : (!product.getShowInGateway() ? null : BuildersKt.async$default((CoroutineScope)$this$withContext, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super AvailableIde>, Object>(product, entry, (ToolboxFeed)var13_12 /* !! */ , (String)url /* !! */ , authToken, null){
                                                        Object L$0;
                                                        Object L$1;
                                                        int label;
                                                        final /* synthetic */ IntelliJPlatformProduct $product;
                                                        final /* synthetic */ JsonNode $entry;
                                                        final /* synthetic */ ToolboxFeed this$0;
                                                        final /* synthetic */ String $url;
                                                        final /* synthetic */ String $authToken;
                                                        {
                                                            this.$product = $product;
                                                            this.$entry = $entry;
                                                            this.this$0 = $receiver;
                                                            this.$url = $url;
                                                            this.$authToken = $authToken;
                                                            super(2, $completion);
                                                        }

                                                        /*
                                                         * Unable to fully structure code
                                                         * Could not resolve type clashes
                                                         */
                                                        public final Object invokeSuspend(Object var1_1) {
                                                            var16_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                            switch (this.label) {
                                                                case 0: {
                                                                    ResultKt.throwOnFailure((Object)var1_1);
                                                                    v0 /* !! */  = this.$entry.get("build");
                                                                    if (v0 /* !! */  == null || (v0 /* !! */  = v0 /* !! */ .asText()) == null) {
                                                                        throw new IllegalStateException(("Missing build in " + this.$entry).toString());
                                                                    }
                                                                    var3_3 = v0 /* !! */ ;
                                                                    var2_4 = this.$product;
                                                                    this.L$0 = var2_4;
                                                                    this.L$1 = var3_3;
                                                                    this.label = 1;
                                                                    v1 = this.this$0.fetchTemporaryDownloadUrl(this.$url, this.$authToken, (Continuation<? super String>)((Continuation)this));
                                                                    if (v1 == var16_2) {
                                                                        return var16_2;
                                                                    }
                                                                    ** GOTO lbl22
                                                                }
                                                                case 1: {
                                                                    var3_3 = (String)this.L$1;
                                                                    var2_4 = (IntelliJPlatformProduct)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v1 = $result;
lbl22:
                                                                    // 2 sources

                                                                    var4_5 = v1;
                                                                    var5_6 = null;
                                                                    var6_7 = 6;
                                                                    var7_8 = null;
                                                                    var8_9 = null;
                                                                    var9_10 = (String)var4_5;
                                                                    v2 /* !! */  = this.$entry.get("version");
                                                                    if (v2 /* !! */  == null || (v2 /* !! */  = v2 /* !! */ .asText()) == null) {
                                                                        throw new IllegalStateException(("Missing version in " + this.$entry).toString());
                                                                    }
                                                                    var10_11 = ReleaseType.NIGHTLY;
                                                                    var11_12 = "NIGHTLY";
                                                                    var12_13 /* !! */  = v2 /* !! */ ;
                                                                    var13_14 = new Download(var9_10, var8_9, var7_8, var6_7, var5_6);
                                                                    var14_15 = var3_3;
                                                                    var15_16 = var2_4;
                                                                    return new AvailableIde(var15_16, var14_15, var13_14, (String)var12_13 /* !! */ , var11_12, var10_11);
                                                                }
                                                            }
                                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                        }

                                                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                        }

                                                        public final Object invoke(CoroutineScope p1, Continuation<? super AvailableIde> p2) {
                                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                        }
                                                    }), (int)2, null)));
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            if (v7 == null) continue;
                            it$iv$iv = v7;
                            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        this.L$0 = null;
                        this.L$1 = null;
                        this.L$2 = null;
                        this.L$3 = null;
                        this.label = 2;
                        v15 = AwaitKt.awaitAll((Collection)((List)destination$iv$iv), (Continuation)((Continuation)this));
                        if (v15 == var35_2) {
                            return var35_2;
                        }
                        ** GOTO lbl138
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v15 = $result;
lbl138:
                        // 2 sources

                        return v15;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<AvailableIde>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Nullable
    protected Object fetchTemporaryDownloadUrl(@NotNull String url, @NotNull String token, @NotNull Continuation<? super String> $completion) {
        return ToolboxFeed.fetchTemporaryDownloadUrl$suspendImpl(this, url, token, $completion);
    }

    static /* synthetic */ Object fetchTemporaryDownloadUrl$suspendImpl(ToolboxFeed $this, String url, String token, Continuation<? super String> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(url, token, null){
            Object L$0;
            int label;
            final /* synthetic */ String $url;
            final /* synthetic */ String $token;
            {
                this.$url = $url;
                this.$token = $token;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        uri = new URI(this.$url);
                        var4_4 = UriUtilKt.withQuery((URI)uri, (String)"generateTemporaryUrl=true").toString();
                        Intrinsics.checkNotNullExpressionValue((Object)var4_4, (String)"toString(...)");
                        generateTemporaryUrlRequest = var4_4;
                        ToolboxFeed.access$getLOG$cp().info("Generating temporary url for " + generateTemporaryUrlRequest);
                        $i$f$serviceAsync = false;
                        v0 = ApplicationManager.getApplication();
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getApplication(...)");
                        $this$serviceAsync$iv$iv = (ComponentManager)v0;
                        $i$f$serviceAsync = false;
                        this.L$0 = generateTemporaryUrlRequest;
                        this.label = 1;
                        v1 = ServicesKt.serviceAsync((ComponentManager)$this$serviceAsync$iv$iv, IdeUiService.class, (Continuation)((Continuation)this));
                        if (v1 == var9_2) {
                            return var9_2;
                        }
                        ** GOTO lbl29
                    }
                    case 1: {
                        $i$f$serviceAsync = false;
                        $i$f$serviceAsync = false;
                        generateTemporaryUrlRequest = (String)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl29:
                        // 2 sources

                        v2 = ((IdeUiService)v1).openHttpConnection(generateTemporaryUrlRequest);
                        Intrinsics.checkNotNull((Object)v2, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
                        connection = (HttpURLConnection)v2;
                        connection.setRequestProperty("Authorization", "Bearer " + this.$token);
                        connection.setInstanceFollowRedirects(false);
                        if (connection.getResponseCode() != 307) {
                            throw new IllegalStateException(("Generating temporary url should return response code 307, but got " + connection.getResponseCode() + " for url " + generateTemporaryUrlRequest).toString());
                        }
                        v3 = connection.getHeaderField("Location");
                        if (v3 == null) {
                            throw new IllegalStateException(("Location header is null in response " + generateTemporaryUrlRequest).toString());
                        }
                        location = v3;
                        locationUri = new URI(location);
                        if (!Intrinsics.areEqual((Object)locationUri.getScheme(), (Object)"https")) {
                            throw new IllegalStateException(("Expected https scheme in location response for " + generateTemporaryUrlRequest + ", but got: " + locationUri).toString());
                        }
                        v4 = locationUri.getQuery();
                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getQuery(...)");
                        if (!StringsKt.contains$default((CharSequence)v4, (CharSequence)"tempToken", (boolean)false, (int)2, null)) {
                            throw new IllegalStateException(("Expected 'tempToken' in location response for " + generateTemporaryUrlRequest + ", but got: " + locationUri).toString());
                        }
                        return location;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    protected boolean isNightlyFeedEnabled() {
        return GatewayCoreRegistry.INSTANCE.isNightlyFeedEnabled();
    }

    @NotNull
    protected byte[] downloadFeed(@NotNull URI uri, @Nullable String token) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        byte[] byArray = HttpRequests.request((String)uri.toString()).tuner(arg_0 -> ToolboxFeed.downloadFeed$lambda$0(token, arg_0)).productNameAsUserAgent().readBytes(null);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readBytes(...)");
        return byArray;
    }

    private final ObjectNode downloadAndParseFeed(URI uri, String authenticationToken) {
        byte[] cmsData = this.downloadFeed(uri, authenticationToken);
        byte[] xzData = ToolboxFeedSignatureManager.INSTANCE.unpackAndVerify(cmsData);
        byte[] jsonFeedData = this.unpackXz(xzData);
        return this.readTree(jsonFeedData);
    }

    @Nullable
    protected Object getAuthorizationToken(@NotNull Continuation<? super String> $completion) {
        return ToolboxFeed.getAuthorizationToken$suspendImpl(this, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object getAuthorizationToken$suspendImpl(ToolboxFeed var0, Continuation<? super String> $completion) {
        if (!($completion instanceof getAuthorizationToken.1)) ** GOTO lbl-1000
        var6_2 = $completion;
        if ((var6_2.label & -2147483648) != 0) {
            var6_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ ToolboxFeed this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ToolboxFeed.getAuthorizationToken$suspendImpl(this.this$0, (Continuation<? super String>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var2_5 = GatewayToolboxFeedTokenProvider.Companion.getEP().lazySequence().iterator();
lbl13:
                // 2 sources

                while (var2_5.hasNext()) {
                    tokenProvider = (GatewayToolboxFeedTokenProvider)var2_5.next();
                    $continuation.L$0 = var2_5;
                    $continuation.L$1 = tokenProvider;
                    $continuation.label = 1;
                    v0 = tokenProvider.getToken((Continuation<? super String>)$continuation);
                    if (v0 == var7_4) {
                        return var7_4;
                    }
                    ** GOTO lbl28
                }
                break;
            }
            case 1: {
                tokenProvider = (GatewayToolboxFeedTokenProvider)$continuation.L$1;
                var2_5 = (Iterator)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                if ((token = (String)v0) != null) ** GOTO lbl31
                ToolboxFeed.LOG.info("Provider " + tokenProvider.getClass() + " returned null toolbox feed token (token is not available at this time)");
                ** GOTO lbl13
lbl31:
                // 1 sources

                ToolboxFeed.LOG.info("Provider " + tokenProvider.getClass() + " provided a token for toolbox feed");
                return token;
            }
        }
        ToolboxFeed.LOG.info("None of toolbox feed auth token providers returned a token");
        return null;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final ObjectNode readTree(byte[] rawData) {
        JsonNode jsonNode = new ObjectMapper().readTree(rawData);
        ObjectNode objectNode = jsonNode instanceof ObjectNode ? (ObjectNode)jsonNode : null;
        if (objectNode == null) {
            throw new IllegalStateException("Unexpected JSON data".toString());
        }
        return objectNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] unpackXz(byte[] data) {
        byte[] byArray;
        Closeable closeable = new ByteArrayInputStream(data);
        Throwable throwable = null;
        try {
            byte[] byArray2;
            ByteArrayInputStream input = (ByteArrayInputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = (Closeable)new XZInputStream((InputStream)input);
            Throwable throwable2 = null;
            try {
                XZInputStream it = (XZInputStream)closeable2;
                boolean bl2 = false;
                byArray2 = ByteStreamsKt.readBytes((InputStream)((InputStream)it));
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            byArray = byArray2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return byArray;
    }

    @NotNull
    protected final URI getSecureNightlyFeedUri() {
        return this.secureNightlyFeedUri;
    }

    @NotNull
    protected final URI getSecureNightlyArmFeedUri() {
        return this.secureNightlyArmFeedUri;
    }

    private static final void downloadFeed$lambda$0(String $token, URLConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        if ($token != null) {
            connection.setRequestProperty("Authorization", "Bearer " + $token);
        }
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ ObjectNode access$downloadAndParseFeed(ToolboxFeed $this, URI uri, String authenticationToken) {
        return $this.downloadAndParseFeed(uri, authenticationToken);
    }

    static {
        Logger logger = Logger.getInstance(ToolboxFeed.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/gateway/internal/toolboxFeed/ToolboxFeed$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.gateway.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

