/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.ssh;

import com.jetbrains.gateway.ssh.DeployTargetOS;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002\u001a \u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Gigabyte", "", "Megabyte", "Kilobyte", "ARCHIVE_MULTIPLIER", "", "RequiredFreeSpace", "getArchiveExtension", "", "stringEndingWithFileName", "windowsTruncateRegex", "Lkotlin/text/Regex;", "maxHashLengthForWindows", "combineHumanReadableHash", "os", "Lcom/jetbrains/gateway/ssh/DeployTargetOS;", "name", "digest", "", "intellij.gateway.core"})
@SourceDebugExtension(value={"SMAP\nRemoteHostBackendDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteHostBackendDownloader.kt\ncom/jetbrains/gateway/ssh/RemoteHostBackendDownloaderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,231:1\n1797#2,3:232\n*S KotlinDebug\n*F\n+ 1 RemoteHostBackendDownloader.kt\ncom/jetbrains/gateway/ssh/RemoteHostBackendDownloaderKt\n*L\n220#1:232,3\n*E\n"})
public final class RemoteHostBackendDownloaderKt {
    public static final long Gigabyte = 0x40000000L;
    public static final long Megabyte = 0x100000L;
    public static final long Kilobyte = 1024L;
    private static final int ARCHIVE_MULTIPLIER = 4;
    public static final long RequiredFreeSpace = 0x100000000L;
    @NotNull
    private static final Regex windowsTruncateRegex = new Regex("(\\w+)-(.*-)?(\\d+.\\d+(.\\d+)?)", RegexOption.IGNORE_CASE);
    private static final int maxHashLengthForWindows = 21;

    private static final String getArchiveExtension(String stringEndingWithFileName) {
        String string;
        if (StringsKt.endsWith$default((String)stringEndingWithFileName, (String)".tar.gz", (boolean)false, (int)2, null)) {
            string = ".tar.gz";
        } else if (StringsKt.endsWith$default((String)stringEndingWithFileName, (String)".zip", (boolean)false, (int)2, null)) {
            string = ".zip";
        } else if (StringsKt.endsWith$default((String)stringEndingWithFileName, (String)".dmg", (boolean)false, (int)2, null)) {
            string = ".dmg";
        } else {
            throw new IllegalStateException(("Unsupported archive extension: " + stringEndingWithFileName).toString());
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final String combineHumanReadableHash(DeployTargetOS os, String name, byte[] digest) {
        String hash = RemoteHostBackendDownloaderKt.combineHumanReadableHash$byteArrayToHex(digest);
        Object[] objectArray = new String[]{".tar.gz", ".zip", ".dmg"};
        List archiveExtensions = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$fold$iv = archiveExtensions;
        boolean $i$f$fold = false;
        String accumulator$iv = name;
        for (Object element$iv : $this$fold$iv) {
            void s;
            String string = (String)element$iv;
            String acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = StringsKt.replace$default((String)acc, (String)s, (String)"", (boolean)false, (int)4, null);
        }
        String humanReadableSuffix = accumulator$iv;
        if (os.getOsKind() == DeployTargetOS.OSKind.Windows) {
            String truncatedPath = RemoteHostBackendDownloaderKt.combineHumanReadableHash$truncateSuffix(humanReadableSuffix, 20);
            if (truncatedPath == null) {
                String string = hash.substring(0, 21);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return string;
            }
            int hashLength = 21 - truncatedPath.length() - 1;
            String string = hash.substring(0, hashLength);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string + "_" + truncatedPath;
        }
        String string = hash.substring(0, 13);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string + "_" + humanReadableSuffix;
    }

    private static final String combineHumanReadableHash$truncateSuffix(String suffix, int maxLength) {
        String version;
        MatchResult matchResult = Regex.find$default((Regex)windowsTruncateRegex, (CharSequence)suffix, (int)0, (int)2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult matchResult2 = matchResult;
        String productName = (String)matchResult2.getGroupValues().get(1);
        String result2 = productName + "_" + (version = (String)matchResult2.getGroupValues().get(3));
        if (result2.length() <= maxLength) {
            return result2;
        }
        if (version.length() <= maxLength) {
            return version;
        }
        return null;
    }

    private static final String combineHumanReadableHash$byteArrayToHex(byte[] a) {
        StringBuilder sb = new StringBuilder(a.length * 2);
        for (byte b : a) {
            String string = "%02x";
            Object[] objectArray = new Object[]{b};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            sb.append(string2);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static final /* synthetic */ String access$getArchiveExtension(String stringEndingWithFileName) {
        return RemoteHostBackendDownloaderKt.getArchiveExtension(stringEndingWithFileName);
    }

    public static final /* synthetic */ String access$combineHumanReadableHash(DeployTargetOS os, String name, byte[] digest) {
        return RemoteHostBackendDownloaderKt.combineHumanReadableHash(os, name, digest);
    }
}

