/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.DbDeleteProvider;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasObjectFun;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTableKey;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.view.CommentQueryGenerator;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.DropQueryGenerator;
import com.intellij.database.view.ui.DatabaseScriptDialog;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.FieldPanel;
import com.intellij.util.JavaCoroutines;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.util.Collections;
import java.util.Objects;
import javax.swing.JComponent;
import kotlin.coroutines.Continuation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DdlActions {
    private static boolean canDrop(@Nullable BasicElement e) {
        if (e == null) {
            return false;
        }
        BasicRoot root = e.getModel().getRoot();
        ScriptGenerator generator = (ScriptGenerator)ScriptGenerators.INSTANCE.forDbms(root.getDbms());
        return generator.capabilities(e).getDrop().get(root.getServerVersion());
    }

    public static boolean isDbViewToolbar(@Nullable AnActionEvent e) {
        return e != null && e.getPlace().equals(ActionPlaces.getActionGroupPopupPlace((String)"DatabaseViewToolbar"));
    }

    public static class CommentOnObjectAction
    extends DumbAwareAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                CommentOnObjectAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            JBIterable<DbElement> selection;
            DbElement single;
            if (e == null) {
                CommentOnObjectAction.$$$reportNull$$$0(1);
            }
            BasicNamedElement element = (single = (DbElement)(selection = DatabaseContextFun.getSelectedDbElements(e.getDataContext())).single()) == null ? null : (BasicNamedElement)ObjectUtils.tryCast((Object)single.getDelegate(), BasicNamedElement.class);
            BasicModel model = element == null ? null : element.getModel();
            boolean visible = model != null && CommentQueryGenerator.canComment(model, element) && DbImplUtilCore.canConnectTo(single);
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && ImportUtil.canModify(single));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            BasicModel model;
            JBIterable<DbElement> selection;
            DbElement single;
            if (e == null) {
                CommentOnObjectAction.$$$reportNull$$$0(2);
            }
            final BasicNamedElement element = (single = (DbElement)(selection = DatabaseContextFun.getSelectedDbElements(e.getDataContext())).single()) == null ? null : (BasicNamedElement)ObjectUtils.tryCast((Object)single.getDelegate(), BasicNamedElement.class);
            BasicModel basicModel = model = element == null ? null : element.getModel();
            if (model == null) {
                return;
            }
            BasicNamespace current = (BasicNamespace)ObjectUtils.tryCast((Object)DbImplUtilCore.getSearchPathObjectForSwitch(single.getDataSource(), (DasObject)element), BasicNamespace.class);
            final CommentQueryGenerator generator = new CommentQueryGenerator(single.getProject(), model, element);
            generator.setCurrentNamespace(current);
            new DatabaseScriptDialog(single.getProject(), single.getDataSource().getDelegateDataSource(), ObjectPaths.searchPathOf(current), DatabaseBundle.message("action.DatabaseView.Ddl.CommentOnObject.title", new Object[0])){
                private FieldPanel myComment;

                @Override
                protected ScriptingTask getTask() {
                    return generator.createTask(null);
                }

                @Override
                @Nullable
                protected Object applyAndGetTask(@NotNull @NotNull Continuation<? super @NotNull ScriptingTask> $completion) {
                    if ($completion == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return JavaCoroutines.suspendJava(c2 -> c2.resume((Object)this.getTask()), $completion);
                }

                @Override
                protected void settingsChanged(ScriptingOptions options) {
                    generator.setOptions(options);
                    this.regenerate();
                }

                @Override
                protected JComponent createCenterPanel() {
                    this.myComment = new FieldPanel(DatabaseBundle.message("action.DatabaseView.Ddl.CommentOnObject.comment", new Object[0]), null, null, () -> this.regenerate());
                    this.myComment.setText(element.getComment());
                    return new BorderLayoutPanel().addToTop((Component)this.myComment).addToCenter((Component)Objects.requireNonNull(super.createCenterPanel()));
                }

                private void regenerate() {
                    this.generateText(this.myComment.getText());
                }

                @Nullable
                public JComponent getPreferredFocusedComponent() {
                    return this.myComment.getTextField();
                }

                private void generateText(String comment) {
                    this.updateText(generator.generate(comment));
                }

                @Override
                protected void fillContext(@NotNull DatabaseRefactoringHandler handler2) {
                    if (handler2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    handler2.include(element);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "$completion";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "handler";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/database/actions/DdlActions$CommentOnObjectAction$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "applyAndGetTask";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "fillContext";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }.initAndShow();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/DdlActions$CommentOnObjectAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/DdlActions$CommentOnObjectAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class DropForeignKeyAction
    extends DumbAwareAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                DropForeignKeyAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            JBIterable<DbColumn> selection;
            DbColumn column2;
            JBIterable<DbElement> dbFks;
            BasicForeignKey fk;
            if (e == null) {
                DropForeignKeyAction.$$$reportNull$$$0(1);
            }
            boolean visible = DdlActions.canDrop(fk = (BasicForeignKey)DbDeleteProvider.getElements(dbFks = this.getForeignKeys(column2 = (DbColumn)(selection = DatabaseContextFun.getSelectedDbElements(e.getDataContext(), DbColumn.class)).single())).filter(BasicForeignKey.class).first()) && DbImplUtilCore.canConnectTo(column2);
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && ImportUtil.canModify(column2));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DbColumn column2;
            DbTable table;
            if (e == null) {
                DropForeignKeyAction.$$$reportNull$$$0(2);
            }
            DbTable dbTable = table = (column2 = (DbColumn)DatabaseContextFun.getSelectedDbElements(e.getDataContext(), DbColumn.class).first()) == null ? null : column2.getTable();
            if (table == null) {
                return;
            }
            DbDataSource dataSource = column2.getDataSource();
            BasicNamespace namespace = (BasicNamespace)ObjectUtils.tryCast((Object)DbImplUtilCore.unwrap(DbImplUtilCore.getSearchPathObjectForSwitch(column2)), BasicNamespace.class);
            BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)dataSource.getModel(), BasicModel.class);
            if (model == null) {
                return;
            }
            DropQueryGenerator generator = new DropQueryGenerator(dataSource.getProject(), model);
            JBIterable<DbElement> selection = this.getForeignKeys(column2);
            JBIterable<BasicElement> elements = DbDeleteProvider.getElements(selection);
            generator.setItems((Iterable<BasicElement>)elements);
            generator.setCurrentNamespace(namespace);
            DbDeleteProvider.showDialogAndRun(dataSource.getProject(), dataSource, ObjectPaths.searchPathOf(namespace), elements, generator);
        }

        @NotNull
        private JBIterable<DbElement> getForeignKeys(@Nullable DbColumn column2) {
            JBIterable jBIterable = column2 == null ? JBIterable.empty() : JBIterable.from(DasUtil.getForeignKeys(column2.getTable())).filter(key2 -> DasUtil.containsName(column2.getName(), key2.getColumnsRef())).filter(DbElement.class);
            if (jBIterable == null) {
                DropForeignKeyAction.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/DdlActions$DropForeignKeyAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/DdlActions$DropForeignKeyAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getForeignKeys";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class DropPrimaryKeyAction
    extends DumbAwareAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                DropPrimaryKeyAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            JBIterable<DbElement> selection;
            DbElement element;
            DbTable dbTable;
            if (e == null) {
                DropPrimaryKeyAction.$$$reportNull$$$0(1);
            }
            DbTableKey dbPk = (dbTable = (DbTable)PsiTreeUtil.getParentOfType((PsiElement)(element = (DbElement)(selection = DatabaseContextFun.getSelectedDbElements(e.getDataContext())).single()), DbTable.class, (boolean)false)) == null ? null : (DbTableKey)DasUtil.getPrimaryKey(dbTable);
            BasicKey pk = dbPk == null ? null : (BasicKey)ObjectUtils.tryCast((Object)dbPk.getDelegate(), BasicKey.class);
            boolean visible = DdlActions.canDrop(pk) && DbImplUtilCore.canConnectTo(dbTable);
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && ImportUtil.canModify(dbTable));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DbElement element;
            DbTable table;
            if (e == null) {
                DropPrimaryKeyAction.$$$reportNull$$$0(2);
            }
            if ((table = (DbTable)PsiTreeUtil.getParentOfType((PsiElement)(element = (DbElement)DatabaseContextFun.getSelectedDbElements(e.getDataContext()).first()), DbTable.class, (boolean)false)) == null) {
                return;
            }
            DbTableKey pk = (DbTableKey)DasUtil.getPrimaryKey(table);
            if (pk == null) {
                return;
            }
            DbDataSource dataSource = pk.getDataSource();
            BasicNamespace namespace = (BasicNamespace)ObjectUtils.tryCast((Object)DbImplUtilCore.unwrap(DbImplUtilCore.getSearchPathObjectForSwitch(pk)), BasicNamespace.class);
            BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)dataSource.getModel(), BasicModel.class);
            if (model == null) {
                return;
            }
            Project project = dataSource.getProject();
            DropQueryGenerator generator = new DropQueryGenerator(project, model);
            JBIterable selection = JBIterable.of((Object)pk);
            generator.setItems((Iterable<BasicElement>)DbDeleteProvider.getElements((JBIterable<DbElement>)selection));
            generator.setCurrentNamespace(namespace);
            BasicElement pkElement = DasObjectFun.getBasicElement(pk);
            if (pkElement != null) {
                DbDeleteProvider.showDialogAndRun(project, dataSource, ObjectPaths.searchPathOf(namespace), Collections.singleton(pkElement), generator);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/DdlActions$DropPrimaryKeyAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/DdlActions$DropPrimaryKeyAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

