/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase;

import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.domain.BooleanDomain;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.OperationSupport;
import com.intellij.database.data.types.domain.PgNumber2Domain;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.data.types.domain.TextLikeDomain;
import com.intellij.database.data.types.domain.UnknownDomain;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public abstract class PgBaseDomains
extends BaseDomainRegistry {
    public static final int MAX_FRACTION = 6;
    public static final double MAX_REAL = 1.0E37;
    public static final double MIN_REAL = -1.0E37;
    public static final double MIN_DOUBLE = -1.0E307;
    public static final double MAX_DOUBLE = 1.0E308;

    protected PgBaseDomains(int maxPrecision, int maxScale, int maxChar, int maxVarchar) {
        this.add(new PgNumber2Domain("numeric", ConversionPoint.BIG_DECIMAL, maxPrecision, maxScale, true));
        this.add(new PgNumber2Domain("decimal", ConversionPoint.BIG_DECIMAL, maxPrecision, maxScale, true));
        this.add(new IntegerDomain("integer", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9).withAliases("int4", "int"));
        this.add(new IntegerDomain("smallint", ConversionPoint.NUMBER, -32768.0, 32767.0).withAliases("int2"));
        this.add(new IntegerDomain("bigint", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18).withAliases("int8"));
        this.add(new FloatDomain("double precision", ConversionPoint.DOUBLE_PRECISION, -1.0E307, 1.0E308).withAliases("float8"));
        this.add(new FloatDomain("real", ConversionPoint.SINGLE_PRECISION, -1.0E37, 1.0E37).withAliases("float4"));
        this.add(new SimpleDomain("date", ConversionPoint.DATE));
        this.add(new TextDomain("text", ConversionPoint.TEXT, Integer.MAX_VALUE).withAliases("citext").withOperationSupport(OperationSupport.SUPPORTS_FTS));
        this.add(new TextDomain("char", ConversionPoint.CHAR, maxChar, 1L, true, false){

            @Override
            public boolean isSuitable(@NotNull ColumnDescriptor descriptor2) {
                if (descriptor2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (descriptor2 instanceof DataConsumer.Column) {
                    return StringUtil.equalsIgnoreCase((CharSequence)"bpchar", (CharSequence)descriptor2.getTypeName());
                }
                return super.isSuitable(descriptor2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/dialects/postgresbase/PgBaseDomains$1", "isSuitable"));
            }
        }.withAliases("character").withOperationSupport(OperationSupport.SUPPORTS_FTS));
        this.add(new TextDomain("\"char\"", ConversionPoint.CHAR, 1L){

            @Override
            public boolean isSuitable(@NotNull ColumnDescriptor descriptor2) {
                if (descriptor2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (descriptor2 instanceof DataConsumer.Column) {
                    return StringUtil.equalsIgnoreCase((CharSequence)"char", (CharSequence)descriptor2.getTypeName());
                }
                return super.isSuitable(descriptor2);
            }

            @Override
            @NotNull
            public Compatibility getCompatibility(@NotNull Domain domain) {
                if (domain == null) {
                    2.$$$reportNull$$$0(1);
                }
                Compatibility compatibility = StringUtil.equalsIgnoreCase((CharSequence)this.simpleName(), (CharSequence)domain.simpleName()) ? super.getCompatibility(domain) : Compatibility.incompatible();
                if (compatibility == null) {
                    2.$$$reportNull$$$0(2);
                }
                return compatibility;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "domain";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/dialects/postgresbase/PgBaseDomains$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/dialects/postgresbase/PgBaseDomains$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCompatibility";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isSuitable";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getCompatibility";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        });
        this.add(new TextDomain("bpchar", ConversionPoint.CHAR, maxChar, -1L, true, true){

            @Override
            public boolean isSuitable(@NotNull ColumnDescriptor descriptor2) {
                if (descriptor2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                return !(descriptor2 instanceof DataConsumer.Column) && super.isSuitable(descriptor2);
            }

            @Override
            @NotNull
            public Compatibility getCompatibility(@NotNull Domain domain) {
                if (domain == null) {
                    3.$$$reportNull$$$0(1);
                }
                Compatibility compatibility = StringUtil.equalsIgnoreCase((CharSequence)this.simpleName(), (CharSequence)domain.simpleName()) ? super.getCompatibility(domain) : Compatibility.incompatible();
                if (compatibility == null) {
                    3.$$$reportNull$$$0(2);
                }
                return compatibility;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "domain";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/dialects/postgresbase/PgBaseDomains$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/dialects/postgresbase/PgBaseDomains$3";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCompatibility";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isSuitable";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getCompatibility";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        }.withOperationSupport(OperationSupport.SUPPORTS_FTS));
        this.add(new TextDomain("varchar", ConversionPoint.VARCHAR, maxVarchar, -1L, true, true).withAliases("character varying").withOperationSupport(OperationSupport.SUPPORTS_FTS));
        this.add(new BooleanDomain("boolean", ConversionPoint.BOOLEAN).withAliases("bool").withOperationSupport(OperationSupport.SUPPORTS_EQUALS));
        this.add(new UnknownDomain("abstime"));
        this.add(new UnknownDomain("aclitem"));
        this.add(new UnknownDomain("cidr"));
        this.add(new UnknownDomain("circle"));
        this.add(new UnknownDomain("inet"));
        this.add(new UnknownDomain("macaddr"));
        this.add(new UnknownDomain("oid").withOperationSupport(OperationSupport.SUPPORTS_EQUALS));
        this.add(new UnknownDomain("path"));
        this.add(new UnknownDomain("polygon"));
        this.add(new UnknownDomain("refcursor"));
        this.add(new UnknownDomain("regclass"));
        this.add(new UnknownDomain("regoper"));
        this.add(new UnknownDomain("regoperator"));
        this.add(new UnknownDomain("regproc"));
        this.add(new UnknownDomain("regprocedure"));
        this.add(new UnknownDomain("regtype"));
        this.add(new UnknownDomain("reltime"));
        this.add(new UnknownDomain("smgr"));
        this.add(new UnknownDomain("tinterval"));
        this.add(new SimpleDomain("geometry", ConversionPoint.GEOMETRY_GEOWRAPPER));
    }

    protected static class MyTextLikeDomain
    extends TextLikeDomain {
        public MyTextLikeDomain(@NotNull String name2, @NotNull ConversionPoint descriptor2) {
            if (name2 == null) {
                MyTextLikeDomain.$$$reportNull$$$0(0);
            }
            if (descriptor2 == null) {
                MyTextLikeDomain.$$$reportNull$$$0(1);
            }
            super(name2, descriptor2);
        }

        @Override
        @NotNull
        public Compatibility getCompatibility(@NotNull Domain domain) {
            if (domain == null) {
                MyTextLikeDomain.$$$reportNull$$$0(2);
            }
            Compatibility compatibility = domain instanceof MyTextLikeDomain ? (StringUtil.equals((CharSequence)this.simpleName(), (CharSequence)domain.simpleName()) ? Compatibility.full(this.cardinality(), domain.getLogicType(), this.getLogicType()) : Compatibility.incompatible()) : super.getCompatibility(domain);
            if (compatibility == null) {
                MyTextLikeDomain.$$$reportNull$$$0(3);
            }
            return compatibility;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "domain";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/postgresbase/PgBaseDomains$MyTextLikeDomain";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/postgresbase/PgBaseDomains$MyTextLikeDomain";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCompatibility";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getCompatibility";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

