/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.ModelRelationManager;
import com.intellij.database.model.MultiRef;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.StringPattern;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NameBasedRelationProvider
implements ModelRelationManager.ModelRelationProvider {
    public static final String ID = "ByName";

    @Override
    public String getId() {
        return ID;
    }

    @Override
    @NotNull
    public JBIterable<DasForeignKey> getForeignKeys(@Nullable Project project, @NotNull DasTable table, @Nullable DasTable target2) {
        DasObject parent;
        JBIterable matches;
        if (table == null) {
            NameBasedRelationProvider.$$$reportNull$$$0(0);
        }
        if ((matches = JBIterable.from(NameBasedRelationSettings.getInstance().getCompiledRules())).isEmpty()) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                NameBasedRelationProvider.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }
        JBIterable queries = DasUtil.getColumns(table).flatten(col -> matches.filterMap(e -> FkSearchQuery.create(table, col, (Pattern)e.first, (String)e.second))).collect();
        if (queries.isEmpty()) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                NameBasedRelationProvider.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }
        JBIterable tables = target2 == null ? ((parent = table.getDasParent()) == null ? JBIterable.of((Object)table) : parent.getDasChildren(null).filter(DasTable.class)) : JBIterable.of((Object)target2);
        tables = tables.transform(DbSqlUtilCore.checkCancelled(100));
        JBIterable jBIterable = tables.flatten(tgt -> {
            JBIterable acceptable = queries.filter(q -> q.matches((DasTable)tgt)).collect();
            return acceptable.isEmpty() ? JBIterable.empty() : DasUtil.getColumns(tgt).flatten(col -> acceptable.filterMap((Function)new NotNullAccumulator<FkSearchQuery, FkSearchQuery.ExtraRelationWithColumns>(){

                @Override
                public FkSearchQuery.ExtraRelationWithColumns fun(FkSearchQuery.ExtraRelationWithColumns prev2, FkSearchQuery q) {
                    if (prev2 != null && prev2.getColumn() == q.myCol) {
                        return null;
                    }
                    return q.matches(col) ? q.createFk(tgt, col) : null;
                }
            }));
        });
        if (jBIterable == null) {
            NameBasedRelationProvider.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    @NotNull
    private static Matcher createMatcher(@NotNull Pattern pat, @NotNull String name2) {
        if (pat == null) {
            NameBasedRelationProvider.$$$reportNull$$$0(4);
        }
        if (name2 == null) {
            NameBasedRelationProvider.$$$reportNull$$$0(5);
        }
        Matcher matcher = pat.matcher(StringPattern.newBombedCharSequence((CharSequence)name2));
        if (matcher == null) {
            NameBasedRelationProvider.$$$reportNull$$$0(6);
        }
        return matcher;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/NameBasedRelationProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pat";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/NameBasedRelationProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getForeignKeys";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getForeignKeys";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createMatcher";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 6 -> new IllegalStateException(string);
        };
    }

    @State(name="NameBasedRelationSettings", category=SettingsCategory.CODE, storages={@Storage(value="editor.xml")})
    public static final class NameBasedRelationSettings
    implements PersistentStateComponent<NameBasedRelationSettings> {
        @Tag(value="FK_RULES")
        @XCollection(elementName="fk-rules")
        private Set<Rule> myFkRules = new TreeSet<Rule>(Collections.singleton(new Rule("(.*)_(?i)id", "$1\\\\.(?i)id")));
        @Transient
        private List<Pair<Pattern, String>> myCompiledRules = null;

        public static NameBasedRelationSettings getInstance() {
            return (NameBasedRelationSettings)ApplicationManager.getApplication().getService(NameBasedRelationSettings.class);
        }

        public NameBasedRelationSettings getState() {
            return this;
        }

        public void loadState(@NotNull NameBasedRelationSettings state) {
            if (state == null) {
                NameBasedRelationSettings.$$$reportNull$$$0(0);
            }
            XmlSerializerUtil.copyBean((Object)state, (Object)this);
        }

        public void setFkRules(Set<Rule> rules) {
            if (rules.equals(this.myFkRules)) {
                return;
            }
            this.myFkRules = rules;
            this.myCompiledRules = null;
        }

        public Set<Rule> getFkRules() {
            return this.myFkRules;
        }

        public List<Pair<Pattern, String>> getCompiledRules() {
            if (this.myCompiledRules == null) {
                ArrayList<Pair<Pattern, String>> res2 = new ArrayList<Pair<Pattern, String>>(this.myFkRules.size());
                for (Rule rule : this.myFkRules) {
                    try {
                        ContainerUtil.addIfNotNull(res2, NameBasedRelationSettings.compile(rule));
                    }
                    catch (PatternSyntaxException patternSyntaxException) {}
                }
                this.myCompiledRules = res2;
            }
            return this.myCompiledRules;
        }

        @Nullable
        public static Pair<Pattern, String> compile(Rule rule) {
            if (StringUtil.isEmpty((String)rule.match) || StringUtil.isEmpty((String)rule.replace)) {
                return null;
            }
            Pattern pattern = Pattern.compile(rule.match);
            return Pair.create((Object)pattern, (Object)rule.replace);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/model/NameBasedRelationProvider$NameBasedRelationSettings", "loadState"));
        }
    }

    public static final class FkSearchQuery {
        private final DasTable myTable;
        private final DasColumn myCol;
        private final Pattern myTableLookup;
        private final Pattern myColLookup;

        private FkSearchQuery(DasTable table, DasColumn col, Pattern tableLookup, Pattern colLookup) {
            this.myTable = table;
            this.myCol = col;
            this.myTableLookup = tableLookup;
            this.myColLookup = colLookup;
        }

        private boolean matches(@NotNull DasTable refTable) {
            String tab;
            if (refTable == null) {
                FkSearchQuery.$$$reportNull$$$0(0);
            }
            return FkSearchQuery.matchesTable(this.myTableLookup, tab = refTable.getName());
        }

        private boolean matches(@NotNull DasColumn refCol) {
            String col;
            if (refCol == null) {
                FkSearchQuery.$$$reportNull$$$0(1);
            }
            if (!FkSearchQuery.matchesColumn(this.myColLookup, col = refCol.getName())) {
                return false;
            }
            DasTable refTable = refCol.getTable();
            String tab = DasUtil.getName(refTable);
            return DasUtil.getForeignKeys(this.myTable).filter(f -> Objects.equals(f.getRefTableName(), tab) && JBIterable.from(f.getColumnsRef().resolveObjects()).single() == this.myCol && f.getRefTable() == refTable && JBIterable.from(f.getRefColumns().resolveObjects()).single() == refCol).isEmpty();
        }

        public static boolean matchesTable(Pattern lookup, String tab) {
            if (NameBasedRelationProvider.createMatcher(lookup, tab).matches()) {
                return true;
            }
            String single = StringUtil.unpluralize((String)tab);
            return single != null && !single.equals(tab) && NameBasedRelationProvider.createMatcher(lookup, single).matches();
        }

        public static boolean matchesColumn(Pattern lookup, String col) {
            return NameBasedRelationProvider.createMatcher(lookup, col).matches();
        }

        @Nullable
        private static FkSearchQuery create(DasTable table, DasColumn col, Pattern pat, String repl) {
            String name2 = col.getName();
            try {
                Pair<String, String> lookup = FkSearchQuery.buildLookup(pat, repl, name2);
                return lookup == null ? null : new FkSearchQuery(table, col, Pattern.compile((String)lookup.first), Pattern.compile((String)lookup.second));
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public static Pair<String, String> buildLookup(Pattern pat, String repl, String name2) {
            Matcher matcher = NameBasedRelationProvider.createMatcher(pat, name2);
            if (!matcher.matches()) {
                return null;
            }
            StringBuilder buf = new StringBuilder();
            matcher.appendReplacement(buf, repl);
            int i2 = buf.indexOf("\\.");
            if (i2 == -1) {
                throw new IllegalArgumentException("Lookup should contain \\.");
            }
            return Pair.create((Object)buf.substring(0, i2), (Object)buf.substring(i2 + 2));
        }

        @NotNull
        private ExtraRelationWithColumns createFk(@NotNull DasTable refTable, @NotNull DasColumn refColumn) {
            if (refTable == null) {
                FkSearchQuery.$$$reportNull$$$0(2);
            }
            if (refColumn == null) {
                FkSearchQuery.$$$reportNull$$$0(3);
            }
            return new ExtraRelationWithColumns(refTable, refColumn);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refTable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refCol";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refColumn";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/model/NameBasedRelationProvider$FkSearchQuery";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "matches";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createFk";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class ExtraRelationWithColumns
        extends ModelRelationManager.ExtraRelation {
            @NotNull
            private final DasColumn myRefColumn;

            private ExtraRelationWithColumns(@NotNull DasTable refTable, DasColumn refColumn) {
                if (refTable == null) {
                    ExtraRelationWithColumns.$$$reportNull$$$0(0);
                }
                if (refColumn == null) {
                    ExtraRelationWithColumns.$$$reportNull$$$0(1);
                }
                super(FkSearchQuery.this.myTable, refTable);
                this.myRefColumn = refColumn;
            }

            @Override
            public String getProviderId() {
                return NameBasedRelationProvider.ID;
            }

            @Override
            @NotNull
            public MultiRef<? extends DasTypedObject> getRefColumns() {
                MultiRef<DasColumn> multiRef = DasUtil.asRef(Collections.singleton(this.myRefColumn));
                if (multiRef == null) {
                    ExtraRelationWithColumns.$$$reportNull$$$0(2);
                }
                return multiRef;
            }

            @Override
            @NotNull
            public MultiRef<? extends DasTypedObject> getColumnsRef() {
                MultiRef<DasColumn> multiRef = DasUtil.asRef(Collections.singleton(this.getColumn()));
                if (multiRef == null) {
                    ExtraRelationWithColumns.$$$reportNull$$$0(3);
                }
                return multiRef;
            }

            private DasColumn getColumn() {
                return FkSearchQuery.this.myCol;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "refTable";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "refColumn";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/model/NameBasedRelationProvider$FkSearchQuery$ExtraRelationWithColumns";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/model/NameBasedRelationProvider$FkSearchQuery$ExtraRelationWithColumns";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRefColumns";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getColumnsRef";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3 -> new IllegalStateException(string);
                };
            }
        }
    }

    public static class Rule
    implements Comparable<Rule> {
        @Attribute(value="MATCH")
        @NotNull
        public String match;
        @Attribute(value="REPLACE")
        @NotNull
        public String replace;

        public Rule() {
            this("", "");
        }

        public Rule(@NotNull String match, @NotNull String replace) {
            if (match == null) {
                Rule.$$$reportNull$$$0(0);
            }
            if (replace == null) {
                Rule.$$$reportNull$$$0(1);
            }
            this.match = match;
            this.replace = replace;
        }

        @Override
        public int compareTo(@NotNull Rule o) {
            int res2;
            if (o == null) {
                Rule.$$$reportNull$$$0(2);
            }
            if ((res2 = Comparing.compare((Comparable)((Object)this.match), (Comparable)((Object)o.match))) != 0) {
                return res2;
            }
            return Comparing.compare((Comparable)((Object)this.replace), (Comparable)((Object)o.replace));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "match";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replace";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/model/NameBasedRelationProvider$Rule";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class NotNullAccumulator<S, T>
    extends JBIterable.SFun<S, T> {
        private T prev;

        private NotNullAccumulator() {
        }

        public T fun(S s) {
            T res2 = this.fun(this.prev, s);
            if (res2 != null) {
                this.prev = res2;
            }
            return res2;
        }

        public abstract T fun(T var1, S var2);
    }
}

