/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.MultiElementIdentity;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.DbEditorModelListener;
import com.intellij.database.schemaEditor.model.DbModelResolveHelper;
import com.intellij.database.schemaEditor.model.state.DbModelState;
import com.intellij.database.schemaEditor.owner.SingleElementOwner;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbModelResetHelper
extends DbModelResolveHelper
implements Disposable {
    private static final Logger LOG = Logger.getInstance(DbModelResetHelper.class);
    private final Set<DbEditorModel<?, ?>> myNewObjects;
    private final Set<DbEditorModel<?, ?>> myModifiedObjects;

    private DbModelResetHelper(@NotNull DbEditorModelController controller, @NotNull ElementOwner owner) {
        if (controller == null) {
            DbModelResetHelper.$$$reportNull$$$0(0);
        }
        if (owner == null) {
            DbModelResetHelper.$$$reportNull$$$0(1);
        }
        super(controller, owner);
        this.myNewObjects = Collections.synchronizedSet(new LinkedHashSet());
        this.myModifiedObjects = Collections.synchronizedSet(new LinkedHashSet());
        this.myController.getEventDispatcher().addListener((EventListener)new DbEditorModelListener(){

            @Override
            public void created(@NotNull DbEditorModel<?, ?> model) {
                if (model == null) {
                    1.$$$reportNull$$$0(0);
                }
                DbModelResetHelper.this.myNewObjects.add(model);
            }

            @Override
            public void modified(@NotNull DbEditorModel<?, ?> model) {
                if (model == null) {
                    1.$$$reportNull$$$0(1);
                }
                DbModelResetHelper.this.myModifiedObjects.add(model);
            }

            @Override
            public void removed(@NotNull DbEditorModel<?, ?> model) {
                if (model == null) {
                    1.$$$reportNull$$$0(2);
                }
                DbModelResetHelper.this.myNewObjects.remove(model);
                DbModelResetHelper.this.myModifiedObjects.remove(model);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "model";
                objectArray2[1] = "com/intellij/database/schemaEditor/model/DbModelResetHelper$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "created";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "modified";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "removed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
    }

    public void dispose() {
    }

    public static void resetAll(@NotNull DbEditorModelController controller, @NotNull ElementOwner owner) {
        if (controller == null) {
            DbModelResetHelper.$$$reportNull$$$0(2);
        }
        if (owner == null) {
            DbModelResetHelper.$$$reportNull$$$0(3);
        }
        DbModelResetHelper.reset(controller, owner, new ArrayList(controller.getAllModels()));
    }

    public static void reset(@NotNull DbEditorModelController controller, @NotNull ElementOwner owner, @NotNull Collection<DbEditorModel<?, ?>> models2) {
        if (controller == null) {
            DbModelResetHelper.$$$reportNull$$$0(4);
        }
        if (owner == null) {
            DbModelResetHelper.$$$reportNull$$$0(5);
        }
        if (models2 == null) {
            DbModelResetHelper.$$$reportNull$$$0(6);
        }
        DbModelResetHelper.reset(controller, models2, owner);
    }

    public static <T extends BasicElement> void resetOne(@NotNull DbEditorModelController controller, @Nullable T element, @NotNull ElementIdentity<T> forcedId) {
        if (controller == null) {
            DbModelResetHelper.$$$reportNull$$$0(7);
        }
        if (forcedId == null) {
            DbModelResetHelper.$$$reportNull$$$0(8);
        }
        DbModelResetHelper.reset(controller, ContainerUtil.filter(controller.getAllModels(), m -> m.getIdentity() == forcedId), new SingleElementOwner(controller.getMatcher(), forcedId, element));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset(@NotNull DbEditorModelController controller, @NotNull Collection<DbEditorModel<?, ?>> models2, @NotNull ElementOwner resolver) {
        if (controller == null) {
            DbModelResetHelper.$$$reportNull$$$0(9);
        }
        if (models2 == null) {
            DbModelResetHelper.$$$reportNull$$$0(10);
        }
        if (resolver == null) {
            DbModelResetHelper.$$$reportNull$$$0(11);
        }
        DbModelResetHelper helper = new DbModelResetHelper(controller, resolver);
        try {
            helper.resetTrackingNew(models2);
        }
        finally {
            Disposer.dispose((Disposable)helper);
        }
    }

    public void resetTrackingNew(@NotNull Collection<DbEditorModel<?, ?>> models2) {
        if (models2 == null) {
            DbModelResetHelper.$$$reportNull$$$0(12);
        }
        this.resetModels(models2);
        while (this.resetNewObjects()) {
        }
    }

    private boolean resetNewObjects() {
        ArrayList modified = new ArrayList(this.myNewObjects);
        modified.addAll(this.myModifiedObjects);
        modified.forEach(this.myNewObjects::remove);
        modified.forEach(this.myModifiedObjects::remove);
        this.resetModels(modified);
        return !modified.isEmpty();
    }

    private void resetModels(@NotNull Collection<DbEditorModel<?, ?>> models2) {
        DbEditorModel anyUnregistered;
        if (models2 == null) {
            DbModelResetHelper.$$$reportNull$$$0(13);
        }
        if ((anyUnregistered = (DbEditorModel)JBIterable.from(models2).find(e -> !this.myController.isModelRegistered((DbEditorModel<?, ?>)e))) != null) {
            throw new AssertionError((Object)("Told to reset unregistered model: " + String.valueOf(anyUnregistered)));
        }
        DbModelResetHelper.processByTarget(models2, (a, b) -> -DbModelResetHelper.applyOrder(a, b), new DbModelResolveHelper.ByTargetProcessor(){

            @Override
            public <T extends BasicElement> void process(@NotNull ElementIdentity<T> identity, @NotNull Set<DbEditorModel<T, ?>> models2) {
                if (identity == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (models2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                DbModelResetHelper.this.resetTarget(identity, models2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "identity";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "models";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/schemaEditor/model/DbModelResetHelper$2";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.resolveModels();
    }

    private <T extends BasicElement> void resetMulti(MultiElementIdentity<T> targetId, Iterable<DbEditorModel<T, ?>> models2) {
        for (DbEditorModel<T, ?> model : models2) {
            this.multiResetModel(model);
        }
    }

    private <T extends BasicElement, S extends DbModelState> void multiResetModel(DbEditorModel<T, S> model) {
        try {
            if (model.getMultiApplier() != null) {
                model.getMultiApplier().reset(model, this.myOwner);
            } else {
                model.getState().setEnabled(false);
            }
        }
        catch (Throwable th) {
            LOG.error(th);
        }
    }

    private <T extends BasicElement> void resetTarget(@NotNull ElementIdentity<T> targetId, @NotNull Collection<DbEditorModel<T, ?>> models2) {
        if (targetId == null) {
            DbModelResetHelper.$$$reportNull$$$0(14);
        }
        if (models2 == null) {
            DbModelResetHelper.$$$reportNull$$$0(15);
        }
        ArrayList sorted = new ArrayList(models2);
        DbModelResetHelper.sortByDeps(sorted, false);
        if (targetId instanceof MultiElementIdentity) {
            this.resetMulti((MultiElementIdentity)targetId, sorted);
            return;
        }
        this.resetTargetImpl(targetId, sorted);
    }

    private <T extends BasicElement> void resetTargetImpl(@NotNull ElementIdentity<T> targetId, @NotNull List<DbEditorModel<T, ?>> sorted) {
        if (targetId == null) {
            DbModelResetHelper.$$$reportNull$$$0(16);
        }
        if (sorted == null) {
            DbModelResetHelper.$$$reportNull$$$0(17);
        }
        for (DbEditorModel<T, ?> model : sorted) {
            this.resetModel(model);
        }
    }

    private <T extends BasicElement, S extends DbModelState> void resetModel(DbEditorModel<T, S> model) {
        if (!this.myController.isModelRegistered(model)) {
            return;
        }
        try {
            model.getApplier().reset(model, this.myOwner);
        }
        catch (Throwable th) {
            LOG.error(th);
        }
        this.myModifiedObjects.remove(model);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forcedId";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetId";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sorted";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/schemaEditor/model/DbModelResetHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "resetAll";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "reset";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "resetOne";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "resetTrackingNew";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "resetModels";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "resetTarget";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "resetTargetImpl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

