/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.actions.row;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.editor.tables.actions.row.RowBasedTableAction;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElementFactory;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableCell;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableRow;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableSeparatorRow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u00002\u00020\u0001:\u0002\u0018\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\rH\u0002J\"\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0010H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/row/InsertRowAction;", "Lorg/intellij/plugins/markdown/editor/tables/actions/row/RowBasedTableAction;", "insertAbove", "", "<init>", "(Z)V", "performAction", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "table", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;", "rowElement", "Lcom/intellij/psi/PsiElement;", "obtainCellWidths", "", "", "element", "findRowOrSeparator", "file", "Lcom/intellij/psi/PsiFile;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "InsertAbove", "InsertBelow", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nInsertRowAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsertRowAction.kt\norg/intellij/plugins/markdown/editor/tables/actions/row/InsertRowAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 actions.kt\ncom/intellij/openapi/command/ActionsKt\n*L\n1#1,52:1\n1557#2:53\n1628#2,3:54\n1557#2:57\n1628#2,3:58\n7#3,6:61\n*S KotlinDebug\n*F\n+ 1 InsertRowAction.kt\norg/intellij/plugins/markdown/editor/tables/actions/row/InsertRowAction\n*L\n33#1:53\n33#1:54,3\n34#1:57\n34#1:58,3\n22#1:61,6\n*E\n"})
public abstract class InsertRowAction
extends RowBasedTableAction {
    private final boolean insertAbove;

    public InsertRowAction(boolean insertAbove) {
        super(true);
        this.insertAbove = insertAbove;
    }

    @Override
    protected void performAction(@NotNull Editor editor2, @NotNull MarkdownTable table, @NotNull PsiElement rowElement) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)rowElement, (String)"rowElement");
        ActionsKt.runWriteAction(() -> InsertRowAction.performAction$lambda$1(this, rowElement, table));
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<Integer> obtainCellWidths(PsiElement element2) {
        Collection collection;
        PsiElement psiElement = element2;
        if (psiElement instanceof MarkdownTableRow) {
            void $this$mapTo$iv$iv;
            List<MarkdownTableCell> list2 = ((MarkdownTableRow)element2).getCells();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getCells(...)");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                MarkdownTableCell markdownTableCell = (MarkdownTableCell)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getTextLength());
            }
            collection = (List)destination$iv$iv;
        } else if (psiElement instanceof MarkdownTableSeparatorRow) {
            Iterable $this$map$iv = ((MarkdownTableSeparatorRow)element2).getCellsRanges();
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                TextRange it = (TextRange)item$iv$iv;
                Collection collection3 = destination$iv$iv;
                boolean bl = false;
                collection3.add(it.getLength());
            }
            collection = (List)destination$iv$iv;
        } else {
            throw new IllegalStateException("element should be either MarkdownTableRow or MarkdownTableSeparatorRow".toString());
        }
        return collection;
    }

    @Override
    @Nullable
    protected PsiElement findRowOrSeparator(@NotNull PsiFile file, @NotNull Document document, int offset) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        PsiElement psiElement = super.findRowOrSeparator(file, document, offset);
        if (psiElement == null) {
            return null;
        }
        PsiElement element2 = psiElement;
        MarkdownTableRow markdownTableRow = element2 instanceof MarkdownTableRow ? (MarkdownTableRow)element2 : null;
        return (markdownTableRow != null ? TableUtils.INSTANCE.isHeaderRow(markdownTableRow) : false) ? null : (this.insertAbove && element2 instanceof MarkdownTableSeparatorRow ? null : element2);
    }

    private static final Unit performAction$lambda$1(InsertRowAction this$0, PsiElement $rowElement, MarkdownTable $table) {
        Collection<Integer> widths = this$0.obtainCellWidths($rowElement);
        MarkdownTableRow markdownTableRow = MarkdownPsiElementFactory.createTableEmptyRow($table.getProject(), widths);
        Intrinsics.checkNotNullExpressionValue((Object)markdownTableRow, (String)"createTableEmptyRow(...)");
        MarkdownTableRow newRow = markdownTableRow;
        if (!Intrinsics.areEqual((Object)$rowElement.getParent(), (Object)$table)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Project project$iv = $rowElement.getProject();
        String name$iv = null;
        Object groupId$iv = null;
        boolean $i$f$executeCommand = false;
        CommandProcessor.getInstance().executeCommand(project$iv, new Runnable(this$0, $table, newRow, $rowElement){
            final /* synthetic */ InsertRowAction this$0;
            final /* synthetic */ MarkdownTable $table$inlined;
            final /* synthetic */ MarkdownTableRow $newRow$inlined;
            final /* synthetic */ PsiElement $rowElement$inlined;
            {
                this.this$0 = insertRowAction;
                this.$table$inlined = markdownTable;
                this.$newRow$inlined = markdownTableRow;
                this.$rowElement$inlined = psiElement;
            }

            public final void run() {
                boolean bl = false;
                PsiElement psiElement = InsertRowAction.access$getInsertAbove$p(this.this$0) ? this.$table$inlined.addRangeBefore((PsiElement)this.$newRow$inlined, this.$newRow$inlined.getNextSibling(), this.$rowElement$inlined) : this.$table$inlined.addRangeAfter(this.$newRow$inlined.getPrevSibling(), (PsiElement)this.$newRow$inlined, this.$rowElement$inlined);
            }
        }, name$iv, groupId$iv);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ boolean access$getInsertAbove$p(InsertRowAction $this) {
        return $this.insertAbove;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/row/InsertRowAction$InsertAbove;", "Lorg/intellij/plugins/markdown/editor/tables/actions/row/InsertRowAction;", "<init>", "()V", "intellij.markdown"})
    public static final class InsertAbove
    extends InsertRowAction {
        public InsertAbove() {
            super(true);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/row/InsertRowAction$InsertBelow;", "Lorg/intellij/plugins/markdown/editor/tables/actions/row/InsertRowAction;", "<init>", "()V", "intellij.markdown"})
    public static final class InsertBelow
    extends InsertRowAction {
        public InsertBelow() {
            super(false);
        }
    }
}

