/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.tables;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.scientific.tables.DSHistoryForTableExpression;
import com.intellij.scientific.tables.DSTableBundle;
import com.intellij.scientific.tables.DSTableCommand;
import com.intellij.scientific.tables.DSTableDataException;
import com.intellij.scientific.tables.DSTableDataRetrieverFromDataSourceImpl;
import com.intellij.scientific.tables.DSTableRawData;
import com.intellij.scientific.tables.DataId;
import com.intellij.scientific.tables.NestedTableDataRetrieverFromDataSource;
import com.intellij.scientific.tables.api.DSDataFrameInfo;
import com.intellij.scientific.tables.api.DSPanelInfo;
import com.intellij.scientific.tables.api.DSSessionListener;
import com.intellij.scientific.tables.api.DSTableCommandExecutor;
import com.intellij.scientific.tables.api.DSTableDataProvider;
import com.intellij.scientific.tables.api.DSTableDataRetrieverFromDataSource;
import com.intellij.scientific.tables.api.DSTableDataType;
import com.intellij.scientific.tables.api.DSTableOutputData;
import com.intellij.scientific.tables.api.DSTableText;
import com.intellij.scientific.tables.api.NestedTableDataProvider;
import com.intellij.scientific.tables.api.TableDataProviderFactory;
import com.intellij.scientific.tables.editor.DSTableFileEditorKt;
import com.intellij.scientific.tables.panel.DSTableContentManager;
import com.intellij.util.concurrency.EdtScheduler;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 A2\u00020\u0001:\u0001AB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J<\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aJD\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J0\u0010\u001f\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\\\u0010!\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u001e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010&\u001a\u00020'2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J&\u0010(\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u0016J&\u0010)\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020,J0\u0010-\u001a\u00020%2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\u00132\u0006\u0010/\u001a\u00020\u001a2\u0006\u00100\u001a\u00020\u001aH\u0002J\u0018\u00101\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u00102\u001a\u00020\u001aH\u0002J\u0012\u00103\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001c\u001a\u00020\nH\u0002J\u0010\u00104\u001a\u0004\u0018\u0001052\u0006\u0010\u001c\u001a\u00020\nJ\u0016\u00106\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0014\u001a\u000205J\u0012\u00107\u001a\u0004\u0018\u00010%2\u0006\u0010\u001c\u001a\u00020\nH\u0002J\u0018\u00108\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u00109\u001a\u00020%H\u0002J\u0016\u0010:\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010;\u001a\u00020\u001aJ(\u0010<\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010.\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010=\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001c\u001a\u00020\nJ\u000e\u0010>\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\nJ\u0015\u0010?\u001a\t\u0018\u00010\u001a\u00a2\u0006\u0002\b@2\u0006\u0010\u001c\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00100\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/intellij/scientific/tables/DSTableDataManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "exprCommands", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/scientific/tables/DataId;", "Lcom/intellij/scientific/tables/DSTableCommand;", "staticOutputData", "", "Lcom/intellij/scientific/tables/api/DSTableOutputData;", "dynamicTablesHistory", "Lcom/intellij/scientific/tables/DSHistoryForTableExpression;", "addNewTableData", "tableCommandExecutor", "Lcom/intellij/scientific/tables/api/DSTableCommandExecutor;", "data", "panelInfo", "Lcom/intellij/scientific/tables/api/DSPanelInfo;", "isDynamicTable", "", "format", "", "showDynamicTable", "dataId", "provider", "Lcom/intellij/scientific/tables/api/DSTableDataProvider;", "showStaticTable", "", "createTableDataRetrieverFromDataSourceAndUpdateOrCreateTable", "tableVariableExpression", "tableDataProvider", "dataFrameInfo", "Lcom/intellij/scientific/tables/api/DSDataFrameInfo;", "dataType", "Lcom/intellij/scientific/tables/api/DSTableDataType;", "fallbackToStaticTable", "fallbackToPreviousValidTable", "logDynamicTableToHistory", "tableDataRetriever", "Lcom/intellij/scientific/tables/api/DSTableDataRetrieverFromDataSource;", "getDataFrameInfo", "commandExecutor", "expression", "defaultTableText", "addToHistoryWithEmptyData", "exprText", "getCommandFromHistory", "tryToLoadDataFromHistory", "Lcom/intellij/scientific/tables/DSTableRawData;", "loadDataToHistory", "tryToLoadFrameInfoFromHistory", "loadFrameInfoToHistory", "info", "addToHistory", "commandText", "addFallbackSessionListener", "getStaticTableData", "removeData", "getDimensionText", "Lcom/intellij/openapi/util/NlsSafe;", "Companion", "intellij.scientific.tables"})
@SourceDebugExtension(value={"SMAP\nDSTableDataManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DSTableDataManager.kt\ncom/intellij/scientific/tables/DSTableDataManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,329:1\n25#2:330\n*S KotlinDebug\n*F\n+ 1 DSTableDataManager.kt\ncom/intellij/scientific/tables/DSTableDataManager\n*L\n111#1:330\n*E\n"})
public final class DSTableDataManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private ConcurrentHashMap<DataId, DSTableCommand> exprCommands;
    @NotNull
    private final Map<DataId, DSTableOutputData> staticOutputData;
    @NotNull
    private final ConcurrentHashMap<DataId, DSHistoryForTableExpression> dynamicTablesHistory;
    @NotNull
    private static final Logger LOG;

    public DSTableDataManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.exprCommands = new ConcurrentHashMap();
        this.staticOutputData = new LinkedHashMap();
        this.dynamicTablesHistory = new ConcurrentHashMap();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final DataId addNewTableData(@NotNull Project project, @Nullable DSTableCommandExecutor tableCommandExecutor, @NotNull DSTableOutputData data, @NotNull DSPanelInfo panelInfo, boolean isDynamicTable, @Nullable String format) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)panelInfo, (String)"panelInfo");
        DataId dataId = new DataId(0, 1, null);
        DSTableDataProvider provider = TableDataProviderFactory.Companion.getTableDataProvider(project, data.getDataType(), data.getTableText());
        this.staticOutputData.put(dataId, data);
        if (isDynamicTable && this.showDynamicTable(project, tableCommandExecutor, data, panelInfo, dataId, provider, format)) {
            return dataId;
        }
        try {
            this.showStaticTable(project, data, panelInfo, dataId, provider);
        }
        catch (Exception exc) {
            DSTableDataManager.Companion.showErrorMessage(project, data.getTableText().getPlainText());
            LOG.error((Throwable)exc);
        }
        catch (Error err) {
            DSTableDataManager.Companion.showErrorMessage(project, data.getTableText().getPlainText());
            throw err;
        }
        return dataId;
    }

    public static /* synthetic */ DataId addNewTableData$default(DSTableDataManager dSTableDataManager, Project project, DSTableCommandExecutor dSTableCommandExecutor, DSTableOutputData dSTableOutputData, DSPanelInfo dSPanelInfo, boolean bl, String string, int n, Object object) {
        if ((n & 0x20) != 0) {
            string = null;
        }
        return dSTableDataManager.addNewTableData(project, dSTableCommandExecutor, dSTableOutputData, dSPanelInfo, bl, string);
    }

    private final boolean showDynamicTable(Project project, DSTableCommandExecutor tableCommandExecutor, DSTableOutputData data, DSPanelInfo panelInfo, DataId dataId, DSTableDataProvider provider, String format) {
        if (data.getVarName() == null || tableCommandExecutor == null) {
            LOG.error("Tried to load full table without variable name or without executor");
            return false;
        }
        this.addToHistoryWithEmptyData(dataId, data.getVarName());
        try {
            DSDataFrameInfo dataFrameInfo = this.getDataFrameInfo(dataId, provider, tableCommandExecutor, data.getVarName(), data.getTableText().getStaticTableText());
            if (!((Collection)dataFrameInfo.getColumnNames()).isEmpty()) {
                this.addFallbackSessionListener(dataId, tableCommandExecutor, provider, panelInfo);
                this.createTableDataRetrieverFromDataSourceAndUpdateOrCreateTable(project, dataId, data.getVarName(), provider, tableCommandExecutor, dataFrameInfo, true, panelInfo, data.getDataType(), format);
                if (dataFrameInfo.getRows() == 0) {
                    ApplicationManager.getApplication().invokeLater(() -> DSTableDataManager.showDynamicTable$lambda$0(tableCommandExecutor));
                }
                return true;
            }
        }
        catch (DSTableDataException e) {
            DSTableDataManager $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(DSTableDataManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Exception while loading table data", (Throwable)e);
            String string = e.getMessage();
            if (string == null) {
                string = DSTableBundle.message("ds.DataManager.cannot.get.dataframe", new Object[0]);
            }
            DSTableDataManager.Companion.showErrorMessage(project, string);
            ApplicationManager.getApplication().invokeLater(() -> DSTableDataManager.showDynamicTable$lambda$1(tableCommandExecutor));
            return false;
        }
        catch (Error er) {
            LOG.error((Throwable)er);
            return false;
        }
        return false;
    }

    private final void showStaticTable(Project project, DSTableOutputData data, DSPanelInfo panelInfo, DataId dataId, DSTableDataProvider provider) {
        String text = data.getTableText().getStaticTableText();
        if (((CharSequence)text).length() == 0) {
            return;
        }
        if (!provider.isFallbackToStaticTableSupported()) {
            return;
        }
        String emptyExpr = " ";
        this.addToHistoryWithEmptyData(dataId, emptyExpr);
        DSDataFrameInfo dataFrameInfo = provider.parseStaticTableToFrameInfo(text);
        this.loadFrameInfoToHistory(dataId, dataFrameInfo);
        this.loadDataToHistory(dataId, provider.parseStaticTableToTableData(dataId, text));
        this.createTableDataRetrieverFromDataSourceAndUpdateOrCreateTable(project, dataId, emptyExpr, provider, null, dataFrameInfo, false, panelInfo, data.getDataType(), null);
    }

    private final void createTableDataRetrieverFromDataSourceAndUpdateOrCreateTable(Project project, DataId dataId, String tableVariableExpression, DSTableDataProvider tableDataProvider, DSTableCommandExecutor tableCommandExecutor, DSDataFrameInfo dataFrameInfo, boolean isDynamicTable, DSPanelInfo panelInfo, DSTableDataType dataType, String format) {
        DSTableDataRetrieverFromDataSource tableDataRetriever = tableDataProvider instanceof NestedTableDataProvider ? (DSTableDataRetrieverFromDataSource)new NestedTableDataRetrieverFromDataSource(dataId, this, tableVariableExpression, (NestedTableDataProvider)tableDataProvider, tableCommandExecutor, dataFrameInfo, panelInfo, isDynamicTable, null, null, null, null, 3840, null) : (DSTableDataRetrieverFromDataSource)new DSTableDataRetrieverFromDataSourceImpl(dataId, this, tableVariableExpression, tableDataProvider, tableCommandExecutor, dataFrameInfo, panelInfo, isDynamicTable, null, null, null, null, format, 3840, null);
        DSTableContentManager.INSTANCE.updateOrCreateTableContent(project, tableVariableExpression, tableDataRetriever, panelInfo, dataType);
    }

    public final void fallbackToStaticTable(@NotNull DataId dataId, @NotNull DSTableCommandExecutor tableCommandExecutor, @NotNull DSTableDataProvider provider, @NotNull DSPanelInfo panelInfo) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        Intrinsics.checkNotNullParameter((Object)tableCommandExecutor, (String)"tableCommandExecutor");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)panelInfo, (String)"panelInfo");
        if (provider.isFallbackToStaticTableSupported()) {
            DSTableOutputData dSTableOutputData = this.getStaticTableData(dataId);
            if (dSTableOutputData == null) {
                return;
            }
            DSTableOutputData staticTableData = dSTableOutputData;
            DSTableText tableText = staticTableData.getTableText();
            if (((CharSequence)tableText.getStaticTableText()).length() == 0 && ((CharSequence)tableText.getPlainText()).length() == 0) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> DSTableDataManager.fallbackToStaticTable$lambda$2(this, dataId, tableCommandExecutor, staticTableData, panelInfo));
        } else {
            tableCommandExecutor.restoreOutputWithoutStaticTableData();
        }
    }

    public final void fallbackToPreviousValidTable(@NotNull DataId dataId, @NotNull DSTableCommandExecutor tableCommandExecutor, @NotNull DSTableDataProvider provider, @NotNull DSPanelInfo panelInfo) {
        String savedTableExpression;
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        Intrinsics.checkNotNullParameter((Object)tableCommandExecutor, (String)"tableCommandExecutor");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)panelInfo, (String)"panelInfo");
        DSHistoryForTableExpression dSHistoryForTableExpression = this.dynamicTablesHistory.get(dataId);
        String string = savedTableExpression = dSHistoryForTableExpression != null ? dSHistoryForTableExpression.getPreviousTableVariableExpression() : null;
        if (savedTableExpression == null) {
            this.fallbackToStaticTable(dataId, tableCommandExecutor, provider, panelInfo);
        } else {
            DSTableOutputData dSTableOutputData = this.getStaticTableData(dataId);
            if (dSTableOutputData == null) {
                dSTableOutputData = new DSTableOutputData(savedTableExpression, DSTableFileEditorKt.getDEFAULT_EDITOR_TAB_NAME(), new DSTableText("", ""), provider.getType());
            }
            DSTableOutputData staticTableData = dSTableOutputData;
            this.showDynamicTable(this.project, tableCommandExecutor, staticTableData, panelInfo, dataId, provider, null);
        }
    }

    public final void logDynamicTableToHistory(@NotNull DSTableDataRetrieverFromDataSource tableDataRetriever) {
        DSHistoryForTableExpression dynamicTableHistory;
        Intrinsics.checkNotNullParameter((Object)tableDataRetriever, (String)"tableDataRetriever");
        DSHistoryForTableExpression dSHistoryForTableExpression = dynamicTableHistory = this.dynamicTablesHistory.get(tableDataRetriever.getDataId());
        String previousTableVariableExpression = dSHistoryForTableExpression != null ? dSHistoryForTableExpression.getCurrentTableVariableExpression() : null;
        ((Map)this.dynamicTablesHistory).put(tableDataRetriever.getDataId(), new DSHistoryForTableExpression(previousTableVariableExpression, tableDataRetriever.getCurrentTableExpression()));
    }

    private final DSDataFrameInfo getDataFrameInfo(DataId dataId, DSTableDataProvider provider, DSTableCommandExecutor commandExecutor, String expression, String defaultTableText) throws DSTableDataException {
        DSDataFrameInfo dataFrameInfo = this.tryToLoadFrameInfoFromHistory(dataId);
        if (dataFrameInfo == null) {
            dataFrameInfo = provider.loadDynamicTableDataFrameInfo(commandExecutor, expression, defaultTableText);
            this.loadFrameInfoToHistory(dataId, dataFrameInfo);
        }
        return dataFrameInfo;
    }

    private final void addToHistoryWithEmptyData(DataId dataId, String exprText) {
        ((Map)this.exprCommands).put(dataId, new DSTableCommand(exprText, null, new DSTableRawData(dataId, null)));
    }

    private final DSTableCommand getCommandFromHistory(DataId dataId) {
        return this.exprCommands.get(dataId);
    }

    @Nullable
    public final DSTableRawData tryToLoadDataFromHistory(@NotNull DataId dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        DSTableCommand dSTableCommand = this.getCommandFromHistory(dataId);
        if (dSTableCommand == null) {
            return null;
        }
        DSTableCommand command = dSTableCommand;
        DSTableRawData dataFromHistory = command.getTableRawData();
        return !dataFromHistory.isEmpty() ? dataFromHistory : null;
    }

    public final void loadDataToHistory(@NotNull DataId dataId, @NotNull DSTableRawData data) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        DSTableCommand savedCommand = this.exprCommands.get(dataId);
        Object object = savedCommand;
        boolean bl = object != null && (object = ((DSTableCommand)object).getTableRawData()) != null ? ((DSTableRawData)object).isEmpty() : false;
        if (bl) {
            ((Map)this.exprCommands).put(dataId, new DSTableCommand(savedCommand.getTableVariableExpression(), savedCommand.getDataframeInfo(), data));
        }
    }

    private final DSDataFrameInfo tryToLoadFrameInfoFromHistory(DataId dataId) {
        DSTableCommand dSTableCommand = this.getCommandFromHistory(dataId);
        if (dSTableCommand == null) {
            return null;
        }
        DSTableCommand command = dSTableCommand;
        return command.getDataframeInfo();
    }

    private final void loadFrameInfoToHistory(DataId dataId, DSDataFrameInfo info) {
        DSTableCommand savedCommand = this.exprCommands.get(dataId);
        if (savedCommand != null && savedCommand.getDataframeInfo() == null) {
            ((Map)this.exprCommands).put(dataId, new DSTableCommand(savedCommand.getTableVariableExpression(), info, savedCommand.getTableRawData()));
        }
    }

    public final void addToHistory(@NotNull DataId dataId, @NotNull String commandText) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        Intrinsics.checkNotNullParameter((Object)commandText, (String)"commandText");
        this.addToHistoryWithEmptyData(dataId, commandText);
    }

    private final void addFallbackSessionListener(DataId dataId, DSTableCommandExecutor commandExecutor, DSTableDataProvider provider, DSPanelInfo panelInfo) {
        commandExecutor.addSessionListener(new DSSessionListener(this, dataId, commandExecutor, provider, panelInfo){
            final /* synthetic */ DSTableDataManager this$0;
            final /* synthetic */ DataId $dataId;
            final /* synthetic */ DSTableCommandExecutor $commandExecutor;
            final /* synthetic */ DSTableDataProvider $provider;
            final /* synthetic */ DSPanelInfo $panelInfo;
            {
                this.this$0 = $receiver;
                this.$dataId = $dataId;
                this.$commandExecutor = $commandExecutor;
                this.$provider = $provider;
                this.$panelInfo = $panelInfo;
            }

            public void frameChanged() {
            }

            public void sessionStopped() {
                this.this$0.fallbackToStaticTable(this.$dataId, this.$commandExecutor, this.$provider, this.$panelInfo);
            }
        });
    }

    @Nullable
    public final DSTableOutputData getStaticTableData(@NotNull DataId dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        return this.staticOutputData.get(dataId);
    }

    public final void removeData(@NotNull DataId dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        this.exprCommands.remove(dataId);
        this.staticOutputData.remove(dataId);
    }

    @Nullable
    public final String getDimensionText(@NotNull DataId dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        DSDataFrameInfo dSDataFrameInfo = this.tryToLoadFrameInfoFromHistory(dataId);
        return dSDataFrameInfo != null ? dSDataFrameInfo.getDim() : null;
    }

    private static final void showDynamicTable$lambda$0(DSTableCommandExecutor $tableCommandExecutor) {
        $tableCommandExecutor.notifyAsyncOutputLoaded();
    }

    private static final void showDynamicTable$lambda$1(DSTableCommandExecutor $tableCommandExecutor) {
        $tableCommandExecutor.notifyAsyncOutputLoaded();
    }

    private static final void fallbackToStaticTable$lambda$2(DSTableDataManager this$0, DataId $dataId, DSTableCommandExecutor $tableCommandExecutor, DSTableOutputData $staticTableData, DSPanelInfo $panelInfo) {
        this$0.removeData($dataId);
        if (this$0.project.isDisposed()) {
            return;
        }
        DSTableDataManager.addNewTableData$default(this$0, this$0.project, $tableCommandExecutor, $staticTableData, $panelInfo, false, null, 32, null);
    }

    @JvmStatic
    @NotNull
    public static final DSTableDataManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    static {
        Logger logger = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\u000e\u001a\u00020\u000fH\u0002R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/scientific/tables/DSTableDataManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/scientific/tables/DSTableDataManager;", "project", "Lcom/intellij/openapi/project/Project;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "showErrorMessage", "", "message", "", "intellij.scientific.tables"})
    @SourceDebugExtension(value={"SMAP\nDSTableDataManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DSTableDataManager.kt\ncom/intellij/scientific/tables/DSTableDataManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,329:1\n31#2,2:330\n*S KotlinDebug\n*F\n+ 1 DSTableDataManager.kt\ncom/intellij/scientific/tables/DSTableDataManager$Companion\n*L\n314#1:330,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DSTableDataManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<DSTableDataManager> serviceClass$iv = DSTableDataManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (DSTableDataManager)object;
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private final void showErrorMessage(Project project, @NonNls String message) {
            ApplicationManager.getApplication().invokeLater(() -> Companion.showErrorMessage$lambda$1(message, project));
        }

        private static final void showErrorMessage$lambda$1$lambda$0(Notification $notification) {
            $notification.hideBalloon();
        }

        private static final void showErrorMessage$lambda$1(String $message, Project $project) {
            Notification notification = NotificationGroupManager.getInstance().getNotificationGroup("DSTableLoadingError").createNotification(DSTableBundle.message("ds.table.load.error.title", new Object[0]), $message, NotificationType.INFORMATION);
            notification.notify($project);
            EdtScheduler.Companion.getInstance().schedule-VtjQ1oo(DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS), () -> Companion.showErrorMessage$lambda$1$lambda$0(notification));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

