/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.TruffleStackTraceElement;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSReadFrameSlotNode;
import com.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.oracle.truffle.js.nodes.control.TryCatchNode;
import com.oracle.truffle.js.nodes.control.YieldException;
import com.oracle.truffle.js.nodes.function.AbstractFunctionRootNode;
import com.oracle.truffle.js.nodes.function.FunctionBodyNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import com.oracle.truffle.js.nodes.promise.AsyncRootNode;
import com.oracle.truffle.js.nodes.promise.NewPromiseCapabilityNode;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.objects.Completion;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import com.oracle.truffle.js.runtime.objects.ScriptOrModule;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.List;
import java.util.Set;

public final class AsyncFunctionBodyNode
extends JavaScriptNode {
    private final JSContext context;
    @Node.Child
    private JSWriteFrameSlotNode writeAsyncContext;
    @Node.Child
    private NewPromiseCapabilityNode newPromiseCapability;
    private final AsyncFunctionRootNode resumptionRootNode;
    @Node.Child
    private volatile DirectCallNode asyncCallNode;

    public AsyncFunctionBodyNode(JSContext context2, JSWriteFrameSlotNode writeAsyncContext, AsyncFunctionRootNode resumptionRootNode) {
        this.context = context2;
        this.writeAsyncContext = writeAsyncContext;
        this.resumptionRootNode = resumptionRootNode;
        this.newPromiseCapability = NewPromiseCapabilityNode.create(context2);
    }

    public static JavaScriptNode create(JSContext context2, JavaScriptNode body2, JSWriteFrameSlotNode writeAsyncContext, JSReadFrameSlotNode readAsyncContext, JSWriteFrameSlotNode writeAsyncResult, SourceSection functionSourceSection, TruffleString functionName, ScriptOrModule activeScriptOrModule) {
        AsyncFunctionRootNode resumptionRootNode = new AsyncFunctionRootNode(context2, body2, writeAsyncResult, readAsyncContext, functionSourceSection, functionName, activeScriptOrModule);
        return new AsyncFunctionBodyNode(context2, writeAsyncContext, resumptionRootNode);
    }

    private JSContext getContext() {
        return this.context;
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.ControlFlowRootTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    @Override
    public Object getNodeObject() {
        return JSTags.createNodeObjectDescriptor("type", JSTags.ControlFlowRootTag.Type.AsyncFunction.name());
    }

    private void initializeAsyncCallTarget() {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.asyncCallNode = this.insert(DirectCallNode.create(this.resumptionRootNode.getCallTarget()));
    }

    private void ensureAsyncCallTargetInitialized() {
        if (this.asyncCallNode == null) {
            this.initializeAsyncCallTarget();
        }
    }

    private void asyncFunctionStart(VirtualFrame frame, PromiseCapabilityRecord promiseCapability) {
        MaterializedFrame materializedFrame = frame.materialize();
        this.ensureAsyncCallTargetInitialized();
        this.writeAsyncContext.executeWrite(frame, AsyncRootNode.createAsyncContext(this.asyncCallNode.getCallTarget(), promiseCapability, materializedFrame));
        Object unusedInitialResult = null;
        this.asyncCallNode.call(JSArguments.createResumeArguments(materializedFrame, promiseCapability, Completion.Type.Normal, unusedInitialResult));
    }

    @Override
    public Object execute(VirtualFrame frame) {
        PromiseCapabilityRecord promiseCapability = this.newPromiseCapability.executeDefault();
        this.asyncFunctionStart(frame, promiseCapability);
        return promiseCapability.getPromise();
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return new AsyncFunctionBodyNode(this.getContext(), AsyncFunctionBodyNode.cloneUninitialized(this.writeAsyncContext, materializedTags), this.resumptionRootNode);
    }

    @Override
    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        if (!materializedTags.isEmpty()) {
            this.resumptionRootNode.getCallTarget();
        }
        return this;
    }

    public static final class AsyncFunctionRootNode
    extends AbstractFunctionRootNode
    implements AsyncRootNode {
        private final JSContext context;
        private final TruffleString functionName;
        @Node.Child
        private JavaScriptNode functionBody;
        @Node.Child
        private JSReadFrameSlotNode readAsyncContext;
        @Node.Child
        private JSWriteFrameSlotNode writeAsyncResult;
        @Node.Child
        private JSFunctionCallNode callResolveNode;
        @Node.Child
        private JSFunctionCallNode callRejectNode;
        @Node.Child
        private TryCatchNode.GetErrorObjectNode getErrorObjectNode;

        AsyncFunctionRootNode(JSContext context2, JavaScriptNode body2, JSWriteFrameSlotNode asyncResult, JSReadFrameSlotNode readAsyncContext, SourceSection functionSourceSection, TruffleString functionName, ScriptOrModule activeScriptOrModule) {
            super(context2.getLanguage(), functionSourceSection, null, activeScriptOrModule);
            this.context = context2;
            this.functionBody = new FunctionBodyNode(body2);
            this.readAsyncContext = readAsyncContext;
            this.writeAsyncResult = asyncResult;
            this.callResolveNode = JSFunctionCallNode.createCall();
            this.functionName = functionName;
            JavaScriptNode.transferSourceSection(body2, this.functionBody);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object executeInRealm(VirtualFrame frame) {
            boolean enterContext;
            JSRealm realm;
            Object[] arguments = frame.getArguments();
            MaterializedFrame asyncFrame = JSArguments.getResumeExecutionContext(arguments);
            PromiseCapabilityRecord promiseCapability = (PromiseCapabilityRecord)JSArguments.getResumeGeneratorOrPromiseCapability(arguments);
            Completion resumptionValue = JSArguments.getResumeCompletion(arguments);
            this.writeAsyncResult.executeWrite(asyncFrame, resumptionValue);
            JSRealm currentRealm = this.getRealm();
            if (this.context.neverCreatedChildRealms()) {
                assert (currentRealm == JSFunction.getRealm(JSFrameUtil.getFunctionObject(asyncFrame)));
                realm = currentRealm;
                enterContext = false;
            } else {
                realm = JSFunction.getRealm(JSFrameUtil.getFunctionObject(asyncFrame));
                enterContext = realm != currentRealm;
            }
            Object prev = null;
            TruffleContext childContext = null;
            if (enterContext) {
                childContext = realm.getTruffleContext();
                prev = childContext.enter(this);
            }
            try {
                Object result2 = this.functionBody.execute(asyncFrame);
                this.promiseCapabilityResolve(promiseCapability, result2);
            }
            catch (YieldException e) {
                assert (e.isAwait());
            }
            catch (AbstractTruffleException e) {
                this.promiseCapabilityReject(promiseCapability, e);
            }
            finally {
                if (enterContext) {
                    childContext.leave(this, prev);
                }
            }
            return Undefined.instance;
        }

        private void promiseCapabilityResolve(PromiseCapabilityRecord promiseCapability, Object result2) {
            this.callResolveNode.executeCall(JSArguments.createOneArg(Undefined.instance, promiseCapability.getResolve(), result2));
        }

        private void promiseCapabilityReject(PromiseCapabilityRecord promiseCapability, AbstractTruffleException e) {
            if (this.getErrorObjectNode == null || this.callRejectNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getErrorObjectNode = this.insert(TryCatchNode.GetErrorObjectNode.create(this.context));
                this.callRejectNode = this.insert(JSFunctionCallNode.createCall());
            }
            Object error = this.getErrorObjectNode.execute(e);
            this.callRejectNode.executeCall(JSArguments.createOneArg(Undefined.instance, promiseCapability.getReject(), error));
        }

        @Override
        public boolean isResumption() {
            return true;
        }

        @Override
        public String getName() {
            if (this.functionName != null && !this.functionName.isEmpty()) {
                return Strings.toJavaString(this.functionName);
            }
            return ":async";
        }

        @Override
        public String toString() {
            return this.getName();
        }

        @Override
        public JSDynamicObject getAsyncFunctionPromise(Frame asyncFrame) {
            Object[] initialState = (Object[])this.readAsyncContext.execute((VirtualFrame)asyncFrame);
            RootCallTarget resumeTarget = (RootCallTarget)initialState[0];
            assert (resumeTarget.getRootNode() == this);
            Object promiseCapability = initialState[1];
            return ((PromiseCapabilityRecord)promiseCapability).getPromise();
        }

        public List<TruffleStackTraceElement> getSavedStackTrace(Frame asyncFrame) {
            Object[] initialState = (Object[])this.readAsyncContext.execute((VirtualFrame)asyncFrame);
            return (List)initialState[3];
        }

        @Override
        protected List<TruffleStackTraceElement> findAsynchronousFrames(Frame frame) {
            if (!this.context.isOptionAsyncStackTraces() || this.context.getLanguage().getAsyncStackDepth() == 0) {
                return null;
            }
            VirtualFrame asyncFrame = frame.getFrameDescriptor() == this.getFrameDescriptor() ? JSArguments.getResumeExecutionContext(frame.getArguments()) : (VirtualFrame)ScopeFrameNode.getNonBlockScopeParentFrame(frame);
            return this.getSavedStackTrace(asyncFrame);
        }
    }
}

