/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.qml.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.qml.psi.impl.QmlImportReferenceExpressionImpl;
import com.intellij.lang.qml.settings.QmlSettings;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.qt.common.settings.QtSettings;
import com.intellij.util.ProcessingContext;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class QmlImportCompletionProvider
extends CompletionProvider<CompletionParameters>
implements DumbAware {
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            QmlImportCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            QmlImportCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            QmlImportCompletionProvider.$$$reportNull$$$0(2);
        }
        QtSettings qtSettings = QtSettings.getInstance((Project)parameters.getPosition().getProject());
        QmlSettings qmlSettings = QmlSettings.getInstance(parameters.getPosition().getProject());
        String qmlMainPath = qtSettings.getResultingQmlDir();
        if (qmlMainPath.isEmpty()) {
            return;
        }
        ArrayList<String> qmlPaths = new ArrayList<String>();
        qmlPaths.add(qmlMainPath);
        qmlPaths.addAll(qmlSettings.getExtraQmlPaths(qtSettings.getCurrentProfile()));
        @Nullable PsiElement parent = parameters.getPosition().getParent();
        if (parent == null) {
            return;
        }
        PsiElement importElement = parent.getParent();
        if (importElement instanceof QmlImportReferenceExpressionImpl) {
            QmlImportReferenceExpressionImpl importRef = (QmlImportReferenceExpressionImpl)importElement;
            @Unmodifiable @NotNull List parts = StringUtil.split((String)importRef.getText(), (String)".", (boolean)true, (boolean)false);
            for (String qmlPath : qmlPaths) {
                File parentDir;
                StringBuilder sb = new StringBuilder(qmlPath);
                for (int i = 0; i < parts.size() - 1; ++i) {
                    sb.append(File.separator).append((String)parts.get(i));
                }
                String path = sb.toString();
                if (!FileUtil.exists((String)path) || !(parentDir = new File(path)).isDirectory()) continue;
                ArrayList<LookupElementBuilder> lookupElements = new ArrayList<LookupElementBuilder>();
                for (File file : Objects.requireNonNull(parentDir.listFiles())) {
                    if (!file.isDirectory()) continue;
                    lookupElements.add(LookupElementBuilder.create((String)file.getName()));
                }
                result.addAllElements(lookupElements);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/qml/completion/QmlImportCompletionProvider";
        objectArray[2] = "addCompletions";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

