/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.DirectoryContentSpec;
import com.intellij.util.io.impl.DirectoryContentSpecImpl;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0005H\u0016J\u0010\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/util/io/impl/FileSpec;", "Lcom/intellij/util/io/impl/DirectoryContentSpecImpl;", "content", "", "originalFile", "Ljava/nio/file/Path;", "<init>", "([BLjava/nio/file/Path;)V", "getContent", "()[B", "getOriginalFile", "()Ljava/nio/file/Path;", "generate", "", "target", "Ljava/io/File;", "generateInTempDir", "mergeWith", "other", "Lcom/intellij/util/io/DirectoryContentSpec;", "intellij.platform.testFramework"})
public final class FileSpec
extends DirectoryContentSpecImpl {
    @Nullable
    private final byte[] content;
    @Nullable
    private final Path originalFile;

    public FileSpec(@Nullable byte[] content, @Nullable Path originalFile) {
        super(null);
        this.content = content;
        this.originalFile = originalFile;
    }

    public /* synthetic */ FileSpec(byte[] byArray, Path path, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            path = null;
        }
        this(byArray, path);
    }

    @Nullable
    public final byte[] getContent() {
        return this.content;
    }

    @Override
    @Nullable
    public Path getOriginalFile() {
        return this.originalFile;
    }

    @Override
    public void generate(@NotNull File target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        byte[] byArray = this.content;
        if (this.content == null) {
            byArray = new byte[]{};
        }
        FileUtil.writeToFile((File)target, (byte[])byArray);
    }

    @Override
    @NotNull
    public Path generateInTempDir() {
        File file = FileUtil.createTempFile((String)"file-by-spec", null, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(...)");
        File target = file;
        this.generate(target);
        Path path = target.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        return path;
    }

    @Override
    @NotNull
    public DirectoryContentSpecImpl mergeWith(@NotNull DirectoryContentSpec other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return (DirectoryContentSpecImpl)other;
    }
}

