/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dataWrangler.jupyterPython.actions;

import com.intellij.dataWrangler.DataWranglerSession;
import com.intellij.dataWrangler.executor.CodePreviewProvider;
import com.intellij.dataWrangler.executor.DataWranglerContext;
import com.intellij.dataWrangler.jupyterPython.actions.DataWranglerExportCodeAction;
import com.intellij.dataWrangler.jupyterPython.engine.PythonDataWranglerContext;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.jetbrains.python.PythonLanguage;
import java.util.List;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J(\u0010\u0006\u001a\u0004\u0018\u00010\u0007\"\b\b\u0000\u0010\b*\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\b0\u000bH\u0096@\u00a2\u0006\u0002\u0010\fJ \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/dataWrangler/jupyterPython/actions/DataWranglerExportPythonScriptAction;", "Lcom/intellij/dataWrangler/jupyterPython/actions/DataWranglerExportCodeAction;", "<init>", "()V", "getTargetLanguage", "Lcom/intellij/lang/Language;", "getFileContent", "", "C", "Lcom/intellij/dataWrangler/jupyterPython/engine/PythonDataWranglerContext;", "session", "Lcom/intellij/dataWrangler/DataWranglerSession;", "(Lcom/intellij/dataWrangler/DataWranglerSession;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "writeFile", "", "outputFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "content", "intellij.dataWrangler.jupyterPython"})
public final class DataWranglerExportPythonScriptAction
extends DataWranglerExportCodeAction {
    @Override
    @NotNull
    public Language getTargetLanguage() {
        PythonLanguage pythonLanguage = PythonLanguage.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)pythonLanguage, (String)"INSTANCE");
        return (Language)pythonLanguage;
    }

    @Override
    @Nullable
    public <C extends PythonDataWranglerContext> Object getFileContent(@NotNull DataWranglerSession<C> session, @NotNull Continuation<? super String> $completion) {
        PythonDataWranglerContext context = (PythonDataWranglerContext)session.getContext();
        CodePreviewProvider codePreviewProvider = session.getCodePreviewProvider();
        if (codePreviewProvider == null) {
            return null;
        }
        CodePreviewProvider previewProvider = codePreviewProvider;
        List commands = session.getTransformationStepsManager().getExecutedCommands();
        return previewProvider.getTransformationCode((DataWranglerContext)context, commands, $completion);
    }

    @Override
    public void writeFile(@NotNull VirtualFile outputFile, @NotNull Project project, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        VirtualFileUtil.writeText((VirtualFile)outputFile, (String)content);
    }
}

