/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils.stats;

import java.time.Clock;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.utils.stats.TimeBasedSlidingWindow;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0019\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010\u0013\u001a\u00020\u0014J\u0015\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jitsi/utils/stats/MovingAverage;", "T", "", "", "windowSize", "Ljava/time/Duration;", "clock", "Ljava/time/Clock;", "(Ljava/time/Duration;Ljava/time/Clock;)V", "currSum", "", "numElements", "", "slidingWindow", "Lorg/jitsi/utils/stats/TimeBasedSlidingWindow;", "add", "", "value", "(Ljava/lang/Number;)V", "get", "", "onEviction", "jitsi-utils"})
public final class MovingAverage<T extends Number> {
    @NotNull
    private final TimeBasedSlidingWindow<T> slidingWindow;
    private long currSum;
    private int numElements;

    @JvmOverloads
    public MovingAverage(@NotNull Duration windowSize, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)windowSize, (String)"windowSize");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.slidingWindow = new TimeBasedSlidingWindow(windowSize, (Function1)new Function1<T, Unit>(this){

            public final void invoke(@NotNull T p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                MovingAverage.access$onEviction((MovingAverage)this.receiver, p0);
            }
        }, clock);
    }

    public /* synthetic */ MovingAverage(Duration duration, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC()");
            clock = clock2;
        }
        this(duration, clock);
    }

    public final synchronized double get() {
        this.slidingWindow.forceEviction();
        if (this.numElements == 0) {
            return 0.0;
        }
        return (double)this.currSum / (double)this.numElements;
    }

    public final synchronized void add(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.slidingWindow.add(value);
        MovingAverage movingAverage = this;
        movingAverage.currSum += ((Number)value).longValue();
        movingAverage = this;
        int n = movingAverage.numElements;
        movingAverage.numElements = n + 1;
    }

    private final synchronized void onEviction(T value) {
        MovingAverage movingAverage = this;
        movingAverage.currSum -= ((Number)value).longValue();
        movingAverage = this;
        int n = movingAverage.numElements;
        movingAverage.numElements = n + -1;
    }

    @JvmOverloads
    public MovingAverage(@NotNull Duration windowSize) {
        Intrinsics.checkNotNullParameter((Object)windowSize, (String)"windowSize");
        this(windowSize, null, 2, null);
    }

    public static final /* synthetic */ void access$onEviction(MovingAverage $this, Number value) {
        $this.onEviction(value);
    }
}

