/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.lang.template.inspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.jinja.template.DjangoTemplateCloseTagHandlingVisitor;
import com.intellij.jinja.template.psi.DjangoTagName;
import com.intellij.jinja.template.psi.impl.DjangoTagElementImpl;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.python.django.lang.template.inspection.DjangoInspectionVisitor;
import com.intellij.python.django.lang.template.inspection.DjangoTemplateLocalInspectionTool;
import com.jetbrains.django.ui.DjangoBundle;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class TemplateCloseTagInspection
extends DjangoTemplateLocalInspectionTool {
    @NotNull
    public String getShortName() {
        return "DjangoCloseTagInspection";
    }

    @Override
    protected PsiElementVisitor createInspectionVisitor(InspectionManager manager) {
        return new DjangoTagVisitor(manager);
    }

    private static final class DjangoTagVisitor
    extends DjangoTemplateCloseTagHandlingVisitor
    implements DjangoInspectionVisitor {
        private final List<ProblemDescriptor> myProblems = new ArrayList<ProblemDescriptor>();
        private final InspectionManager myManager;

        private DjangoTagVisitor(InspectionManager manager) {
            this.myManager = manager;
        }

        protected void handleCloseTagWithoutOpened(@NotNull DjangoTagName closeTag) {
            if (closeTag == null) {
                DjangoTagVisitor.$$$reportNull$$$0(0);
            }
            this.reportCloseTagWithoutOpened(closeTag);
        }

        protected void handleMiddleWithoutOpened(@NotNull DjangoTagName middleTag) {
            if (middleTag == null) {
                DjangoTagVisitor.$$$reportNull$$$0(1);
            }
            this.reportMiddleTagWithoutOpen(middleTag);
        }

        protected void handleOpenedTagWithoutClosed(@NotNull DjangoTagName openedTag) {
            if (openedTag == null) {
                DjangoTagVisitor.$$$reportNull$$$0(2);
            }
            this.reportOpenTagWithoutClosing(openedTag);
        }

        @NotNull
        private static PsiElement substitute(@NotNull DjangoTagName tagName) {
            DjangoTagElementImpl parent;
            if (tagName == null) {
                DjangoTagVisitor.$$$reportNull$$$0(3);
            }
            Object object = (parent = (DjangoTagElementImpl)PsiTreeUtil.getParentOfType((PsiElement)tagName, DjangoTagElementImpl.class)) != null ? parent : tagName;
            if (object == null) {
                DjangoTagVisitor.$$$reportNull$$$0(4);
            }
            return object;
        }

        private void reportOpenTagWithoutClosing(DjangoTagName openTag) {
            this.reportProblem(openTag, DjangoBundle.message((String)"inspection.error.open-tag-without-closed", (Object[])new Object[]{openTag.getTagName()}));
        }

        private void reportMiddleTagWithoutOpen(DjangoTagName middleTag) {
            this.reportProblem(middleTag, DjangoBundle.message((String)"inspection.error.middle-tag-without-opened", (Object[])new Object[]{middleTag.getTagName()}));
        }

        private void reportCloseTagWithoutOpened(DjangoTagName closeTag) {
            this.reportProblem(closeTag, DjangoBundle.message((String)"inspection.error.no-opened-tag", (Object[])new Object[0]));
        }

        private void reportProblem(DjangoTagName elem, @InspectionMessage String msg) {
            ProblemDescriptor d = this.myManager.createProblemDescriptor(DjangoTagVisitor.substitute(elem), new TextRange(0, DjangoTagVisitor.substitute(elem).getTextLength()), msg, ProblemHighlightType.GENERIC_ERROR, false, new LocalQuickFix[0]);
            this.myProblems.add(d);
        }

        @Override
        public void postprocess() {
            this.reportOpenedTagWithoutCloseTags();
        }

        private void reportOpenedTagWithoutCloseTags() {
            for (DjangoTagName tag : this.getOpenedTags()) {
                this.reportProblem(tag, DjangoBundle.message((String)"inspection.error.no-closing-tag", (Object[])new Object[0]));
            }
        }

        @Override
        public List<ProblemDescriptor> getProblems() {
            return this.myProblems;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "closeTag";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "middleTag";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "openedTag";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tagName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/python/django/lang/template/inspection/TemplateCloseTagInspection$DjangoTagVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/python/django/lang/template/inspection/TemplateCloseTagInspection$DjangoTagVisitor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "substitute";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "handleCloseTagWithoutOpened";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "handleMiddleWithoutOpened";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "handleOpenedTagWithoutClosed";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "substitute";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

