"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Messages = void 0;
var react_1 = __importDefault(require("react"));
var Message_1 = require("./Message");
var contexts_1 = require("../../contexts");
var helpers_1 = require("../../helpers");
var constants_1 = require("../../constants");
var Messages = function () {
    var asyncapi = (0, contexts_1.useSpec)();
    var config = (0, contexts_1.useConfig)();
    var messages = !asyncapi.components().isEmpty() && asyncapi.components().messages().all();
    if (!messages || messages.length === 0) {
        return null;
    }
    return (react_1.default.createElement("section", { id: "".concat(helpers_1.CommonHelpers.getIdentifier('messages', config)), className: "mt-16" },
        react_1.default.createElement("h2", { className: "2xl:w-7/12 text-3xl font-light mb-4 px-8" }, constants_1.MESSAGES_TEXT),
        react_1.default.createElement("ul", null, messages.map(function (message, idx) {
            var _a, _b;
            return (react_1.default.createElement("li", { className: "mb-4", key: message.id(), id: helpers_1.CommonHelpers.getIdentifier("message-".concat(message.id()), config) },
                react_1.default.createElement(Message_1.Message, { messageName: message.id(), message: message, index: idx + 1, key: message.id(), showExamples: (_b = (_a = config === null || config === void 0 ? void 0 : config.show) === null || _a === void 0 ? void 0 : _a.messageExamples) !== null && _b !== void 0 ? _b : false })));
        }))));
};
exports.Messages = Messages;
//# sourceMappingURL=Messages.js.map