/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.log4jv2;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxLoggingManager;
import org.ops4j.pax.logging.PaxLoggingManagerAwareLogger;
import org.ops4j.pax.logging.PaxMarker;
import org.ops4j.pax.logging.spi.support.FallbackLogFactory;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.log.LogLevel;

public class Log4jv2Logger
extends AbstractLogger
implements PaxLoggingManagerAwareLogger {
    static final String LOG4J_FQCN = Logger.class.getName();
    private String m_name;
    private volatile PaxLogger m_delegate;

    public Log4jv2Logger(String name, MessageFactory messageFactory, PaxLogger delegate) {
        super(name, messageFactory);
        this.m_name = name;
        this.m_delegate = delegate;
    }

    @Override
    public void setPaxLoggingManager(PaxLoggingManager paxLoggingManager) {
        this.m_delegate = paxLoggingManager == null ? FallbackLogFactory.createFallbackLog(FrameworkUtil.getBundle(Log4jv2Logger.class), this.m_name) : paxLoggingManager.getLogger(this.m_name, LOG4J_FQCN);
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, Message message, Throwable t) {
        boolean mf = marker == null || this.markerDecision(level, marker);
        return this.getLevel().intLevel() >= level.intLevel() && mf;
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, Object message, Throwable t) {
        boolean mf = marker == null || this.markerDecision(level, marker);
        return this.getLevel().intLevel() >= level.intLevel() && mf;
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, String message, Throwable t) {
        boolean mf = marker == null || this.markerDecision(level, marker);
        return this.getLevel().intLevel() >= level.intLevel() && mf;
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, String message) {
        boolean mf = marker == null || this.markerDecision(level, marker);
        return this.getLevel().intLevel() >= level.intLevel() && mf;
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, String message, Object ... params) {
        boolean mf = marker == null || this.markerDecision(level, marker);
        return this.getLevel().intLevel() >= level.intLevel() && mf;
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, CharSequence message, Throwable t) {
        boolean mf = marker == null || this.markerDecision(level, marker);
        return this.getLevel().intLevel() >= level.intLevel() && mf;
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, String message, Object p0) {
        boolean mf = marker == null || this.markerDecision(level, marker);
        return this.getLevel().intLevel() >= level.intLevel() && mf;
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1) {
        boolean mf = marker == null || this.markerDecision(level, marker);
        return this.getLevel().intLevel() >= level.intLevel() && mf;
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2) {
        boolean mf = marker == null || this.markerDecision(level, marker);
        return this.getLevel().intLevel() >= level.intLevel() && mf;
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
        boolean mf = marker == null || this.markerDecision(level, marker);
        return this.getLevel().intLevel() >= level.intLevel() && mf;
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        boolean mf = marker == null || this.markerDecision(level, marker);
        return this.getLevel().intLevel() >= level.intLevel() && mf;
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        boolean mf = marker == null || this.markerDecision(level, marker);
        return this.getLevel().intLevel() >= level.intLevel() && mf;
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        boolean mf = marker == null || this.markerDecision(level, marker);
        return this.getLevel().intLevel() >= level.intLevel() && mf;
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        boolean mf = marker == null || this.markerDecision(level, marker);
        return this.getLevel().intLevel() >= level.intLevel() && mf;
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        boolean mf = marker == null || this.markerDecision(level, marker);
        return this.getLevel().intLevel() >= level.intLevel() && mf;
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        boolean mf = marker == null || this.markerDecision(level, marker);
        return this.getLevel().intLevel() >= level.intLevel() && mf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logMessage(String fqcn, Level level, Marker marker, Message message, Throwable t) {
        try {
            this.m_delegate.getPaxContext().put(".log4j2_message", message);
            if (marker != null) {
                PaxMarker paxMarker = new PaxMarker(marker);
                if (level.intLevel() >= Level.TRACE.intLevel()) {
                    this.m_delegate.fqtrace(fqcn, paxMarker, message.getFormattedMessage(), t);
                } else if (level.intLevel() >= Level.DEBUG.intLevel()) {
                    this.m_delegate.fqdebug(fqcn, paxMarker, message.getFormattedMessage(), t);
                } else if (level.intLevel() >= Level.INFO.intLevel()) {
                    this.m_delegate.fqinfo(fqcn, paxMarker, message.getFormattedMessage(), t);
                } else if (level.intLevel() >= Level.WARN.intLevel()) {
                    this.m_delegate.fqwarn(fqcn, paxMarker, message.getFormattedMessage(), t);
                } else if (level.intLevel() >= Level.ERROR.intLevel()) {
                    this.m_delegate.fqerror(fqcn, paxMarker, message.getFormattedMessage(), t);
                } else if (level.intLevel() >= Level.FATAL.intLevel()) {
                    this.m_delegate.fqfatal(fqcn, paxMarker, message.getFormattedMessage(), t);
                }
            } else if (level.intLevel() >= Level.TRACE.intLevel()) {
                this.m_delegate.fqtrace(fqcn, message.getFormattedMessage(), t);
            } else if (level.intLevel() >= Level.DEBUG.intLevel()) {
                this.m_delegate.fqdebug(fqcn, message.getFormattedMessage(), t);
            } else if (level.intLevel() >= Level.INFO.intLevel()) {
                this.m_delegate.fqinfo(fqcn, message.getFormattedMessage(), t);
            } else if (level.intLevel() >= Level.WARN.intLevel()) {
                this.m_delegate.fqwarn(fqcn, message.getFormattedMessage(), t);
            } else if (level.intLevel() >= Level.ERROR.intLevel()) {
                this.m_delegate.fqerror(fqcn, message.getFormattedMessage(), t);
            } else if (level.intLevel() >= Level.FATAL.intLevel()) {
                this.m_delegate.fqfatal(fqcn, message.getFormattedMessage(), t);
            }
        }
        finally {
            this.m_delegate.getPaxContext().remove(".log4j2_message");
        }
    }

    @Override
    public Level getLevel() {
        LogLevel logLevel = this.m_delegate.getLogLevel();
        if (logLevel == null) {
            return Level.OFF;
        }
        switch (logLevel) {
            case TRACE: {
                return Level.TRACE;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case INFO: {
                return Level.INFO;
            }
            case WARN: {
                return Level.WARN;
            }
            case ERROR: {
                return Level.ERROR;
            }
            case AUDIT: {
                return Level.ALL;
            }
        }
        return Level.OFF;
    }

    private boolean markerDecision(Level level, Marker marker) {
        PaxMarker m = new PaxMarker(marker);
        if (level.intLevel() >= Level.ALL.intLevel()) {
            return true;
        }
        if (level.intLevel() >= Level.TRACE.intLevel()) {
            return this.m_delegate.isTraceEnabled(m);
        }
        if (level.intLevel() >= Level.DEBUG.intLevel()) {
            return this.m_delegate.isDebugEnabled(m);
        }
        if (level.intLevel() >= Level.INFO.intLevel()) {
            return this.m_delegate.isInfoEnabled(m);
        }
        if (level.intLevel() >= Level.WARN.intLevel()) {
            return this.m_delegate.isWarnEnabled(m);
        }
        if (level.intLevel() >= Level.ERROR.intLevel()) {
            return this.m_delegate.isErrorEnabled(m);
        }
        if (level.intLevel() >= Level.FATAL.intLevel()) {
            return this.m_delegate.isFatalEnabled(m);
        }
        return false;
    }

    @Override
    protected boolean requiresLocation() {
        return true;
    }
}

