/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.script.actions;

import java.time.ZonedDateTime;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.openhab.core.model.core.ModelRepository;
import org.openhab.core.model.script.ScriptServiceUtil;
import org.openhab.core.model.script.actions.Timer;
import org.openhab.core.model.script.engine.Script;
import org.openhab.core.model.script.engine.ScriptEngine;
import org.openhab.core.model.script.engine.ScriptExecutionException;
import org.openhab.core.model.script.engine.action.ActionDoc;
import org.openhab.core.model.script.internal.engine.action.ScriptExecutionActionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class ScriptExecution {
    private static final Logger logger = LoggerFactory.getLogger(ScriptExecution.class);

    @ActionDoc(text="call a script file")
    public static Object callScript(String scriptName) throws ScriptExecutionException {
        ModelRepository repo = ScriptServiceUtil.getModelRepository();
        if (repo != null) {
            XExpression expr;
            Object scriptNameWithExt = scriptName;
            if (!scriptName.endsWith("script")) {
                scriptNameWithExt = scriptName + ".script";
            }
            if ((expr = (XExpression)repo.getModel((String)scriptNameWithExt)) != null) {
                ScriptEngine scriptEngine = ScriptServiceUtil.getScriptEngine();
                if (scriptEngine != null) {
                    Script script = scriptEngine.newScriptFromXExpression(expr);
                    return script.execute();
                }
                throw new ScriptExecutionException("Script engine is not available.");
            }
            throw new ScriptExecutionException("Script '" + scriptName + "' cannot be found.");
        }
        throw new ScriptExecutionException("Model repository is not available.");
    }

    @ActionDoc(text="create a timer")
    public static Timer createTimer(ZonedDateTime zonedDateTime, Procedures.Procedure0 closure) {
        return new Timer(ScriptExecutionActionService.getScriptExecution().createTimer(zonedDateTime, () -> ((Procedures.Procedure0)closure).apply()));
    }

    @ActionDoc(text="create an identifiable timer ")
    public static Timer createTimer(@Nullable String identifier, ZonedDateTime zonedDateTime, Procedures.Procedure0 closure) {
        return new Timer(ScriptExecutionActionService.getScriptExecution().createTimer(identifier, zonedDateTime, () -> ((Procedures.Procedure0)closure).apply()));
    }

    @ActionDoc(text="create a timer with argument")
    public static Timer createTimerWithArgument(ZonedDateTime zonedDateTime, Object arg1, Procedures.Procedure1 closure) {
        return new Timer(ScriptExecutionActionService.getScriptExecution().createTimerWithArgument(zonedDateTime, arg1, arg_0 -> ((Procedures.Procedure1)closure).apply(arg_0)));
    }

    @ActionDoc(text="create an identifiable timer with argument")
    public static Timer createTimerWithArgument(@Nullable String identifier, ZonedDateTime zonedDateTime, Object arg1, Procedures.Procedure1 closure) {
        return new Timer(ScriptExecutionActionService.getScriptExecution().createTimerWithArgument(identifier, zonedDateTime, arg1, arg_0 -> ((Procedures.Procedure1)closure).apply(arg_0)));
    }
}

