/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.net.InetSocketAddress;
import java.security.Principal;
import org.eclipse.californium.elements.Definition;
import org.eclipse.californium.elements.MapBasedEndpointContext;
import org.eclipse.californium.elements.TcpEndpointContext;
import org.eclipse.californium.elements.util.StringUtil;

public class TlsEndpointContext
extends TcpEndpointContext {
    public static final Definition<String> KEY_SESSION_ID = new Definition<String>("TLS_SESSION_ID", String.class, ATTRIBUTE_DEFINITIONS);
    public static final Definition<String> KEY_CIPHER = new Definition<String>("TLS_CIPHER", String.class, ATTRIBUTE_DEFINITIONS);

    public TlsEndpointContext(InetSocketAddress peerAddress, Principal peerIdentity, String connectionId, String sessionId, String cipher, long timestamp) {
        super(peerAddress, peerIdentity, new MapBasedEndpointContext.Attributes().add(KEY_CONNECTION_ID, connectionId).add(KEY_CONNECTION_TIMESTAMP, timestamp).add(KEY_SESSION_ID, sessionId).add(KEY_CIPHER, cipher));
    }

    public String getSessionId() {
        return this.get(KEY_SESSION_ID);
    }

    public String getCipher() {
        return this.get(KEY_CIPHER);
    }

    @Override
    public String toString() {
        return String.format("TLS(%s,%s,%s,%s)", this.getPeerAddressAsString(), StringUtil.trunc(this.getConnectionId(), 10), StringUtil.trunc(this.getSessionId(), 10), this.getCipher());
    }
}

