/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.yaml.internal.items;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.model.yaml.YamlElement;
import org.openhab.core.model.yaml.YamlElementName;
import org.openhab.core.model.yaml.internal.items.YamlGroupDTO;
import org.openhab.core.model.yaml.internal.items.YamlMetadataDTO;
import org.openhab.core.model.yaml.internal.util.YamlElementUtils;

@YamlElementName(value="items")
public class YamlItemDTO
implements YamlElement,
Cloneable {
    private static final Pattern ID_PATTERN = Pattern.compile("[a-zA-Z0-9_][a-zA-Z0-9_-]*");
    private static final Pattern CHANNEL_ID_PATTERN = Pattern.compile("[a-zA-Z0-9_][a-zA-Z0-9_-]*(#[a-zA-Z0-9_][a-zA-Z0-9_-]*)?");
    public String name;
    public String type;
    public String dimension;
    public YamlGroupDTO group;
    public String label;
    public String icon;
    public String format;
    public String unit;
    public Boolean autoupdate;
    public List<@NonNull String> groups;
    public Set<@NonNull String> tags;
    public String channel;
    public Map<@NonNull String, @NonNull Map<@NonNull String, @NonNull Object>> channels;
    public Map<@NonNull String, @NonNull YamlMetadataDTO> metadata;

    @Override
    public @NonNull String getId() {
        return this.name == null ? "" : this.name;
    }

    @Override
    public void setId(@NonNull String id) {
        this.name = id;
    }

    @Override
    public YamlElement cloneWithoutId() {
        try {
            YamlItemDTO copy = (YamlItemDTO)super.clone();
            copy.name = null;
            return copy;
        }
        catch (CloneNotSupportedException e) {
            return new YamlItemDTO();
        }
    }

    @Override
    public boolean isValid(@Nullable List<@NonNull String> errors, @Nullable List<@NonNull String> warnings) {
        if (this.name == null || this.name.isBlank()) {
            this.addToList(errors, "invalid item: name missing while mandatory");
            return false;
        }
        boolean ok = true;
        if (!ID_PATTERN.matcher(this.name).matches()) {
            this.addToList(errors, "invalid item: name \"%s\" not matching the expected syntax %s".formatted(this.name, ID_PATTERN.pattern()));
            ok = false;
        }
        ArrayList<String> subErrors = new ArrayList<String>();
        ArrayList<String> subWarnings = new ArrayList<String>();
        if (this.type == null || this.type.isBlank()) {
            this.addToList(errors, "invalid item \"%s\": \"type\" field missing while mandatory".formatted(this.name));
            ok = false;
        } else if ("Group".equalsIgnoreCase(this.type)) {
            if (this.dimension != null) {
                this.addToList(warnings, "item \"%s\": \"dimension\" field ignored as type is Group".formatted(this.name));
            }
            if (this.group != null) {
                ok &= this.group.isValid(subErrors, subWarnings);
                subErrors.forEach(error -> this.addToList(errors, "invalid item \"%s\": %s".formatted(this.name, error)));
                subWarnings.forEach(warning -> this.addToList(warnings, "item \"%s\": %s".formatted(this.name, warning)));
            }
        } else {
            if (this.group != null) {
                this.addToList(warnings, "item \"%s\": \"group\" field ignored as type is not Group".formatted(this.name));
            }
            if (!YamlElementUtils.isValidItemType(this.type)) {
                this.addToList(errors, "invalid item \"%s\": invalid value \"%s\" for \"type\" field".formatted(this.name, this.type));
                ok = false;
            } else if (YamlElementUtils.isNumberItemType(this.type)) {
                if (!YamlElementUtils.isValidItemDimension(this.dimension)) {
                    this.addToList(errors, "invalid item \"%s\": invalid value \"%s\" for \"dimension\" field".formatted(this.name, this.dimension));
                    ok = false;
                }
            } else if (this.dimension != null) {
                this.addToList(warnings, "item \"%s\": \"dimension\" field ignored as type is not Number".formatted(this.name, this.dimension));
            }
        }
        if (this.icon != null) {
            subErrors.clear();
            ok &= this.isValidIcon(this.icon, subErrors);
            subErrors.forEach(error -> this.addToList(errors, "invalid item \"%s\": %s".formatted(this.name, error)));
        }
        if (this.groups != null) {
            for (String gr : this.groups) {
                if (ID_PATTERN.matcher(gr).matches()) continue;
                this.addToList(errors, "invalid item \"%s\": value \"%s\" for group name not matching the expected syntax %s".formatted(this.name, gr, ID_PATTERN.pattern()));
                ok = false;
            }
        }
        if (this.channel != null) {
            subErrors.clear();
            ok &= this.isValidChannel(this.channel, subErrors);
            subErrors.forEach(error -> this.addToList(errors, "invalid item \"%s\": %s".formatted(this.name, error)));
        }
        if (this.channels != null) {
            for (String ch : this.channels.keySet()) {
                subErrors.clear();
                ok &= this.isValidChannel(ch, subErrors);
                subErrors.forEach(error -> this.addToList(errors, "invalid item \"%s\": %s".formatted(this.name, error)));
            }
        }
        if (this.metadata != null) {
            Object pattern;
            for (String namespace : this.metadata.keySet()) {
                if (ID_PATTERN.matcher(namespace).matches()) continue;
                this.addToList(errors, "invalid item \"%s\": metadata \"%s\" not matching the expected syntax %s".formatted(this.name, namespace, ID_PATTERN.pattern()));
                ok = false;
            }
            YamlMetadataDTO md = this.metadata.get("autoupdate");
            if (md != null && this.autoupdate != null) {
                this.addToList(warnings, "item \"%s\": \"autoupdate\" field is redundant with \"autoupdate\" metadata; value \"%s\" will be considered".formatted(this.name, md.getValue()));
            }
            if ((md = this.metadata.get("unit")) != null && this.unit != null) {
                this.addToList(warnings, "item \"%s\": \"unit\" field is redundant with \"unit\" metadata; value \"%s\" will be considered".formatted(this.name, md.getValue()));
            }
            Map<@NonNull String, @NonNull Object> mdConfig = (md = this.metadata.get("stateDescription")) == null ? null : md.config;
            Object object = pattern = mdConfig == null ? null : mdConfig.get("pattern");
            if (pattern != null && this.format != null) {
                this.addToList(warnings, "item \"%s\": \"format\" field is redundant with pattern in \"stateDescription\" metadata; \"%s\" will be considered".formatted(this.name, pattern));
            }
        }
        return ok;
    }

    private boolean isValidIcon(String icon, List<@NonNull String> errors) {
        boolean ok = true;
        String[] segments = icon.split(":");
        int nb = segments.length;
        if (nb > 3) {
            errors.add("too many segments in value \"%s\" for \"icon\" field; maximum 3 is expected".formatted(icon));
            ok = false;
            nb = 3;
        }
        int i = 0;
        while (i < nb) {
            String segment = segments[i];
            if (!ID_PATTERN.matcher(segment).matches()) {
                errors.add("segment \"%s\" in \"icon\" field not matching the expected syntax %s".formatted(segment, ID_PATTERN.pattern()));
                ok = false;
            }
            ++i;
        }
        return ok;
    }

    private boolean isValidChannel(String channelUID, List<@NonNull String> errors) {
        String segment;
        boolean ok = true;
        String[] segments = channelUID.split(":");
        int nb = segments.length;
        if (nb < 4) {
            errors.add("not enough segments in channel UID \"%s\"; minimum 4 is expected".formatted(channelUID));
            ok = false;
        }
        int i = 0;
        while (i < nb - 1) {
            segment = segments[i];
            if (!ID_PATTERN.matcher(segment).matches()) {
                errors.add("segment \"%s\" in channel UID \"%s\" not matching the expected syntax %s".formatted(segment, channelUID, ID_PATTERN.pattern()));
                ok = false;
            }
            ++i;
        }
        segment = segments[nb - 1];
        if (!CHANNEL_ID_PATTERN.matcher(segment).matches()) {
            errors.add("last segment \"%s\" in channel UID \"%s\" not matching the expected syntax %s".formatted(segment, channelUID, CHANNEL_ID_PATTERN.pattern()));
            ok = false;
        }
        return ok;
    }

    private void addToList(@Nullable List<@NonNull String> list, String value) {
        if (list != null) {
            list.add(value);
        }
    }

    public @Nullable String getType() {
        return YamlElementUtils.getItemTypeWithDimension(this.type, this.dimension);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.getType(), this.label, this.icon);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        YamlItemDTO other = (YamlItemDTO)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.getType(), other.getType()) && Objects.equals(this.group, other.group) && Objects.equals(this.label, other.label) && Objects.equals(this.icon, other.icon) && Objects.equals(this.format, other.format) && Objects.equals(this.unit, other.unit) && Objects.equals(this.autoupdate, other.autoupdate) && YamlElementUtils.equalsListStrings(this.groups, other.groups) && YamlElementUtils.equalsSetStrings(this.tags, other.tags) && Objects.equals(this.channel, other.channel) && this.equalsChannels(this.channels, other.channels) && this.equalsMetadata(this.metadata, other.metadata);
    }

    private boolean equalsChannels(@Nullable Map<@NonNull String, @NonNull Map<@NonNull String, @NonNull Object>> first, @Nullable Map<@NonNull String, @NonNull Map<@NonNull String, @NonNull Object>> second) {
        if (first != null && second != null) {
            if (first.size() != second.size()) {
                return false;
            }
            return first.entrySet().stream().allMatch(e -> YamlElementUtils.equalsConfig((Map)e.getValue(), (Map)second.get(e.getKey())));
        }
        return first == null && second == null;
    }

    private boolean equalsMetadata(@Nullable Map<@NonNull String, @NonNull YamlMetadataDTO> first, @Nullable Map<@NonNull String, @NonNull YamlMetadataDTO> second) {
        if (first != null && second != null) {
            if (first.size() != second.size()) {
                return false;
            }
            return first.entrySet().stream().allMatch(e -> ((YamlMetadataDTO)e.getValue()).equals(second.get(e.getKey())));
        }
        return first == null && second == null;
    }
}

