/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap;

public final class OptionNumberRegistry {
    public static final int UNKNOWN = -1;
    public static final int RESERVED_0 = 0;
    public static final int IF_MATCH = 1;
    public static final int URI_HOST = 3;
    public static final int ETAG = 4;
    public static final int IF_NONE_MATCH = 5;
    public static final int URI_PORT = 7;
    public static final int LOCATION_PATH = 8;
    public static final int URI_PATH = 11;
    public static final int CONTENT_FORMAT = 12;
    public static final int MAX_AGE = 14;
    public static final int URI_QUERY = 15;
    public static final int ACCEPT = 17;
    public static final int LOCATION_QUERY = 20;
    public static final int PROXY_URI = 35;
    public static final int PROXY_SCHEME = 39;
    public static final int SIZE1 = 60;
    public static final int RESERVED_1 = 128;
    public static final int RESERVED_2 = 132;
    public static final int RESERVED_3 = 136;
    public static final int RESERVED_4 = 140;
    public static final int OBSERVE = 6;
    public static final int BLOCK2 = 23;
    public static final int BLOCK1 = 27;
    public static final int SIZE2 = 28;
    public static final int OSCORE = 9;
    public static final int NO_RESPONSE = 258;

    public static boolean isCritical(int optionNumber) {
        return (optionNumber & 1) != 0;
    }

    public static boolean isElective(int optionNumber) {
        return (optionNumber & 1) == 0;
    }

    public static boolean isUnsafe(int optionNumber) {
        return (optionNumber & 2) > 0;
    }

    public static boolean isSafe(int optionNumber) {
        return !OptionNumberRegistry.isUnsafe(optionNumber);
    }

    public static boolean isNoCacheKey(int optionNumber) {
        return (optionNumber & 0x1E) == 28;
    }

    public static boolean isCacheKey(int optionNumber) {
        return !OptionNumberRegistry.isNoCacheKey(optionNumber);
    }

    public static boolean isUriOption(int optionNumber) {
        boolean result = optionNumber == 3 || optionNumber == 11 || optionNumber == 7 || optionNumber == 15;
        return result;
    }

    private OptionNumberRegistry() {
    }

    public static enum OptionFormat {
        INTEGER,
        STRING,
        OPAQUE,
        UNKNOWN,
        EMPTY;

    }

    public static class Defaults {
        public static final long MAX_AGE = 60L;
    }

    public static class Names {
        public static final String Reserved = "Reserved";
        public static final String If_Match = "If-Match";
        public static final String Uri_Host = "Uri-Host";
        public static final String ETag = "ETag";
        public static final String If_None_Match = "If-None-Match";
        public static final String Uri_Port = "Uri-Port";
        public static final String Location_Path = "Location-Path";
        public static final String Uri_Path = "Uri-Path";
        public static final String Content_Format = "Content-Format";
        public static final String Max_Age = "Max-Age";
        public static final String Uri_Query = "Uri-Query";
        public static final String Accept = "Accept";
        public static final String Location_Query = "Location-Query";
        public static final String Proxy_Uri = "Proxy-Uri";
        public static final String Proxy_Scheme = "Proxy-Scheme";
        public static final String Size1 = "Size1";
        public static final String Observe = "Observe";
        public static final String Block2 = "Block2";
        public static final String Block1 = "Block1";
        public static final String Size2 = "Size2";
        public static final String Object_Security = "Object-Security";
        public static final String No_Response = "No-Response";
    }
}

