/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap.option;

import org.eclipse.californium.core.coap.option.IntegerOptionDefinition;

public class IntegerRangeOptionDefinition
extends IntegerOptionDefinition {
    private final long min;
    private final long max;

    public IntegerRangeOptionDefinition(int number, String name, long min, long max) {
        this(number, name, true, min, max);
    }

    public IntegerRangeOptionDefinition(int number, String name, boolean singleValue, long min, long max) {
        super(number, name, singleValue, null);
        if (min <= max) {
            this.min = min;
            this.max = max;
        } else {
            this.min = max;
            this.max = min;
        }
    }

    @Override
    public void assertValue(byte[] value) {
        long number = IntegerRangeOptionDefinition.getLongValue(value);
        if (number < this.min) {
            throw new IllegalArgumentException("Option " + this.getName() + " value " + number + " must be at least " + this.min + ".");
        }
        if (number > this.max) {
            throw new IllegalArgumentException("Option " + this.getName() + " value " + number + "  must be at most " + this.max + ".");
        }
    }
}

