/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.LocationData;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.ILocationInFileProviderExtension;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.compiler.output.TreeAppendable;

public class TreeAppendableUtil {
    @Inject
    private ILocationInFileProvider locationProvider;

    public ITreeAppendable traceSignificant(ITreeAppendable appendable, EObject source) {
        return this.traceSignificant(appendable, source, false);
    }

    public ITreeAppendable traceSignificant(ITreeAppendable appendable, EObject source, boolean useForDebugging) {
        if (appendable instanceof TreeAppendable) {
            return ((TreeAppendable)appendable).trace(source, ILocationInFileProviderExtension.RegionDescription.SIGNIFICANT, useForDebugging);
        }
        ITextRegionWithLineInformation it = (ITextRegionWithLineInformation)this.locationProvider.getSignificantTextRegion(source);
        if (it != null && it != ITextRegion.EMPTY_REGION) {
            return appendable.trace((ILocationData)new LocationData(it.getOffset(), it.getLength(), it.getLineNumber(), it.getEndLineNumber(), null), useForDebugging);
        }
        return appendable;
    }

    public ITreeAppendable traceWithComments(ITreeAppendable appendable, EObject source) {
        ITextRegionWithLineInformation it;
        if (appendable instanceof TreeAppendable) {
            return ((TreeAppendable)appendable).trace(source, ILocationInFileProviderExtension.RegionDescription.INCLUDING_COMMENTS, false);
        }
        if (this.locationProvider instanceof ILocationInFileProviderExtension) {
            ILocationInFileProviderExtension locationInFileProviderExtension = (ILocationInFileProviderExtension)this.locationProvider;
            it = (ITextRegionWithLineInformation)locationInFileProviderExtension.getTextRegion(source, ILocationInFileProviderExtension.RegionDescription.INCLUDING_COMMENTS);
        } else {
            it = (ITextRegionWithLineInformation)this.locationProvider.getFullTextRegion(source);
        }
        if (it != null && it != ITextRegion.EMPTY_REGION) {
            return appendable.trace((ILocationData)new LocationData(it.getOffset(), it.getLength(), it.getLineNumber(), it.getEndLineNumber(), null));
        }
        return appendable;
    }
}

