/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.core.codeInsight;

import com.intellij.configurationStore.StoreUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryConfigurator;
import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryManager;
import com.intellij.javascript.nodejs.settings.NodeCoreSourcesView;
import com.intellij.javascript.nodejs.settings.NodeSettingsConfigurable;
import com.intellij.model.SideEffectGuard;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NullableConsumer;
import com.intellij.util.PlatformUtils;
import com.intellij.util.text.SemVer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToggleNodeCoreCodingAssistanceAction
extends ToggleAction
implements DumbAware {
    private static final Key<Boolean> ENABLING_IN_PROGRESS = Key.create((String)"Coding assistance enabling is in progress");

    public boolean isSelected(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ToggleNodeCoreCodingAssistanceAction.$$$reportNull$$$0(0);
        }
        return (project = e.getProject()) != null && (NodeCoreLibraryManager.getInstance(project).hasAssociatedRoots() || ToggleNodeCoreCodingAssistanceAction.isEnablingInProgress(project));
    }

    private static boolean isEnablingInProgress(@NotNull Project project) {
        if (project == null) {
            ToggleNodeCoreCodingAssistanceAction.$$$reportNull$$$0(1);
        }
        return Boolean.TRUE.equals(project.getUserData(ENABLING_IN_PROGRESS));
    }

    private static void setEnablingInProgress(@NotNull Project project, boolean enablingInProgress) {
        if (project == null) {
            ToggleNodeCoreCodingAssistanceAction.$$$reportNull$$$0(2);
        }
        project.putUserData(ENABLING_IN_PROGRESS, (Object)(enablingInProgress ? Boolean.TRUE : null));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ToggleNodeCoreCodingAssistanceAction.$$$reportNull$$$0(3);
        }
        return actionUpdateThread;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Project project;
        if (e == null) {
            ToggleNodeCoreCodingAssistanceAction.$$$reportNull$$$0(4);
        }
        if ((project = e.getProject()) != null) {
            if (state) {
                ToggleNodeCoreCodingAssistanceAction.enableNodeCoreLibrary(project, null);
            } else {
                NodeCoreLibraryConfigurator.getInstance(project).disable();
            }
        }
    }

    public static void enableNodeCoreLibrary(@NotNull Project project, @Nullable VirtualFile requestor) {
        if (project == null) {
            ToggleNodeCoreCodingAssistanceAction.$$$reportNull$$$0(5);
        }
        SideEffectGuard.checkSideEffectAllowed((SideEffectGuard.EffectType)SideEffectGuard.EffectType.PROJECT_MODEL);
        NodeJsInterpreter interpreter2 = NodeJsInterpreterManager.getInstance(project).getInterpreter();
        if (interpreter2 == null) {
            NodeSettingsConfigurable.showSettingsDialog(project, requestor);
            return;
        }
        ModalityState modalityState = ModalityState.current();
        interpreter2.provideCachedVersionOrFetch((NullableConsumer<? super SemVer>)((NullableConsumer)version2 -> ApplicationManager.getApplication().invokeLater(() -> {
            if (version2 != null) {
                ToggleNodeCoreCodingAssistanceAction.setEnablingInProgress(project, true);
                NodeCoreSourcesView.enableCodeAssistance(project, interpreter2, version2, requestor, () -> {
                    ToggleNodeCoreCodingAssistanceAction.setEnablingInProgress(project, false);
                    if (PlatformUtils.isFleetBackend()) {
                        StoreUtil.saveSettings((ComponentManager)project, (boolean)true);
                    }
                });
            } else {
                NodeSettingsConfigurable.showSettingsDialog(project, requestor);
            }
        }, modalityState, project.getDisposed())));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/core/codeInsight/ToggleNodeCoreCodingAssistanceAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/core/codeInsight/ToggleNodeCoreCodingAssistanceAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isEnablingInProgress";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setEnablingInProgress";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "enableNodeCoreLibrary";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

