/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import java.util.concurrent.atomic.AtomicLongArray;

public final class AtomicLongRingArray {
    private static final int CACHE_SIZE = 5;
    private final AtomicLongArray myElements = new AtomicLongArray(5);

    public boolean hasLong(long id) {
        for (int i = 0; i < this.myElements.length(); ++i) {
            long stored = this.myElements.get(i);
            if (stored != id) continue;
            return true;
        }
        return false;
    }

    public synchronized void addLong(long id) {
        for (int i = 0; i < this.myElements.length(); ++i) {
            long current = this.myElements.get(i);
            if (current == id) {
                return;
            }
            if (current != 0L) continue;
            this.myElements.set(i, id);
            if (i < 4) {
                this.myElements.set(i + 1, 0L);
            } else {
                this.myElements.set(0, 0L);
            }
            return;
        }
    }
}

