/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.inline;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.refactoring.ES6ReferenceExpressionsInfo;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.presentable.Capitalization;
import com.intellij.lang.javascript.presentable.JSNamedElementPresenter;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDestructuringShorthandedProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSTextReference;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.JSRefactoringSettings;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.refactoring.inline.JSFunctionInliner;
import com.intellij.lang.javascript.refactoring.inline.JSVarOrFieldInliner;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringConflictsUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.refactoring.InlineActionHandler;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.GenericInlineHandler;
import com.intellij.refactoring.inline.InlineOptionsDialog;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSInlineHandler
extends InlineActionHandler {
    private final boolean mySuppressDialog;

    public JSInlineHandler(boolean suppressDialog) {
        this.mySuppressDialog = suppressDialog;
    }

    public JSInlineHandler() {
        this(false);
    }

    public boolean isEnabledForLanguage(Language l) {
        return l.isKindOf((Language)JavascriptLanguage.INSTANCE);
    }

    public boolean canInlineElement(PsiElement element2) {
        return element2 instanceof JSElement;
    }

    public void inlineElement(Project project, Editor editor, PsiElement originalElement) {
        PsiReference invocationReference = editor != null ? TargetElementUtil.findReference((Editor)editor) : null;
        PsiElement elementToInline = JSInlineHandler.adjustElementToInline(originalElement, invocationReference);
        Settings settings = this.prepareInlineElement(elementToInline, editor, invocationReference);
        if (settings == null) {
            return;
        }
        Inliner inliner = this.createInliner(settings, elementToInline);
        if (inliner == null) {
            return;
        }
        Collection<PsiReference> allReferences = settings.isOnlyOneReferenceToInline() ? Collections.singleton(invocationReference) : settings.getUsages();
        MultiMap conflicts = new MultiMap();
        for (PsiReference reference : allReferences) {
            inliner.checkConflicts(reference, (MultiMap<PsiElement, String>)conflicts);
        }
        if (!BaseRefactoringProcessor.processConflicts((Project)project, (MultiMap)conflicts)) {
            return;
        }
        List toCheckForReadonly = ContainerUtil.mapNotNull(allReferences, PsiReference::getElement);
        if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project, (Collection)toCheckForReadonly, (boolean)true)) {
            return;
        }
        String elementName = elementToInline instanceof PsiNamedElement ? ((PsiNamedElement)elementToInline).getName() : "element";
        SmartPsiElementPointer pointer = SmartPointerManager.createPointer((PsiElement)elementToInline);
        WriteCommandAction.runWriteCommandAction((Project)project, (String)RefactoringBundle.message((String)"inline.command", (Object[])new Object[]{elementName}), null, () -> {
            String refactoringId = inliner.getRefactoringId();
            try {
                JSRefactoringUtil.registerRefactoringUndo(project, refactoringId);
                Object[] references = GenericInlineHandler.sortDepthFirstRightLeftOrder((Collection)allReferences);
                HashSet<PsiFile> filesToOptimizeImports = new HashSet<PsiFile>();
                List usages = ContainerUtil.map((Object[])references, UsageInfo::new);
                JSInlineHandler.beforeInvoke(project, elementToInline, usages, refactoringId);
                for (UsageInfo usage : usages) {
                    PsiElement replacement = inliner.inlineUsage(usage);
                    if (replacement == null) continue;
                    filesToOptimizeImports.add(replacement.getContainingFile());
                }
                for (PsiFile file : filesToOptimizeImports) {
                    ES6CreateImportUtil.optimizeImports((PsiElement)file);
                }
                if (!settings.isOnlyOneReferenceToInline()) {
                    PsiElement element2;
                    if (editor != null) {
                        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                    }
                    if ((element2 = pointer.getElement()) != null) {
                        inliner.removeDefinition(element2);
                    }
                }
            }
            finally {
                JSInlineHandler.afterInvoke(project, (SmartPsiElementPointer<PsiElement>)pointer, refactoringId);
            }
        }, (PsiFile[])new PsiFile[0]);
    }

    private static void beforeInvoke(@NotNull Project project, @NotNull PsiElement elementToInline, @NotNull List<? extends UsageInfo> usages, @NotNull String refactoringId) {
        if (project == null) {
            JSInlineHandler.$$$reportNull$$$0(0);
        }
        if (elementToInline == null) {
            JSInlineHandler.$$$reportNull$$$0(1);
        }
        if (usages == null) {
            JSInlineHandler.$$$reportNull$$$0(2);
        }
        if (refactoringId == null) {
            JSInlineHandler.$$$reportNull$$$0(3);
        }
        RefactoringEventData eventData = new RefactoringEventData();
        eventData.addElement(elementToInline);
        eventData.addUsages(usages);
        ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted(refactoringId, eventData);
    }

    private static void afterInvoke(@NotNull Project project, @NotNull SmartPsiElementPointer<PsiElement> pointer, @NotNull String refactoringId) {
        if (project == null) {
            JSInlineHandler.$$$reportNull$$$0(4);
        }
        if (pointer == null) {
            JSInlineHandler.$$$reportNull$$$0(5);
        }
        if (refactoringId == null) {
            JSInlineHandler.$$$reportNull$$$0(6);
        }
        RefactoringEventData eventData = new RefactoringEventData();
        eventData.addElement(pointer.getElement());
        ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(refactoringId, eventData);
    }

    @NotNull
    private static PsiElement adjustElementToInline(@NotNull PsiElement element2, PsiReference invocationReference) {
        JSVariable destructuringElement;
        PsiElement referenceElement;
        PsiElement resolved;
        JSExpression value;
        if (element2 == null) {
            JSInlineHandler.$$$reportNull$$$0(7);
        }
        if (element2 instanceof JSProperty && ((JSProperty)element2).isShorthanded() && (value = ((JSProperty)element2).getValue()) instanceof JSReferenceExpression && (resolved = ((JSReferenceExpression)value).resolve()) instanceof JSNamedElement) {
            PsiElement psiElement = resolved;
            if (psiElement == null) {
                JSInlineHandler.$$$reportNull$$$0(8);
            }
            return psiElement;
        }
        if (element2 instanceof TypeScriptFunction) {
            TypeScriptFunction typeScriptFunction = TypeScriptPsiUtil.getLastOverload((TypeScriptFunction)element2);
            if (typeScriptFunction == null) {
                JSInlineHandler.$$$reportNull$$$0(9);
            }
            return typeScriptFunction;
        }
        if (element2 instanceof JSProperty && (referenceElement = invocationReference.getElement()) instanceof JSDestructuringShorthandedProperty && (destructuringElement = ((JSDestructuringShorthandedProperty)referenceElement).getDestructuringElement()) != null) {
            JSVariable jSVariable = destructuringElement;
            if (jSVariable == null) {
                JSInlineHandler.$$$reportNull$$$0(10);
            }
            return jSVariable;
        }
        PsiElement psiElement = element2;
        if (psiElement == null) {
            JSInlineHandler.$$$reportNull$$$0(11);
        }
        return psiElement;
    }

    @Nullable
    protected final Settings prepareInlineElement(@NotNull PsiElement element2, Editor editor, @Nullable PsiReference invocationReference) {
        NotNullLazyValue<Collection<PsiReference>> elementUsages;
        Settings settings;
        if (element2 == null) {
            JSInlineHandler.$$$reportNull$$$0(12);
        }
        if ((settings = this.getSettingsForElement(element2, editor, invocationReference, elementUsages = JSInlineHandler.getDeferredUsagesForElement(element2))) == null) {
            return null;
        }
        int occurenceCount = ((Collection)elementUsages.getValue()).size();
        if (occurenceCount == 0) {
            JSInlineHandler.showErrorHint(element2, editor, JavaScriptBundle.message("javascript.inline.element.is.not.used", new JSNamedElementPresenter(element2, Capitalization.UpperCase).describeWithShortName()));
            return null;
        }
        if (ContainerUtil.find((Iterable)((Iterable)elementUsages.getValue()), reference -> reference.getElement() instanceof JSXmlLiteralExpression) != null) {
            JSInlineHandler.showErrorHint(element2, editor, JavaScriptBundle.message("javascript.refactoring.cannot.inline.jsx.usage", new Object[0]));
            return null;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return settings;
        }
        if (this.mySuppressDialog) {
            return settings;
        }
        JSNamedElementPresenter presenter = new JSNamedElementPresenter(element2, Capitalization.EachWordUpperCase);
        String inlineTitle = JavaScriptBundle.message("javascript.refactoring.inline.dialog.title", presenter.describeElementKind());
        String kind = new JSNamedElementPresenter(element2).describeElementKind();
        String inlineAllText = JavaScriptBundle.message("javascript.refactoring.inline.all.message", kind, occurenceCount + " " + StringUtil.pluralize((String)"occurrence", (int)occurenceCount));
        String inlineThisText = JavaScriptBundle.message("javascript.refactoring.inline.this.only", kind);
        JSInlineOptionsDialog dialog = new JSInlineOptionsDialog(element2, inlineTitle, inlineAllText, inlineThisText, presenter.describeWithShortName(), settings.isInvokedOnReference());
        if (!dialog.showAndGet()) {
            return null;
        }
        settings.setOneRefToInline(dialog.isInlineThisOnly());
        return settings;
    }

    @Nullable
    protected Settings getSettingsForElement(@NotNull PsiElement element2, Editor editor, @Nullable PsiReference invocationReference, NotNullLazyValue<Collection<PsiReference>> elementUsages) {
        if (element2 == null) {
            JSInlineHandler.$$$reportNull$$$0(13);
        }
        if (element2 instanceof JSClass && invocationReference != null && invocationReference.getElement() instanceof JSReferenceExpression && invocationReference.getElement().getParent() instanceof JSCallExpression) {
            JSFunctionInliner.inlineFunctionProblem(JavaScriptBundle.message("javascript.refactoring.cannot.inline.constructor", new Object[0]), editor, element2.getProject());
            return null;
        }
        boolean invokedOnReference = invocationReference != null && (!(invocationReference instanceof JSReferenceExpression) || !JSResolveUtil.isSelfReference((PsiElement)((JSReferenceExpression)invocationReference)));
        JSFunction function = JSPsiImplUtils.getPossibleFunction(element2);
        if (function != null) {
            return JSFunctionInliner.handleFunction(function, editor, invokedOnReference, elementUsages);
        }
        if (element2 instanceof JSVariable) {
            return JSVarOrFieldInliner.handleVariable((JSVariable)element2, editor, invocationReference, elementUsages, invokedOnReference);
        }
        return null;
    }

    @NotNull
    private static NotNullLazyValue<Collection<PsiReference>> getDeferredUsagesForElement(@NotNull PsiElement element2) {
        if (element2 == null) {
            JSInlineHandler.$$$reportNull$$$0(14);
        }
        NotNullLazyValue notNullLazyValue = NotNullLazyValue.lazy(() -> {
            ArrayList referenceCollection = new ArrayList();
            boolean completed = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                SearchScope useScope = (SearchScope)ReadAction.compute(() -> element2.getUseScope());
                ReferencesSearch.search((PsiElement)element2, (SearchScope)useScope).forEach(psiReference -> {
                    if (psiReference.getElement().getParent() != element2 && JSInlineHandler.isInlinableReference(psiReference)) {
                        referenceCollection.add(psiReference);
                    }
                    return true;
                });
            }, JavaScriptBundle.message("javascript.refactoring.searching.usages", new Object[0]), true, (Project)ReadAction.compute(() -> element2.getProject()));
            if (!completed) {
                throw new ProcessCanceledException();
            }
            return referenceCollection;
        });
        if (notNullLazyValue == null) {
            JSInlineHandler.$$$reportNull$$$0(15);
        }
        return notNullLazyValue;
    }

    static void showErrorHint(@NotNull PsiElement element2, @Nullable Editor editor, @NlsContexts.DialogMessage @NotNull String message) {
        if (element2 == null) {
            JSInlineHandler.$$$reportNull$$$0(16);
        }
        if (message == null) {
            JSInlineHandler.$$$reportNull$$$0(17);
        }
        CommonRefactoringUtil.showErrorHint((Project)element2.getProject(), (Editor)editor, (String)message, (String)RefactoringBundle.message((String)"inline.title"), null);
    }

    public static boolean isInlinableReference(PsiReference psiReference) {
        return (!(psiReference instanceof JSTextReference) || !psiReference.isSoft()) && !(psiReference.getElement() instanceof ES6ImportExportDeclarationPart);
    }

    @Nullable
    protected Inliner createInliner(@NotNull Settings settings, @NotNull PsiElement elementToInline) {
        JSFunction function;
        if (settings == null) {
            JSInlineHandler.$$$reportNull$$$0(18);
        }
        if (elementToInline == null) {
            JSInlineHandler.$$$reportNull$$$0(19);
        }
        if ((function = JSPsiImplUtils.getPossibleFunction(elementToInline)) != null) {
            return new JSFunctionInliner(elementToInline, function);
        }
        if (elementToInline instanceof JSVariable) {
            return new JSVarOrFieldInliner((JSVariable)elementToInline, (JSVarOrFieldInliner.MySettings)settings);
        }
        return null;
    }

    static void checkES6ModuleConflicts(@NotNull ES6ReferenceExpressionsInfo info, @NotNull JSQualifiedNamedElement member, @Nullable PsiElement usageModule, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (info == null) {
            JSInlineHandler.$$$reportNull$$$0(20);
        }
        if (member == null) {
            JSInlineHandler.$$$reportNull$$$0(21);
        }
        if (conflicts == null) {
            JSInlineHandler.$$$reportNull$$$0(22);
        }
        if (usageModule == ES6PsiUtil.findExternalModule((PsiElement)member)) {
            return;
        }
        ES6ReferenceExpressionsInfo.addValidations(info, member, (Condition<? super PsiElement>)((Condition)t -> PsiTreeUtil.isAncestor((PsiElement)member, (PsiElement)t, (boolean)false)), conflicts);
    }

    public static void deleteElementWithReformat(@NotNull PsiElement element2) {
        if (element2 == null) {
            JSInlineHandler.$$$reportNull$$$0(23);
        }
        FormatFixer.Mode mode = FormatFixer.Mode.InSpecifiedRangeMakeFormatterWorkAndLeaveWsBeforeAndAfterIntact;
        FormatFixer fixer = FormatFixer.create(element2, mode);
        element2.delete();
        fixer.fixFormat();
    }

    static void deleteSourceElementRange(@NotNull JSSourceElement start, @NotNull JSSourceElement end) {
        if (start == null) {
            JSInlineHandler.$$$reportNull$$$0(24);
        }
        if (end == null) {
            JSInlineHandler.$$$reportNull$$$0(25);
        }
        FormatFixer.Mode mode = FormatFixer.Mode.InSpecifiedRangeMakeFormatterWorkAndLeaveWsBeforeAndAfterIntact;
        FormatFixer fixer = FormatFixer.create((PsiElement)start, (PsiElement)end, mode);
        start.getParent().deleteChildRange((PsiElement)start, (PsiElement)end);
        fixer.fixFormat();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToInline";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refactoringId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/inline/JSInlineHandler";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/inline/JSInlineHandler";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustElementToInline";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeferredUsagesForElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeInvoke";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "afterInvoke";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "adjustElementToInline";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "prepareInlineElement";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSettingsForElement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDeferredUsagesForElement";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "showErrorHint";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createInliner";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "checkES6ModuleConflicts";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "deleteElementWithReformat";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "deleteSourceElementRange";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11, 15 -> new IllegalStateException(string);
        };
    }

    protected static class Settings {
        private final NotNullLazyValue<Collection<PsiReference>> myDeferredUsages;
        private boolean myOneRefToInline;
        private final boolean myInvokedOnReference;

        public Settings(NotNullLazyValue<Collection<PsiReference>> deferredUsages, boolean invokedOnReference) {
            this.myDeferredUsages = deferredUsages;
            this.myInvokedOnReference = invokedOnReference;
            this.myOneRefToInline = invokedOnReference;
        }

        public boolean isOnlyOneReferenceToInline() {
            return this.myOneRefToInline;
        }

        public void setOneRefToInline(boolean oneRefToInline) {
            this.myOneRefToInline = oneRefToInline;
        }

        @NotNull
        public Collection<PsiReference> getUsages() {
            Collection collection = (Collection)this.myDeferredUsages.getValue();
            if (collection == null) {
                Settings.$$$reportNull$$$0(0);
            }
            return collection;
        }

        public boolean isInvokedOnReference() {
            return this.myInvokedOnReference;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/inline/JSInlineHandler$Settings", "getUsages"));
        }
    }

    public static abstract class Inliner {
        @NotNull
        private final PsiElement myDeclaration;
        @NotNull
        private final ES6ReferenceExpressionsInfo myReferenceExpressionsInfo;
        @Nullable
        private final PsiElement myDeclarationModule;

        protected abstract String getRefactoringId();

        protected Inliner(@NotNull PsiElement declaration) {
            if (declaration == null) {
                Inliner.$$$reportNull$$$0(0);
            }
            this.myDeclaration = declaration;
            this.myDeclarationModule = ES6PsiUtil.findExternalModule(declaration);
            this.myReferenceExpressionsInfo = ES6ReferenceExpressionsInfo.getInfo(declaration);
        }

        protected void checkConflicts(@NotNull PsiReference reference, @NotNull MultiMap<PsiElement, String> conflicts) {
            PsiElement referenceElement;
            if (reference == null) {
                Inliner.$$$reportNull$$$0(1);
            }
            if (conflicts == null) {
                Inliner.$$$reportNull$$$0(2);
            }
            if (!((referenceElement = reference.getElement()) instanceof JSReferenceExpression) || JSResolveUtil.isSelfReference(referenceElement)) {
                return;
            }
            this.checkReadAccess(conflicts, referenceElement);
            if (this.myDeclaration instanceof JSAttributeListOwner && JSUtils.isMember(this.myDeclaration)) {
                JSRefactoringConflictsUtil.checkClassMemberAccessibilityConflicts(reference.getElement(), (JSAttributeListOwner)this.myDeclaration, JSVisibilityUtil.DEFAULT_OPTIONS, conflicts);
            }
            if (this.myDeclaration instanceof JSQualifiedNamedElement) {
                JSInlineHandler.checkES6ModuleConflicts(this.getReferenceExpressionsInfo(referenceElement), (JSQualifiedNamedElement)this.myDeclaration, ES6PsiUtil.findExternalModule(referenceElement), conflicts);
            }
        }

        protected void checkReadAccess(@NotNull MultiMap<PsiElement, String> conflicts, PsiElement referenceElement) {
            if (conflicts == null) {
                Inliner.$$$reportNull$$$0(3);
            }
            if (JSReadWriteAccessDetector.ourInstance.getExpressionAccess(referenceElement) != ReadWriteAccessDetector.Access.Read) {
                conflicts.putValue((Object)referenceElement, (Object)JavaScriptBundle.message("javascript.refactoring.variable.used.as.lvalue", new Object[0]));
            }
        }

        @Nullable
        final PsiElement inlineUsage(@NotNull UsageInfo usage) {
            PsiElement usageElement;
            if (usage == null) {
                Inliner.$$$reportNull$$$0(4);
            }
            if (!((usageElement = usage.getElement()) instanceof JSReferenceExpression) || JSResolveUtil.isSelfReference(usageElement)) {
                return null;
            }
            PsiElement usageModule = ES6PsiUtil.findExternalModule(usageElement);
            JSInlineHandlerResult result2 = (JSInlineHandlerResult)JSTypeEvaluationLocationProvider.withTypeEvaluationLocation(this.myDeclaration, () -> this.doInlineUsage((JSReferenceExpression)usageElement));
            if (result2.isSucceeded() && usageModule != null && !usageModule.isEquivalentTo(this.myDeclarationModule)) {
                for (Map.Entry<PsiElement, String> toImport : result2.getAdditionalElementsToImport().entrySet()) {
                    PsiElement element2 = toImport.getKey();
                    if (!(element2 instanceof JSQualifiedNamedElement)) continue;
                    ES6CreateImportUtil.insertImport(usageModule, (JSQualifiedNamedElement)toImport.getKey(), toImport.getValue());
                }
                ES6CreateImportUtil.addRequiredImports(this.getReferenceExpressionsInfo(usageElement), usageModule);
            }
            return result2.getElement();
        }

        @NotNull
        abstract JSInlineHandlerResult doInlineUsage(@NotNull JSReferenceExpression var1);

        @NotNull
        protected ES6ReferenceExpressionsInfo getReferenceExpressionsInfo(@NotNull PsiElement referenceElement) {
            if (referenceElement == null) {
                Inliner.$$$reportNull$$$0(5);
            }
            ES6ReferenceExpressionsInfo eS6ReferenceExpressionsInfo = this.myReferenceExpressionsInfo;
            if (eS6ReferenceExpressionsInfo == null) {
                Inliner.$$$reportNull$$$0(6);
            }
            return eS6ReferenceExpressionsInfo;
        }

        protected void removeDefinition(@NotNull PsiElement element2) {
            if (element2 == null) {
                Inliner.$$$reportNull$$$0(7);
            }
            JSInlineHandler.deleteElementWithReformat(element2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "declaration";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "conflicts";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usage";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceElement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/refactoring/inline/JSInlineHandler$Inliner";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/refactoring/inline/JSInlineHandler$Inliner";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferenceExpressionsInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "checkConflicts";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "checkReadAccess";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "inlineUsage";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getReferenceExpressionsInfo";
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "removeDefinition";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6 -> new IllegalStateException(string);
            };
        }

        public static final class JSInlineHandlerResult {
            static final JSInlineHandlerResult EMPTY = new JSInlineHandlerResult();
            private final PsiElement myElement;
            private final Map<PsiElement, String> myAdditionalElementsToImport;

            JSInlineHandlerResult() {
                this(null, Collections.emptyMap());
            }

            JSInlineHandlerResult(@Nullable PsiElement element2) {
                this(element2, Collections.emptyMap());
            }

            public JSInlineHandlerResult(@Nullable PsiElement element2, @NotNull Map<PsiElement, String> additionalElementsToImport) {
                if (additionalElementsToImport == null) {
                    JSInlineHandlerResult.$$$reportNull$$$0(0);
                }
                this.myElement = element2;
                this.myAdditionalElementsToImport = additionalElementsToImport;
            }

            @Nullable
            public PsiElement getElement() {
                return this.myElement;
            }

            @NotNull
            public Map<PsiElement, String> getAdditionalElementsToImport() {
                Map<PsiElement, String> map2 = this.myAdditionalElementsToImport;
                if (map2 == null) {
                    JSInlineHandlerResult.$$$reportNull$$$0(1);
                }
                return map2;
            }

            boolean isSucceeded() {
                return this.myElement != null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "additionalElementsToImport";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/refactoring/inline/JSInlineHandler$Inliner$JSInlineHandlerResult";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/refactoring/inline/JSInlineHandler$Inliner$JSInlineHandlerResult";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAdditionalElementsToImport";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }
    }

    private static class JSInlineOptionsDialog
    extends InlineOptionsDialog {
        private final @NlsContexts.RadioButton String myInlineAllText;
        private final @NlsContexts.RadioButton String myInlineThisText;
        private final @NlsContexts.Label String myNameLabelText;

        protected JSInlineOptionsDialog(PsiElement element2, @NlsContexts.DialogTitle String title, @NlsContexts.RadioButton String inlineAllText, @NlsContexts.RadioButton String inlineThisText, @NlsContexts.Label String nameLabelText, boolean isInvokedOnReference) {
            super(element2.getProject(), true, element2);
            this.myInlineAllText = inlineAllText;
            this.myInlineThisText = inlineThisText;
            this.myNameLabelText = nameLabelText;
            this.myInvokedOnReference = isInvokedOnReference;
            this.setTitle(title);
            this.init();
        }

        protected String getNameLabelText() {
            return this.myNameLabelText;
        }

        protected String getBorderTitle() {
            return RefactoringBundle.message((String)"inline.title");
        }

        protected String getInlineAllText() {
            return this.myInlineAllText;
        }

        protected String getInlineThisText() {
            return this.myInlineThisText;
        }

        protected boolean isInlineThis() {
            return JSRefactoringSettings.getInstance().INLINE_THIS;
        }

        protected void doAction() {
            JSRefactoringSettings settings = JSRefactoringSettings.getInstance();
            if (this.myRbInlineThisOnly.isEnabled() && this.myRbInlineAll.isEnabled()) {
                settings.INLINE_THIS = this.isInlineThisOnly();
            }
            this.close(0);
        }

        protected boolean hasHelpAction() {
            return false;
        }

        protected boolean hasPreviewButton() {
            return false;
        }
    }
}

