/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduceVariable;

import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.refactoring.introduce.BaseIntroduceSettings;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceDialog;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSIntroduceVariableHandler;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSVariableInplaceIntroducerBase;
import com.intellij.lang.javascript.refactoring.introduceVariable.Settings;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Objects;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class JSVariableInplaceIntroducer
extends JSVariableInplaceIntroducerBase {
    private Settings.IntroducedVarType myVarType;
    private final Runnable myCallback;
    private final boolean mySilent;
    private String @Nullable [] myForcedSuggestedNames = null;

    public JSVariableInplaceIntroducer(Project project, Editor editor, JSExpression[] occurrences, JSBaseIntroduceHandler<? extends JSElement, BaseIntroduceSettings, ? extends JSBaseIntroduceDialog> handler, JSBaseIntroduceHandler.BaseIntroduceContext<BaseIntroduceSettings> context2, Runnable callback, boolean silent) {
        super(project, editor, occurrences, (FileType)JavaScriptFileType.INSTANCE, handler, context2);
        this.myVarType = JSIntroduceVariableHandler.getLastIntroduceType(project, this.myDialectOptionHolder);
        this.myCallback = callback;
        this.mySilent = silent;
    }

    protected JComponent getComponent() {
        if (this.mySilent) {
            return null;
        }
        boolean letEnabled = JSIntroduceVariableHandler.varTypeEnabled(this.myDialectOptionHolder, Settings.IntroducedVarType.LET);
        boolean constEnabled = JSIntroduceVariableHandler.varTypeEnabled(this.myDialectOptionHolder, Settings.IntroducedVarType.CONST);
        if (!constEnabled && !letEnabled) {
            return null;
        }
        Settings.IntroducedVarType lastSelected = JSIntroduceVariableHandler.getLastIntroduceType(this.myProject, this.myDialectOptionHolder);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(null);
        ButtonGroup buttonGroup = new ButtonGroup();
        if (letEnabled) {
            JRadioButton letTypeSelector = new JRadioButton(JSVarStatement.VarKeyword.LET.getText());
            this.initTypeSelector(letTypeSelector, 'l', Settings.IntroducedVarType.LET, lastSelected);
            panel.add(letTypeSelector);
            buttonGroup.add(letTypeSelector);
        }
        JRadioButton varTypeSelector = new JRadioButton(JSVarStatement.VarKeyword.VAR.getText());
        this.initTypeSelector(varTypeSelector, 'v', Settings.IntroducedVarType.VAR, lastSelected);
        panel.add(varTypeSelector);
        buttonGroup.add(varTypeSelector);
        if (constEnabled) {
            JRadioButton constTypeSelector = new JRadioButton(JSVarStatement.VarKeyword.CONST.getText());
            this.initTypeSelector(constTypeSelector, 'c', Settings.IntroducedVarType.CONST, lastSelected);
            panel.add(constTypeSelector);
            buttonGroup.add(constTypeSelector);
        }
        return panel;
    }

    private void initTypeSelector(JRadioButton selector, char mnemonic, final Settings.IntroducedVarType newVarType, Settings.IntroducedVarType lastSelected) {
        selector.setFocusable(false);
        selector.setMnemonic(mnemonic);
        selector.setSelected(lastSelected == newVarType);
        selector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JSVariableInplaceIntroducer.this.myVarType = newVarType;
                JSIntroduceVariableHandler.setLastIntroduceType(JSVariableInplaceIntroducer.this.myProject, newVarType);
                try {
                    String[] stringArray;
                    if (JSVariableInplaceIntroducer.this.myNameSuggestions != null) {
                        stringArray = (String[])JSVariableInplaceIntroducer.this.myNameSuggestions.toArray(String[]::new);
                    } else {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = Objects.requireNonNullElse(JSVariableInplaceIntroducer.this.myInitialSettings.getVariableName(), JSNameSuggestionsUtil.getDefaultVariableNameFromEntityKind((PsiElement)JSVariableInplaceIntroducer.this.myElementToRename));
                    }
                    JSVariableInplaceIntroducer.this.myForcedSuggestedNames = stringArray;
                    JSVariableInplaceIntroducer.this.restartInplaceIntroduceTemplate();
                }
                finally {
                    JSVariableInplaceIntroducer.this.myForcedSuggestedNames = null;
                }
            }
        });
    }

    @Override
    protected String @NotNull [] suggestNames(boolean replaceAll, @Nullable JSVariable variable) {
        String[] stringArray = this.myForcedSuggestedNames != null ? this.myForcedSuggestedNames : super.suggestNames(replaceAll, variable);
        if (stringArray == null) {
            JSVariableInplaceIntroducer.$$$reportNull$$$0(0);
        }
        return stringArray;
    }

    @TestOnly
    public void selectVarType(@NotNull Settings.IntroducedVarType varType) {
        if (varType == null) {
            JSVariableInplaceIntroducer.$$$reportNull$$$0(1);
        }
        this.myVarType = varType;
        this.restartInplaceIntroduceTemplate();
    }

    @Override
    protected Settings getInplaceIntroduceSettings(final String name) {
        return new Settings(){

            @Override
            public Settings.IntroducedVarType getIntroducedVarType() {
                return JSVariableInplaceIntroducer.this.myVarType;
            }

            @Override
            public boolean isReplaceAllOccurrences() {
                return JSVariableInplaceIntroducer.this.myInitialSettings.isReplaceAllOccurrences();
            }

            @Override
            public String getVariableName() {
                return name;
            }

            @Override
            public String getVariableType() {
                return JSVariableInplaceIntroducer.this.myInitialSettings.getVariableType();
            }
        };
    }

    protected void performPostIntroduceTasks() {
        super.performPostIntroduceTasks();
        this.myCallback.run();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/introduceVariable/JSVariableInplaceIntroducer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestNames";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/introduceVariable/JSVariableInplaceIntroducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "selectVarType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

